/* ****************************************************************** */
/* Projekt : biblioteka DLL "lc1108a.dll" dla karty LC-011-0812		 */
/* s*******************************************************************/
/* Plik implementacyjny wewntrzny 												 */
/* Header  : "1108int.h"															 */
/* Autor : Krzysztof Mroczek , 1996                                   */
/**********************************************************************/
#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#include <dir.h>
#include <time.h>
#include "lc1108a.h"
#include "1108int.h"

//////////////////////////////////////////////////////////////////////////////
// stae dla funkcji pomiaru czasu
// wartoci przyjte eksperymentalnie dla : 486DX280 i 486DX280-12MHz (bez turbo)
//////////////////////////////////////////////////////////////////////////////
#define P286CONST   200000
#define P386CONST   500000
#define P486CONST	 1000000
#define P586CONST  1500000
#define TSAMPL 3.0 /* czas sampla w us */
//////////////////////////////////////////////////////////////////////////////

 extern CModuleData *ModWsk[3]	; //tablica wskaza do obiektw moduw A,B,C
 extern global GData					; //globalne dane o moduach
 extern HINSTANCE	DLLInst			; // parametr wywoania LibMain
 extern WORD		DLLDseg			; // ~
 extern WORD      DLLHeap			; // ~

extern struct CModuleData *ModPtrAC;
extern struct CModuleData *ModPtrCA;
//////////////////////////////////////////////////////////////////////
 unsigned char maska[]={1,2,4,8,16,32,64,128};
 #define INIKEYGLOB	 3			/* ilo parametrw globalnych w pliku .INI */
 #define INITKEYMOD	 12		/* ilo parametrw dot. moduw w pliku .INI*/
 char config_file[MAXPATH];		/* plik konfiguracyjny */
 char ini_file[]="AMBEX.INI";
 char *SectionTerm = "[LC-";            /* nagwek sekcji dla nowej karty*/
 //////////////////////////////////////////////////////////////////////////
 // nazwy poszczeglnych parametrw z pliku AMBEX.ini
 ///////////////////////////////////////////////////////////////////////////

 char *IniKeyGlob[] =   {
								"PATH",
								"INTTIME",
								"MODULES"
							  };   // STRINGI GLOBALNE DLA LC-011-0812
 char *IniKeyMod[]	 = {
							 "AD_CONVERTER",
							 "AD_CONVTIME",
							 "AD_CONVTABLE",
							 "EXTMEMBUFFER",
							 "MODE",
							 "CLKFREQUENCY",
							 "IRQNUMBER",
							 "DA_CHANNELS",
							 "AD_VMIN",
							 "AD_VMAX",
							 "AD_DMANUMBER",
							 "DA1_VMIN",
							 "DA1_VMAX",
							 "DA2_VMIN",
							 "DA2_VMAX",
							};  //STRINGI MODUOWE DLA LC-011-0812
///////////////////////////////////////////////////////////////////////////
// implementacja klasy zarzdzajacej poszczeglnymi moduami
///////////////////////////////////////////////////////////////////////////
/*
 Konstruktor
 Parametry wejciowe :
  BaseAdres - adres bazowy urzdzenia
*/
CModuleData::CModuleData(unsigned int BaseAdres)
 {
	IsInit	= FALSE					;
	IsLoaded = FALSE					;
	InitError = LC0_OK;
	IsIRQProc = FALSE	;
	IsAsyncOpAC	 = 0					;
	IsAsyncOpCA = 0 ;
	AsyncEnable = 1					;
	SynEnable	 = 0					;
	BreakProc = NULL					;
	ACValid = FALSE					;
	CAValid = FALSE					;
	BaseAdr	= BaseAdres				;
	PSTS1		= 0xff					;
	hexmem = NULL ; ptrex = NULL;
	ExSize = 0;
	InExSize = 0 ; //z pliku ini
	PAC.DevBusy = FALSE ;
	PCA.DevBusy = FALSE ;
	PAC.CTCWord1=0x1010;
	IsConvtable=0;
 }

//////////////////////////////////////////////////////////////////////
// Metoda ->Exit()
// czyszczenie strutury danych z informacjami o module
//////////////////////////////////////////////////////////////////////
void::CModuleData::Exit()
 {
	IsInit = FALSE ;
	IsAsyncOpAC = 0					;
	IsAsyncOpCA = 0					;
	AsyncEnable = 1					;
	SynEnable	 = 0					;
	BreakProc = NULL					;
	ACValid =FALSE;
	CAValid = FALSE;
	hexmem = NULL ; ptrex = NULL;
	ExSize = 0;
	IsIRQProc = FALSE ;
 }

//////////////////////////////////////////////////////////////////////
// destruktor
//////////////////////////////////////////////////////////////////////
CModuleData::~CModuleData()
 {
	IsLoaded = FALSE		;
	InitError=LC0_OK;
	Exit();
 }

//////////////////////////////////////////////////////////////////////
// Metoda ->CheckApp()
//sprawdzenie statusu zadania odwoujcego si do moduu
//////////////////////////////////////////////////////////////////////
 int CModuleData::CheckApp()
 {
	HTASK		 hTask ;
	if(InitError==LC0_BAD_CONFIG)
	 return(LC0_BAD_CONFIG);
	if(!IsLoaded)
	 return(LC0_NO_MODULE);
	if(!IsInit)
	 return LC0_NOT_INIT ;
	hTask = ::GetCurrentTask();
	if(hTask != AppTask)
	  return	LC0_REJECTED ;
	return LC0_OK ;
 }

///////////////////////////////////////////////////////////////////
// Metoda ->CheckModule()
// sprawdza czy rzeczywiscie jest zainstalowany modu
// poprzez badanie istnienia kanau CTC kanal 0
// rezultat : kod bedu lub LC0_OK
///////////////////////////////////////////////////////////////////
char CModuleData::CheckModule()
{
 unsigned char val ;
 unsigned char bster=0x30 , sstat=0x00 ;
 int i,j;
 char err = LC0_OK ;
 ClearCard();
 for(i=0;i<12;i++)
  {
	outportb(BaseAdr+CTC+3 , bster+i);
	for(j=0;j<500;j++);
	outportb(BaseAdr+CTC+3,0xe2);
	val = inportb(BaseAdr+CTC+0);
	if((val & 0x0f)!=sstat+i)
	 {
	  err = LC0_NO_MODULE ;
	  break;
	 }
  }
 ClearCard();
 return(err);
}

//////////////////////////////////////////////////////////////////////
// Metoda ->Reset()
//reset sprztowy karty
//////////////////////////////////////////////////////////////////////
void CModuleData::Reset()
  {
	 int i;
	 PSTS1 &= 0xf7 ;
	 outportb(BaseAdr + STATUS_OUT , PSTS1) ;
	 PSTS1 |= 0x08 ;
	 outportb(BaseAdr + STATUS_OUT , PSTS1) ;
	 for(i=0;i<20;i++)
	  _asm nop ;
	 PSTS1 &= 0xf7 ;
	 outportb(BaseAdr + STATUS_OUT , PSTS1) ;
  }

////////////////////////////////////////////////////////////////////////
// Metoda ->ClearCard()
// inicjacja pocztkowa karty : zerowanie twarde
////////////////////////////////////////////////////////////////////////
void CModuleData::ClearCard()
{
 PSTS1 = 0xf7 ;
 Reset();
 inportb(BaseAdr+DIG_IN);
 Reset();
 CTCInitWrite();
 Reset();
}

/////////////////////////////////////////////////////////////////////////////
// Metoda ->ClearDACs()
// zerowanie przetwornikow C/A podczas pierwszego ladowania biblioteki
// do pamieci
/////////////////////////////////////////////////////////////////////////////
void CModuleData::ClearDACs()
{
 if(CA1_V1 >=0)
  {
	outportb(BaseAdr+DAC1_L,0x00);	outportb(BaseAdr+DAC1_H,0x00); //C/A1
  }
 else
  {
	outportb(BaseAdr+DAC1_L,0x00);	outportb(BaseAdr+DAC1_H,0x08); //C/A1
  }

 if(CA2_V1 >=0)
  {
	outportb(BaseAdr+DAC2_L,0x00);	outportb(BaseAdr+DAC2_H,0x00); //C/A1
  }
 else
  {
	outportb(BaseAdr+DAC2_L,0x00); outportb(BaseAdr+DAC2_H,0x08); //C/A2
  }

}

/////////////////////////////////////////////////////////////////////////
// Metoda ->TimeMeasure()
// funkcja mierzca opnienie softwareowe na czas pojedynczej konwersji A/C
// uwaga !!! dodane 3 us na czas samplowania
/////////////////////////////////////////////////////////////////////////
void CModuleData::TimeMeasure()
{
  unsigned long period,l ;
  double f1,f2,dt,tc;
  struct time t1,t2;

  (GData.WinFlags & WF_CPU286) ? period = P286CONST :
  (GData.WinFlags & WF_CPU386) ? period = P386CONST :
  (GData.WinFlags & WF_CPU486) ? period = P486CONST :
  period= P586CONST ; // domylnie PENTIUM lub jakie badziewie

  gettime(&t1);
	for(l=0;l<period;l++)
	 {
	  _asm nop
	 }
  gettime(&t2);
 f1 = (double)t1.ti_sec + 0.01*(double)t1.ti_hund ;
 f2 = (double)t2.ti_sec + 0.01*(double)t2.ti_hund ;
 dt=f2-f1;
 if(dt==0.0)
  dt = 0.01;
 tc=((double)Tconv) /1000.0 + TSAMPL;
 TSamp = (unsigned long int)(tc*1.0e-06/(dt/(double)period));
}

//////////////////////////////////////////////////////////////////////
// Metoda ->MessageBreak()
//wywoanie funkcji obsugi BREAK
//////////////////////////////////////////////////////////////////////
 void CModuleData::MessageBreak()
 {
	HWND hwnd;
	if(BreakProc==NULL)
	 {
	  ::MessageBeep(-1);
	  hwnd = ::GetActiveWindow();
	  ::MessageBox(hwnd,"LC1108A.DLL message box : LC0_BREAK_EXEC","LC-011-0812 Info",MB_OK);
	 }
	else
	 (*BreakProc)();
 }

//////////////////////////////////////////////////////////////////////
// Metoda ->CTCInitWrite()
// programowanie CTC karty : wartoci pocztkowe
//////////////////////////////////////////////////////////////////////
void CModuleData::CTCInitWrite()//wstpne programowanie CTC k0
{
 outportb(BaseAdr+CTC+3,0x34)	;
 outportb(BaseAdr+CTC ,0x10)	;
 outportb(BaseAdr+CTC ,0x10)	;
 // kanalow uzytkownika nie ruszamy
}

///////////////////////////////////////////////////////////////////////////////
// Metoda ->NormAC()
// normalizacja A/C
///////////////////////////////////////////////////////////////////////////////
void CModuleData::NormAC()
{
 PAC.DevBusy=FALSE;
 ACValid = FALSE ;
}

///////////////////////////////////////////////////////////////////////////////
// Metoda ->NormCA()
// normalizacja C/A
///////////////////////////////////////////////////////////////////////////////
void CModuleData::NormCA()
{
 PCA.DevBusy=FALSE;
 CAValid = FALSE ;
}

///////////////////////////////////////////////////////////////////////////////
// Metoda ->AllocExtMem()
// Alokacja bufora pamici rozszerzonej EXTMEM DLL dla aplikacji
// Rezultat :
// LC0_OK lub kod bdu
///////////////////////////////////////////////////////////////////////////////
char CModuleData::AllocExtMem()
{
  BOOL er=FALSE;
  if(ExMem != 0)
	{
	 hexmem = ::GlobalAlloc(GMEM_MOVEABLE|GMEM_NODISCARD|GMEM_NOCOMPACT|
	 GMEM_LOWER,InExSize);
	 if(hexmem!=NULL)
	  {
		ptrex = (int huge *)(::GlobalLock(hexmem));
		if(ptrex==NULL)
		 er=TRUE;
	  }
	 else
	  {
		er=TRUE;
	  }

	 if(er)
		{
		 hexmem = NULL ; ptrex = NULL;
		 ExSize = 0;
		}
	 else
	  ExSize = InExSize ;
	}
  else
	{
	 hexmem = NULL ; ptrex = NULL;ExSize = 0;
	}
  return LC0_OK ;
}

/////////////////////////////////////////////////////////////////////////
// Metoda ->FreeExtMem()
// Zwolnienie bufora pamici rozszerzonej DLL
/////////////////////////////////////////////////////////////////////////
void CModuleData::FreeExMem()
{
 if((ExMem!=0) && (hexmem != NULL) && (ptrex !=NULL) )
  {
	::GlobalUnlock(hexmem);
	::GlobalFree(hexmem) ;
	ptrex = NULL ; hexmem = NULL;
	ExSize = 0 ;
  }
}

//######################################################################
////////////////////////////////////////////////////////////////////////
// funkcje wewntrzne do odczytu konfiguracji z pliku konfiguracyjnego
////////////////////////////////////////////////////////////////////////
//#######################################################################

/*
 Funkcja 'FindLine'
 Szuka w pliku INI danej linii , gdzie jest podany wzorzec i j zwraca
 Parametry wywoania :
  once : 1 gdy chcemy odczyta lini z grup parametrw oddzielonych ','
  pattern : wzorzec wedug ktregp szukamy linii
  line    : znaleziona linia z wzorcem lub NULL gdy nie ma
  termination : 1 gdy chcemy zale lini z nazw sekcji karty
 Rezultat :
  wskanik na pattern
*/
char * FindLine(int once,FILE *ini , char * pattern , char * line,int termination=1)
{															  // szuka w pliku lini gdzie
 char * r;												  // jest wzorzec i zwraca t
 char l[255],c;											  //lini
 int i,ll=0;
															  // zwraca wskaznik na pattern
 fpos_t pos;
 r = NULL ;
 //odczyt biecego pooenia w pliku
 if(once!=0)
  {
	while(1)
	 {
	  fgetpos(ini,&pos);
	  fgets(l,255,ini);
	  l[strlen(l)-1]='\0';
	  strupr(l);
	  ll=0;
	  if(l[0]=='\0')
		{
		 continue ;
		}
	  for(i=0;i<strlen(l);i++)
		{
		 c=l[i];
		 if(c>0x20 && c< 0x7F)
		 {
		  if(c==';')
			{
			 ll=1;
			 break;
			}
		 }
		}
	  if(ll==1)
		continue;
	  r = strstr(l,pattern);
	  if(r==NULL)
		fseek(ini,(unsigned long)pos,SEEK_SET);
	  else
		strcpy(line,l);
	  return(r);
	 }
  }

 while(fgets(l,255,ini)!=NULL)
  {
	 l[strlen(l)-1]='\0';
	 strupr(l);
	 ll=0;
	 for(i=0;i<strlen(l);i++)
	  {
		c=l[i];
		if(c>0x20 && c< 0x7F)
		{
		 if(c==';')
		  {
			ll=1;
			break;
		  }
		}
	  }
	 if(ll==1)
	  continue;
	 r = strstr(l,pattern);
	 if(r!=NULL)
	  {
		strcpy(line,l);
		break ;
	  }
	 else //czy koniec biecej sekcji dotyczcej danej karty : [LC-
	  {
		if(termination ==1)
		 {
		  l[strlen(SectionTerm)]='\0';
		  r = strstr(l,SectionTerm);
		  if(r!=NULL)
			return(NULL) ;
		 }
	  }
  }
  return(r);
}


//////////////////////////////////////////////////////////////////////
// Funkcja FindParam :
// Wybiera parametr z linii podanej linii : 'Opis' = 'param' <- linia
// Parametry wejciowe :
// line : analizowana linia
// param : odczytany marametr
// Rezultat :
// wskanik na odnaleziony parametr
//////////////////////////////////////////////////////////////////////
char * FindParam(char *line , char *param)
{
 char *r = NULL , tab[255],c ;

 r=strpbrk(line,"=");
 if(r!=NULL)
  {
	r++;
	strcpy(param,r);
	int i , j=0 ;
	for(i=0;i<strlen(param);i++)
	 {
	  c=param[i];
	  if(c>0x20 && c< 0x7F)
		{
		 tab[j++]=c;
		}
	 }
	tab[j]='\0';
	strupr(tab);
	strcpy(param,tab);
	r=param;
  }
 return r ;
}

/////////////////////////////////////////////////////////////////
// Funkcja ParamToInt()
// Odczytanie parametru z biecej linii i przeksztacenie do int
// Parametry wejciowe /wy:
//  ini - handler pliku
//  nr - numer stringu z tablicy parametrw  'IniKeyMod'
// *param - przeksztacony do 'int' parametr
// Rezultat
//  LC0_OK lub kod bdu
/////////////////////////////////////////////////////////////////
int ParamToInt(FILE *ini , int nr ,int *param)
{
 char *wsk,*er ;
 char tab[100],line[255];
 int l;
 char err = LC0_OK ;

 wsk=FindLine(0,ini,IniKeyMod[nr],line)  ;
 if(wsk==NULL)
  err= LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
 else
  {
	wsk=FindParam(line,tab);
	if(wsk==NULL)
	 err= LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
	else
	 {
	  l = (int)strtol(tab,&er,10);
	  if(er==NULL)
		err= LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
	  else
		*param = l;
	  }
  }

 return err ;
}

/////////////////////////////////////////////////////////////////////
// Funkcja ParamToTab()
// Odczytanie "count" parametrw numerycznych oddzielonych ','
// Parametry wejciowe :
//  ini - handler pliku
//  nr  - numer parametru w tablicy 'IniKeyMod'
//  count - ilo parametrw do przeksztacenia (odczytu)
//  table - tablica z parametrami przeksztacanymi
//  once -  1
// Rezultat :
//  LC0_OK lub kod bdu .
//////////////////////////////////////////////////////////////////////
int ParamToTab(FILE *ini , int nr ,int count,unsigned int *table,int once)
{
 char *wsk,*er ;
 char tab[100],line[255];
 int l;
 char err = LC0_OK ;

 wsk=FindLine(once,ini,IniKeyMod[nr],line)  ;//tylko jeden odczyt dla A/C
 if(wsk==NULL) //nie ma : liczymy
  {
	if(once!=0)
	 err= 2 ; //oznacza , e mamy obliczy czasy
	else
	 err=LC0_BAD_CONFIG ; //bdny plik konfiguracyjny
  }
 else
  {
	wsk=FindParam(line,tab);
	if(wsk==NULL)
	 err= LC0_BAD_CONFIG ; //bdny plik konfiguracyjny
	else
	 {
		wsk = tab ;
		int i ;
		for(i=0 ; i<count ; i++)
		 {
		  l = (int)strtol(wsk,&er,10);
		  if(*er == '\0' || *er == ',') //separatory
			{
			  if(*er==',')
				wsk = er+1 ;
			  table[i] = l;
			}
		  else //inny separator
			{
				err= LC0_BAD_CONFIG ; //bdny plik konfiguracyjny
				break ;
			}

		  if((*er=='\0') && (i<count-3)) //za mao parametrw
			{
			 err= LC0_BAD_CONFIG ; //bdny plik konfiguracyjny
			 break ;
			}

		 }

	 }

  }
 return err ;
}

//////////////////////////////////////////////////////////////////////
// Funkcja SearchFile()
// szuka pliku AMBEX.INI i go ewentualnie otwiera
// path - nazwa pliku konfiguracyjnego : "AMBEX.INI"
// Rezultat
//  handler do otwartego pliku lub NULL
//////////////////////////////////////////////////////////////////////
FILE* SearchFile(char *path)
{
	char pbuf[144] ;
	UINT wret ;
	FILE *ini ;

	wret = GetWindowsDirectory((LPSTR)pbuf,sizeof(pbuf));
	if(wret!=0)
	 {
	  if(pbuf[wret-1] != '\\')
		strcat(pbuf,"\\");
	  strcat(pbuf,path);
	  ini = fopen(pbuf,"r");
	  if(ini != NULL)
		{
		  //*path = pbuf ;
		  strcpy(path,pbuf);
		  return ini ;
		}
	 }

	 wret = GetSystemDirectory((LPSTR)pbuf,sizeof(pbuf));
	 if(wret!=0)
	 {
	  if(pbuf[wret-1] != '\\')
		strcat(pbuf,"\\");
	  strcat(pbuf,path);
	  ini = fopen(pbuf,"r");
	  if(ini != NULL)
		{
		  //*path = (LPSTR)pbuf ;
		  strcpy(path,pbuf);
		  return ini ;
		}
	 }

	char *pt;
	pt = searchpath(path);
	if(pt == NULL)
	 {
		return NULL ;
	 }
	else
	 {
	  strcpy(path,pt);
	  ini = fopen(path,"r");
	  return ini ;
	 }
}

//////////////////////////////////////////////////////////////////////
// Funkcja ReadIniFile
// Wczytuje parametry globalne dla wszystkich moduw z pliku konfiguracyjnego
// path - scieka do pliku konfiguracyjnego
// position : zwrcona bieca pozycja w pliku konfiguracyjnym (wzkanik odczytu)
// Rezultat :
//  LC0_OK lub kod bdu
//////////////////////////////////////////////////////////////////////
int ReadIniFile(char *path, unsigned long *position )
{
	FILE *ini	;
	char *wsk , line[255],param[255],*er;
	int l ;
	char err = LC0_OK ;
	fpos_t pos;

	ini = SearchFile(path);
	/*ini = fopen(path,"r");*/
	if(ini==NULL)
	 err = LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
	else
	{
	// UWAGA !!! Wana jest kolejno poszczeglnych linii w pliku AMBEX.ini
	//nagwek
	 wsk = FindLine(0,ini,"[LC-011-0812]",line,0);
	 if(wsk==NULL)
	  err= LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
	 else
	  {     //okrelenie pozycji sekcji
		 fgetpos(ini,&pos);
		 *position =(unsigned long)pos;
	  }
	 wsk=FindLine(0,ini,IniKeyGlob[0],line)  ;			//PATH
	 if(wsk==NULL)
	  err= LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
	 else
	  {
		wsk=FindParam(line,param);
		if(wsk==NULL)
		 err= LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
		else
			strcpy(GData.path,param);
	  }
	 wsk=FindLine(0,ini,IniKeyGlob[1],line)  ;			//INTTIME
	 if(wsk==NULL)
	  err= LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
	 else
	  {
		wsk=FindParam(line,param);
		if(wsk==NULL)
		  err= LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
		else
		  {
			l = (int)strtol(param,&er,10);
			if(er==NULL)
			 err= LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
			else
			 GData.inttime = l;
		  }
	  }
	 wsk=FindLine(0,ini,IniKeyGlob[2],line)  ;			//MODULES
	 if(wsk==NULL)
	  err= LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
	 else
	  {
		wsk=FindParam(line,param);
		if(wsk==NULL)
			 err= LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
		else
		  {
			 l = (int)strtol(param,&er,10);
			 if(er==NULL)
			  err= LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
			 else
			  GData.modules = l;
		  }
	  }
	 // plik na pocztek
	 fseek(ini,0,SEEK_SET);
	 fclose(ini);
	 }
  if(err == LC0_OK)
	GData.globalinit = TRUE ; //tzn. nie ma potrzeby ich ponownego wczytywania
  return err ;
}


///////////////////////////////////////////////////////////////////////////
// Funkcja 'ReadIniModuleAll'
// Odczytuje parametry z pliku konfiguracyjnego (AMBEX.INI) dotyczce wszystkich
// moduw [1]..[4] -> A..D . 'modname'
// przeznaczenie do statycznego adowania przy starcie biblioteki
// path - scieka do pliku INI
// position : pozycja od ktrej naley przeszukiwa plik
// Rezultat :
//  LC0_OK lub kod bedu
//////////////////////////////////////////////////////////////////////////
int ReadIniModuleAll(char *path , unsigned long position)
{
  FILE *ini	;
  char *wsk , line[255];
  int l ;
  char err = LC0_OK ;
  char *num[] = {"[MODULE A]","[MODULE B]","[MODULE C]"};
  int count = 1 ;
  unsigned char modname ; //numer moduu

  ini = fopen(path,"r");
  if(ini==NULL)
	 err = LC0_BAD_CONFIG ; //bdny plik AMBEX.INI
  else
	{
	 fseek(ini,position,SEEK_SET);//cofnicie pliku na pocztek sekcji
	 do
	  {
		//odczyt identyfikatora sekcji , wana kolejno [1] -> [4]

	  wsk = FindLine(0,ini,num[count-1],line) ; //szukamy identyfikatora [MODULE X]
	  if(wsk==NULL) //nie znaleziono
		{
		 err = LC0_NO_MODULE ;
		 fseek(ini,position,SEEK_SET);//cofnicie pliku na pocztek sekcji
		}
	  else
		err=LC0_OK;
	  count++ ;
	  modname=count-1;
	  if(err==LC0_OK) //znaleziono waciw sekcj dla wybranego moduu
		{
		 // czytamy poszczeglne parametry , kolejno konieczna
		 while(1)
		  {
			fgets(line,255,ini);

			err = ParamToInt(ini , 1 ,&l) ;   //TCONV
			if(err==LC0_OK)
			 {
				ModWsk[modname-1]->Tconv = l;
			 }
			else
			 break;

			///////////////////////////////////////////////////////////
			err = ParamToTab(ini , 2 ,AC_CHANNELS,ModWsk[modname-1]->STable,1);
			if(err==2)
			 ModWsk[modname-1]->IsConvtable = 0;
			else
			 {
			  ModWsk[modname-1]->IsConvtable = 1;
			  if(err==LC0_BAD_CONFIG)
				break;
			 }

			err = ParamToInt(ini , 3 ,&l) ; //EXMEM :
			if(err==LC0_OK)
			 {
			  if(l!=0)
				{
				 ModWsk[modname-1]->ExMem = 1;
				 ModWsk[modname-1]->InExSize = (unsigned long int)((unsigned long int)l*1024); //bo w KB
				}
			  else
				{
				 ModWsk[modname-1]->ExMem = 0;
				 ModWsk[modname-1]->InExSize = 0; //bo w KB
				}
			 }
			else
			 break;
			err = ParamToInt(ini , 4 ,&l) ; //MODE : 1 - MASTER reszta - SLAVE
			if(err==LC0_OK)
			 {
			  if(l==1)
				ModWsk[modname-1]->mode = l;
			  else
				ModWsk[modname-1]->mode = 0;
			 }
			else
			 break;

			err = ParamToInt(ini , 5 ,&l) ;   //FREQUENCY MHZ
			if(err==LC0_OK)
			 {
			  if(l==4 || l==8)
				ModWsk[modname-1]->CLK = l;
			  else
				{
				  err = LC0_BAD_CONFIG ;
				  break ;
				}
			 }
			else
			 break;

			err = ParamToInt(ini , 6 ,&l) ;   //IRQ
			if(err==LC0_OK)
			 {
			  if(l==2 || l==3 || l==4 || l==0)
				{
				 ModWsk[modname-1]->IRQ = l;
				 // @@@

				 if(l==0)
				  ModWsk[modname-1]->IRQ = 0xff;
				}
			  else
				{
				  err = LC0_BAD_CONFIG ;
				  break ;
				}
			 }
			else
			 break;

			err = ParamToInt(ini , 7 ,&l) ;   //CHANNELS C/A
			if(err==LC0_OK)
			 {
			  if(l==0 || l==1 || l==2)   // l==0 oznacza brak C/A
				ModWsk[modname-1]->CA_channels = l;
			  else
				{
				  err = LC0_BAD_CONFIG ;
				  break ;
				}
			 }
			else
			 break;

			err = ParamToInt(ini , 8 ,&l) ;   //A/C_V1
			if(err==LC0_OK)
			 {
				ModWsk[modname-1]->AC_V1 = l;
			 }
			else
			 break;

			err = ParamToInt(ini , 9 ,&l) ;   //A/C_V2
			if(err==LC0_OK)
			 {
				ModWsk[modname-1]->AC_V2 = l;
			 }
			else
			 break;

			err = ParamToInt(ini , 10 ,&l) ;   //A/C_DMA
			if(err==LC0_OK)
			 {
			  if(l==1 || l==3 || l==0)       //0 - brak DMA
				{
				 ModWsk[modname-1]->AC_DMA = l;
				 // @@@
				 if(l==0)
				  ModWsk[modname-1]->AC_DMA = 0xff;

				}
			  else
				{
				  err = LC0_BAD_CONFIG ;
				  break ;
				}
			 }
			else
			 break;

			///////////////////////////////////////////////////////////
			if(ModWsk[modname-1]->CA_channels !=0)
			 {
			  err = ParamToInt(ini , 11 ,&l) ;   //C/A1_V1
			  if(err==LC0_OK)
				{
				ModWsk[modname-1]->CA1_V1 = l;
				}
			  else
			  break;
			  err = ParamToInt(ini , 12 ,&l) ;   //C/A1_V2
			  if(err==LC0_OK)
				{
					ModWsk[modname-1]->CA1_V2 = l;
				}
			  else
			  break;
			  if(ModWsk[modname-1]->CA_channels ==2)
				{
				 err = ParamToInt(ini , 13 ,&l) ;   //C/A2_V1
				 if(err==LC0_OK)
				  {
					ModWsk[modname-1]->CA2_V1 = l;
				  }
				 else
				  break;
				 err = ParamToInt(ini , 14 ,&l) ;   //C/A2_V2
				 if(err==LC0_OK)
				  {
				  ModWsk[modname-1]->CA2_V2 = l;
				  }
				 else
				  break;
				}

			 }
			//////////////////////////////////////////////////////////////////
			// pomylne adowanie moduu gdy rzeczywicie istnieje w pamici
			// NIE JEST ROBIONE , BO BYY KARTY Z UKADAMI 8253 !!!
			//////////////////////////////////////////////////////////////////
		  //err = ModWsk[modname-1]->CheckModule();
		  err = LC0_OK ;
		  if(err==LC0_OK)
			{
			 ModWsk[modname-1]->IsLoaded = TRUE ; //zaadowany
			 ModWsk[modname-1]->ClearDACs();
			 ModWsk[modname-1]->TimeMeasure();
			}
			fseek(ini,position,SEEK_SET);
			break;
		  }
		}
		ModWsk[modname-1]->InitError =err ;
	  }//analizuje bldy
	  while(count<4); //3 moduly
	 fclose(ini);
	}
 return err ;
}

//////////////////////////////////////////////////////////////////////
// Funkcja 'LoadParameters'
// Funkcja adujca dane z pliku AMBEX.INI do pamici
// ustawia pole GData.Error
// Jest wywoywana w LibMain()
//////////////////////////////////////////////////////////////////////
void  LoadParameters(void)
{
  char errcode ;
  unsigned long position;

	strcpy(config_file,ini_file)    ;
	errcode = ReadIniFile(config_file,&position);
	if(errcode != LC0_OK) //bdna konfiguracja
	 {
	  GData.Error = errcode ;
	  for(int i=0;i<3;i++)
		{
		 ModWsk[i]->InitError=LC0_BAD_CONFIG;
		}
	  return ;
	 }
  GData.globalinit = TRUE ;
  errcode = ReadIniModuleAll(config_file,position);
  if(errcode==LC0_BAD_CONFIG)
	GData.Error = errcode ;
  else
	GData.Error = LC0_OK ;
}

//////////////////////////////////////////////////////////////////////////
// Funkcja WaitForALevel
// Warunek start od poziomu na wybranym wejciu analogowym
// parametry wejciowe :
//  par[] - tablica z parametrami przetwarzania
//  *errex - dodatkowy kod statusu
//  check - 0 : gdy wywoanie z funkcji LC0_AnalogIn
// Rezultat : kod ststusu
// channel : b0..b5 - nr kanau ;
//			    b6 - 0 - reakcja na zbocze ; 1 - na poziom
//				 b7 - 0 - zbocze opadajce/poniej poziomu
//					   1 - zbocze narastajce/powyej poziomu
// level	: b0..b11 - poziom komparacji wyrazony w kodzie przetwornika
//			: b12..b15 - margines zakce - ilo konwersji A/C na potw. war.startu
//////////////////////////////////////////////////////////////////////////
char WaitForALevel( unsigned char par[],char *errex,int check)
{
 char errcode = LC0_OK ;
 char val ;
 unsigned int level,val16,num,ccount=0 ;
 BOOL type ;
 BOOL value ;

  *errex = LC0_OK ;
 // adaliza skadni
 if((par[0] >= LC0_MODA) && (par[0]<=LC0_MODC))
  {
	errcode = ModWsk[(int)(par[0])-1]->CheckApp() ;
	if(errcode!=LC0_OK)
	 {
		if(errcode == LC0_NO_MODULE)
		 *errex = LC0_E_NO_MODULE ;
		else
		 *errex = LC0_E_MOD_UNABLE ;
		return LC0_ILL_START ;
	 }

	if(check==1)
	  if(ModWsk[par[0]-1]->PAC.DevBusy)
		{
		 *errex = LC0_E_MOD_UNABLE ;
		 return LC0_ILL_START ;
		}

	 if(par[1]!=1)
	  {
		*errex = LC0_E_NONEX_DEV ;
		return LC0_ILL_START;
	  }

	 val = par[2] & 0x3f ;
	 if(val == 0x00 || val > AC_CHANNELS)
	  {
		*errex = LC0_E_BAD_CHAN	;
		return LC0_ILL_START ;
	  }
	 if((par[2] & 0x40) != 0)
	  type = TRUE ;
	 else
	  type = FALSE ;

	 if((par[2] & 0x80) != 0)
	  value = TRUE ;
	 else
	  value = FALSE ;

	level = ((unsigned int)par[4]<<8) + (unsigned int)par[3];
	val16 = level & 0x0fff;
	num = level >>12 ;

  }
 else
  {
	 *errex=LC0_E_NO_MODULE ;
	 return LC0_ILL_START ;
  }

 unsigned char mod = par[0]-1 ;
 unsigned int base = ModWsk[mod]->BaseAdr ;
 unsigned int samp,samppop=0 ;
 unsigned char val1,val2;
 BOOL endp=FALSE,first=TRUE ;
 MSG mes ;

 unsigned char norm = ModWsk[mod]->PSTS1 ;
 unsigned long int J,period =  ModWsk[mod]->TSamp;
 outportb(base+CTC+3,0x34);
 ModWsk[mod]->Reset();
 val1=_EN_3_CHN | _EN_2_CHN | _EN_1_CHN  | _EN_DMA ;
 ModWsk[mod]->PSTS1 = val1;
 outportb(base+STATUS_OUT,val1) ;
 outportb(base+MUX_W,par[2]-1);
 inportb(base+SET_EN_START) ;
 while(1)
  {
	while(1)
	 {
		 outportb(base+ADC_W,0xff);
		 for(J=0;J<period;J++)
		  {
			_asm nop
		  }
		 val1=inportb(base+ADC_R);
		 val2=inportb(base+ADC_R);
		 samp = (val2 <<8)+ val1 ;
		 if(first)
		  first=FALSE;
		 else
		  {
			if(type==FALSE)
			 {
			  if(value==0)  // poniej poziomu val16 na zboczu opadajcym  <b7>
				{
				 if((samp <= samppop))
				  {
					if(samp!=samppop)
					 ccount ++ ;
					if(ccount > num)
					 {
					  if((samp <= val16)&&(samppop >=val16))
						{
						 endp = TRUE ;
						 break ;
						}
					  ccount = num + 1 ;
					 }
				  }
				 else
				  if(ccount > 0)
					ccount --;
				}
			  else         // powyej poziomu  val16 na zboczu narastajcym
				{
				  if(samp >= samppop)
					{
					 if(samp!=samppop)
					  ccount ++ ;
					 if(ccount > num)
					 {
					  if((samp >= val16)&&(samppop <= val16))
						{
						 endp = TRUE ;
						 break ;
						}
					  ccount = num + 1 ;
					 }
					}
				  else
					if(ccount >0)
					ccount --;
				}
			 }
			else            //komparator poziomu
			 {
				if(value==0) //poniej poziomu
				 {
				  if(samp <= val16)
					ccount ++ ;
				  else
					ccount = 0;
				 }
				else         //powyej poziomu
				 {
				  if(samp >= val16)
					ccount ++  ;
				  else
					ccount = 0;
				  }
				if(ccount>num)
				 {
				  endp = TRUE ;
				  break ;
				 }
			 }
		  }
		 samppop = samp ;
	  if(ModWsk[mod]->SynEnable)
		{
		 if(IntBreak(&mes)==FALSE)
		  {
			ModWsk[mod]->PSTS1 = norm ;
			outportb(base+STATUS_OUT,ModWsk[mod]->PSTS1);
			ModWsk[mod]->Reset();
			ModWsk[mod]->MessageBreak();
			*errex = LC0_E_BROKEN_WAIT ;
			errcode = LC0_BROKEN ;
			break ;
		  }
		}
	 }
	if((errcode!= LC0_OK) || (endp == TRUE) )
	 break ;
  }
 ModWsk[mod]->PSTS1 = norm;
 ModWsk[mod]->Reset();
 return errcode ;
}

///////////////////////////////////////////////////////////////////////////
// Funkcja WaitForStart()
// Funkcja testujca warunek startu operacji A/C , C/A,Din,Dout
// stst   - typ warunku startu
// par[]  - 4 kolejne parametry unsigned char ze struktury lc0_start
// ptime  - dla typu LC0_STIME warto czasu
// *errex - dodatkowy kod bdu
// MOD    - nr moduu  ktry wywoa funkcj sprawdzania warunkw startu
// check  - 0 gdy wywoanie z funkcji LC0_AnalogIn
// return : kod bdu LC0_STATUS
///////////////////////////////////////////////////////////////////////////
char FAR PASCAL WaitForStart(unsigned char stst , unsigned char par[],
						unsigned long ptime , char *errex,unsigned char MOD,
						int check)
{
  char errcode ;
  BOOL cond = TRUE;
  unsigned char val;
  int modnum ;
  unsigned char mask[] = {0x01,0x02,0x04,0x08};
  unsigned char sday[] ={31,28,31,30,31,30,31,31,30,31,30,31};
  tm *td ;
  time_t t1,t2;
  struct time tt;
  struct date dd;
  MSG mes ;

  BOOL jump = FALSE ;

  *errex = LC0_E_OK ;
  if(stst == LC0_SIMMED)
	return LC0_OK ;
  if(stst == LC0_SHARD )
	return LC0_ILL_START_CODE ;
  if(stst >LC0_SANALOG)
	return LC0_ILL_START_CODE ;

  if(stst == LC0_SANALOG)
	{
	 errcode = WaitForALevel(par,errex,check) ;
	 return errcode ;
	}

  if(stst>=LC0_SLEVEL && stst <=LC0_SDIG_NE)
	{
	 if(par[0]<LC0_MODA || par[0]>LC0_MODC )
	  {
		*errex = LC0_E_NO_MODULE ;
		return LC0_ILL_START;
	  }
	 errcode = ModWsk[(int)(par[0])-1]->CheckApp() ;
	 if(errcode!=LC0_OK)
	  {
		if(errcode == LC0_NO_MODULE)
		 *errex = LC0_E_NO_MODULE ;
		else
		 *errex = LC0_E_MOD_UNABLE ;
		return LC0_ILL_START ;
	  }

	 if(par[1]!=1)
	  {
		*errex = LC0_E_NONEX_DEV ;
		return LC0_ILL_START;
	  }

	 if(stst == LC0_SLEVEL || stst == LC0_SSLOPE)
	  {
		 if((par[2]>8) || (par[2]==0))
		  {
			*errex = LC0_E_NONEX_DEV ;
			return LC0_ILL_START;
		  }
	  }
	 else
	  {
		par[3] = par[3] & par[2] ;
	  }

	 modnum = par[0] -1 ;
	 do
	  {
		 if(ModWsk[MOD-1]->SynEnable)
		  {
			 if(IntBreak(&mes)==FALSE)
			  {
				ModWsk[MOD-1]->MessageBreak();
				cond = FALSE ;
				*errex = LC0_E_BROKEN_WAIT ;
				return LC0_BROKEN ;
			  }
		  }

		 val=inportb(ModWsk[modnum]->BaseAdr + DIG_IN);
		 switch(stst)
		  {
			 case	LC0_SLEVEL		:
										 val = val & mask[par[2]-1];
										 if(par[3]==0) // "0"
											{
											 if(val==0)
											  cond=FALSE ;
											}
										  else         // "1"
											{
											  if(val!=0)
												cond = FALSE ;
											}
										 break;
			 case	LC0_SSLOPE		:val = val & mask[par[2]-1];
										 if(par[3]!=0)
										  {
											if(!jump)
											 {
												if(val==0)
												 jump = TRUE ;
											 }
											else
											 {
												if(val!=0)
												 cond = FALSE ;
											 }
										  }
										 else
										  {
											if(!jump)
											 {
												if(val!=0)
												 jump = TRUE ;
											 }
											else
											 {
												if(val==0)
												 cond = FALSE ;
											 }
										  }
										 break;
			 case	LC0_SDIG_EQ		:
			 case	LC0_SDIG_NE		:val = val & par[2] ;
										 val = val ^ par[3] ;
										 if(stst==LC0_SDIG_EQ )
											{
											 if(val==0)
											  cond = FALSE ;
											}
										  else
											{
											 if(val!=0)
											 cond = FALSE ;
											}
										 break;

		  }

	  }while(cond==TRUE);

	}
  else                                       //zwizane z czasem
	{
	  if(stst==LC0_SDATE)
		{
		  if((par[0]>=60)||(par[1]>=60)||(par[2]>=24))
			{
			  *errex = LC0_E_BAD_TIME ;
			  return LC0_ILL_START ;
			}
		  t1=time(NULL);
		  td = gmtime(&t1);
		  if(par[3]>sday[td->tm_mon])
			{
			  *errex = LC0_E_BAD_DATE ;
			  return LC0_ILL_START ;
			}
		}

	  t1=time(NULL);
	  do
		{
		 if(ModWsk[MOD-1]->SynEnable)
		  {
			 if(IntBreak(&mes)==FALSE)//przerwano
			  {
				ModWsk[MOD-1]->MessageBreak();
				cond = FALSE ;
				//status przerwania
				*errex = LC0_E_BROKEN_WAIT ;
				return LC0_BROKEN ;
			  }
		  }

		 t2=time(NULL);
		 if(stst==LC0_STIME)
		  {
			 if(difftime(t2,t1)>=ptime)
			  {
				cond = FALSE ;
			  }
		  }
		 else
		  {
			  getdate(&dd);
			  gettime(&tt);
			  if((dd.da_day==par[3]) && (tt.ti_hour==par[2]) && (tt.ti_min==par[1])
			  && (tt.ti_sec==par[0]))
				{
				  cond = FALSE ;
				}
		  }
		}while(cond==TRUE);
	}

 return LC0_OK ;
}

///////////////////////////////////////////////////////////////////////////////
// Funkcja IntBreak
// Wewntrzna procedura monitorowania warunkw startu i operacji synchronicznych
// Wejcie : wskaznik do struktury opisu komunikatu
// Wyjcie : TRUE gdy nie przerwana FALSE - przerwanie
////////////////////////////////////////////////////////////////////////////////
BOOL IntBreak(MSG *mes)
{
 if(GetAsyncKeyState(KEYBREAK1)& 0x8000)
  {
	 while(::PeekMessage(mes,NULL,WM_KEYFIRST,WM_KEYLAST,PM_REMOVE|PM_NOYIELD))
	 {

	 }
	 while(::PeekMessage(mes,NULL,WM_MOUSEFIRST,WM_MOUSELAST,PM_REMOVE|PM_NOYIELD))
	 {

	 }
	return FALSE ;
  }
  return TRUE ;
}

/////////////////////////////////////////////////////////////////////////
// Funkcja ProgDMA8
// Programowanie kanaw 8-o bitowych DMA 8037A
// kanal - nr kanalu 0..3
// tryb	- 1 - single ; 0-block
// cykl	- 1 - b.cykliczny
// zapis	- 1 - zapis do portu ; 0 - odczyt z portu
// il_b	- ilo bajtw transmisji < 64K
// fadres - adres fizyczny 32-bitowy pocztku bufora
// zwraca warto rejestru strony DMA
/////////////////////////////////////////////////////////////////////////
unsigned char ProgDMA8(int kanal , int tryb , int cykl , int zapis , unsigned int il_b ,
				  unsigned long int fadres)
{
  unsigned  LicznAdrKan    ;
	unsigned  LicznTransmisji ;
	unsigned  RejStrony 	;

	unsigned int RejRozk	;
	unsigned int RejMaskiKan	;
	unsigned int RejTrybu	;
	unsigned int MasterFlipFlop ;
	unsigned char value,c	;
	unsigned int  adres		;
	unsigned char strona		;
	unsigned long real_adr 	;
	unsigned char xxx[10];
	unsigned char maska[]={1,2,4,8,16,32,64,128};
	int j=0,i;

	MasterFlipFlop = 0x0c ;
	RejRozk	  		= 0x08 ;
	RejMaskiKan		= 0x0a ;
	RejTrybu	  		= 0x0b ;

	real_adr = fadres;
	value = 0;
	if(tryb==1)
	 value = 0x40 ;
	else
	 value = 0x80 ;

	if(cykl==1)
	 value = value | maska[4]  ;

	if(zapis==1)
	 value = value | maska[3]  ;
	else
	 value = value | maska[2]  ;
	outportb(RejRozk,0x00);
	switch (kanal)
	 {
		case  0		: 	LicznAdrKan     = 0x00 ;
							LicznTransmisji = 0x01 ;
							RejStrony	  = 0x87 ;
							outportb(RejMaskiKan,0x04) ;
							value = value ;
							break;
		case  1		: 	LicznAdrKan     = 0x02 ;
							LicznTransmisji = 0x03 ;
							RejStrony	  = 0x83 ;
							outportb(RejMaskiKan,0x05) ;
							value = value | maska[0];
							break;
		case  2		: 	LicznAdrKan     = 0x04 ;
							LicznTransmisji = 0x05 ;
							RejStrony	  = 0x81 ;
							outportb(RejMaskiKan,0x06) ;
							value = value | maska[1];
							break;
		case  3		: 	LicznAdrKan     = 0x06 ;
							LicznTransmisji = 0x07 ;
							RejStrony	  = 0x82 ;
							outportb(RejMaskiKan,0x07) ;
							value = value | maska[0];
							value = value | maska[1];
							break;
	 };
	for(i =0 ; i<100 ;i++)
	  j++;
	outportb(RejTrybu,value) ;

 adres=(unsigned int)(real_adr & 0x00ffff);
  strona=(unsigned char)((real_adr & 0xff0000) >> 16) ;
  real_adr = ((unsigned long)adres ) | ((unsigned long)strona << 16);

  xxx[0] = (unsigned char)(adres & 0x00ff);
  xxx[1] = (unsigned char)((adres >> 8) & 0x00ff);
  xxx[2] = (unsigned char)(il_b & 0x00ff);
  xxx[3] = (unsigned char)((il_b >> 8) & 0xff);


  outportb(MasterFlipFlop,0xff);
  outportb(LicznTransmisji,xxx[2]) ;
  outportb(LicznTransmisji,xxx[3]);


  outportb(RejStrony,strona) ;
  outportb(MasterFlipFlop,0xff);
  outportb(LicznAdrKan,xxx[0]);
  outportb(LicznAdrKan,xxx[1]);

  c=(unsigned char)kanal ;
  outportb(RejMaskiKan,c);
  return(strona);
}

//////////////////////////////////////////////////////////////////////////////
// Funkcja disableDMA8
// Zablokowanie wybranego kanau DMA na czas programowania
//////////////////////////////////////////////////////////////////////////////
void disableDMA8(int kanal)
 {
	unsigned RejMaskiKan = 0x0a ;

	 switch(kanal)
	  {
		 case 0	 :outportb(RejMaskiKan,0x04) ;
					  break;
		 case 1   :outportb(RejMaskiKan,0x05) ;
					  break;
		 case 2	 :outportb(RejMaskiKan,0x06) ;
					  break ;
		 case 3	 :outportb(RejMaskiKan,0x07) ;
					  break ;
	  };
 }

////////////////////////////////////////////////////////////////////////////
// Funkcja WaitForEndAC :
// oczekiwanie na koniec transmisji DMA
// zwraca odpowiedni kod bdu : LC0_OVERRUN , LC0_BROKEN (=> RUN) lub LC0_OK
// Parametry :
// WEP.strona : nr strony DMA przy pierwszym zaprogramowaniu
// WEP.nst	 : liczba segmentw danych do zgromadzenia == ilo przeprogramowa r.stron
// WEP.est	 : liczba b. ostatniej transmisji : do liczn. transmisji wpisa =-1 gdy != 0
// WEP.modnum : nr moduu
// ARMNUM : wskanik do LC0_ARMNUM
// WEP.page   : 0 - tryb bez gubienia prbek ; 1- z gubieniem
// sprawdza wcinicie CTRL-BREAK
// base : adres bazowy moduu
// kanDMA : numer kanau DMA
// v3 .. v4 - parametry pomocnicze
// shard : 1 gdy start sprztowy
// Rezultat :
//  LC0_OK lub kod bdu
////////////////////////////////////////////////////////////////////////////
char WaitForEndAC(unsigned char strona,
						unsigned int nst	  ,
						unsigned int est	  ,
						unsigned char page,
						unsigned int st,
						unsigned char kanDMA,
						unsigned char LicznTransmisji,
						unsigned char RejStrony,
						unsigned char RejMaskiKan ,
						unsigned char v3,
						unsigned char v4,
						unsigned int base,
						BOOL shard,
						unsigned long int *ARMNUM)
{

 char errcode = LC0_OK;
 unsigned int  x;
 unsigned char v1=0xff,v2=0xff,norm  ;
 MSG mes ;
 unsigned int bxx = base+STATUS_OUT ;
 norm = ModPtrAC->PSTS1 | _EN_DMA ;
 norm = norm & 0xfb;
 outportb(bxx,ModPtrAC->PSTS1);

 if(!shard)
  inportb(base+SET_EN_START);
  while(1)
	{
	 if((inportb(0x08) & maska[kanDMA]) != 0)
	  {
		if(nst==0)
		 {
		  outportb(bxx,norm);
		  ModPtrAC->PSTS1 = norm ;
		  break ;
		 }
		else
		 {
		  if(st==nst)
			{
			 outportb(bxx,norm);
			 ModPtrAC->PSTS1 = norm ;
			 break ;
			}
		  outportb(0x0a,4+kanDMA) ;
		  strona++;
		  st++;
		  outportb(RejStrony,strona);
		  if(st==nst)
			{
			 v1=v3;
			 v2=v4;
			}
		  outportb(0x0c,0xff);
		  outportb(LicznTransmisji,v1) ;
		  outportb(LicznTransmisji,v2);
		  outportb(0x0a,kanDMA);
		  continue ;
		 }
	  }

	 if(ModPtrAC->SynEnable) //moliwe przerwanie
	  {
		if(ModPtrAC->AsyncEnable==0)
		 {
		  outportb(bxx,norm);
		  ModPtrAC->PSTS1 = norm ;
		  ModPtrAC->AsyncEnable=1;
		  errcode = LC0_BROKEN ;
		  break ;
		  }
		if(IntBreak(&mes)==FALSE)
		 {
		  outportb(bxx,norm);
		  ModPtrAC->PSTS1 = norm ;
		  errcode = LC0_BROKEN ;
		  break ;
		 }
	  }
	}

 ModPtrAC->Reset();
 v1=v2=0;
 outportb(0x0c,0xff);
 v1=inportb(LicznTransmisji);
 v2=inportb(LicznTransmisji);

 x=(v2<<8) + v1 ;
 if((nst==0) || (st==nst))
  x = est -x ;
 else
  if(st<nst)
	x = (unsigned int)65535 - x ;
 *ARMNUM = st*32768 + x/2 ;
 return(errcode);
}

/*
  Przeprogramowanie DMA trwa
  70 us  - 486DX2/80 Enh
  330 us - 486DX2/10 Enh
*/




