
#include <windows.h>
#include <toolhelp.h>
#include <stdio.h>

/* adresy bazowe moduw */
#define	BASEA		0x1E20
#define	BASEB		0x1A20
#define  BASEC		0x1620

#define  KEYBREAK1 VK_CANCEL

/* liczby poszczeglnych zasobw staych kart LC-011-0812 */
#define	AC_NUM  			1    /* ilo przetwornikw A/C */
#define  CTC_NUM			2	  /* ilo przetwornikw C/A */
#define	DIN_NUM			1    /* ilo portw DigIn */
#define	DOUT_NUM			1    /* ilo portw DigOut */
#define	DBITS				8    /* ilo bitw portw cyfrowych  */
#define	AC_CHANNELS		8    /* ilo kanaw A/C */
#define	AC_BITS			12   /* 12 bitw A/C */
#define	CA_BITS			12   /* 12 bitw C/A */
#define	CA_CONV			1000 /* czas konwersji C/A */

/////////////////////////////////////////////////////////////////////////////
// definicje zwizane ze sprztem karty
/////////////////////////////////////////////////////////////////////////////
/* adresy offset poszczeglnych portw karty LC-011-0812 - patrz instrukcja
	obsugi */
#define DIG_OUT		0
#define DIG_IN			0
#define STATUS_OUT	4
#define CTC				8
#define MUX_W			12
#define ADC_W			16
#define ADC_R			16
#define DAC1_L			20
#define DAC1_H			21
#define DAC2_L			24
#define DAC2_H			25
#define SET_EN_START 28

/* maski bitw rejestru STATUS_OUT */
#define _SINGLE   	 1
#define _EN_DMA	    2
#define _DIS_CTC_0	 4
#define RESET			 8
#define _EN_1_CHN		 16
#define _EN_2_CHN		 32
#define _EN_3_CHN		 64
#define _EN_4_CHN		 128

#define LC0_FROM_DMA		0
#define LC0_TO_DMA		1

#define LC0_EXTMEM		0
#define LC0_PROG			1

/* nie wykorzystne */
struct DMA_transmit
{
  unsigned char Client		;
  unsigned char direction	;
  unsigned char module		;
  int huge *ProgBuf			;
  unsigned long DMAOffset	;
  unsigned long ClientOffset;
  unsigned long samples		 ;
};
char DMAToClientTransfer(DMA_transmit *param);

/* struktura z informacjami globalnymi o konfiguracji*/
struct global
 {
	unsigned char modules ;  /* ilo moduw z pliku INI*/
	char path[100]		 	 ;  /* - */
	unsigned int inttime	 ;  /* - */
	BOOL globalinit		 ;  /* czy inicjacja globalna DLL OK*/
	char Error				 ;  /* blad inicjacji globalnej */
	char DMAError			 ;  /* blad inicjacji DMA */
	HGLOBAL	hglb			 ;  /* - */
	void FAR *ptrbuf		 ;  /* - */
	DWORD SegBase			 ;  /* - */
	DWORD DMAAdress		 ;  /* - */
	DWORD WinFlags			 ;  /* flagi uruchomienia Windows */
 };

/* struktury z parametrami przetwarzania funkcji A/C i
	C/A */
struct ParAC
{
 BOOL single		 ;  /* czy praca 1-o kanalowa */
 BOOL block			 ;  /* czy praca blokowa */
 BOOL syn			 ;  /* czy praca synchroniczna*/
 BOOL longbuf	  	 ;  /* czy ilo prbek > 32768 */
 BOOL shard        ;  /* czy sprztowy start bloku pomiarw */
 unsigned char chan ;  /* numer kanau / liczba kanaw */
 unsigned int CTCWord1 ; /* podzielnik CTC f prbkowania */
 lc0_start PStart	;    /* parametry startu */
 lc0_stop  PStop	;    /* parametry stopu */
 unsigned char PStSt ; /* typ warunku startu */
 unsigned int  Mode	; /* tryb pracy */
 BOOL DevBusy			; /* flaga zajtoci moduu */

};

/* parametry pomiarowe funkcji C/A : analogia do A/C*/
struct ParCA
{
 BOOL single		 ;
 BOOL block			 ;
 BOOL syn			 ;
 BOOL longbuf		 ;
 unsigned long ll  ; /* ilo prbek do zmierzenia */
 lc0_start PStart	;
 lc0_stop  PStop	;
 unsigned char PStSt ;
 unsigned int  Mode	;
 BOOL DevBusy			;
};

/* klasa implementacji funkcji driver'a */
class  CModuleData
{
 public :
  CModuleData(unsigned int BaseAdress);//konstruktor
  ~CModuleData()							  ;//destruktor
  void Exit()								  ;//czyszczenie zmiennych
  int CheckApp()							  ;//sprawdzanie stanu modulu
  char CheckModule()						  ;//test obecnoci moduu
  void MessageBreak()					  ;//CTRL-BREAK funkcja
  void Reset()								  ;//reset moduu
  void ClearCard()                    ;//zerowanie sprztu karty
  void ClearDACs()						  ;// zerowanie DAC-ow
  void CTCInitWrite();                 //zapis wartosci poczatkowych do CTC
  void TimeMeasure();                  //pomiar szybkosci komputera
  void NormAC();                       //clean-up funkcji LC0_AnalogIn
  void NormCA();                       //clean-up funkcji LC0_AnalogOut
  BOOL IsInit								  ;//czy modu zainicjowany
  BOOL IsLoaded							  ;//czy modu zaadowany
  char InitError							  ;//kod bdu przy ladowaniu moduu
  BOOL IsIRQProc							  ;//czy jest procedura obs IRQ
  int IsAsyncOpAC,IsAsyncOpCA			  ;//czy jest operacja asynchronicza
													// A/C lub C/A
  int AsyncEnable							  ;//zezwolenie na CTRL-BREAK asynchroniczny
  int SynEnable							  ;//zezw. na CTRL-BREAK synchroniczne
  void FAR (*BreakProc)(void)			  ;//procedura CTRL-BREAK user'a
  HTASK AppTask    		              ;//deskryptor programu
  TASKENTRY AppInfo						  ;//info o aplikacji AppTask
  HGLOBAL	hexmem						  ;// -
  int huge *ptrex							  ;// - parametry bufora pamieci ExtMem
  unsigned long ExSize					  ;// -
  char AllocExtMem()				  ;      // alokacja ExtMem - pami rozszerzona
  void FreeExMem()				  ;      // zwolnienie ExtMem
  lc0_analog_in  ACParam				 ; // parametry przetwarzania A/C
  lc0_analog_out CAParam				 ; // parametry przetwarzania C/A
  BOOL ACValid , CAValid				 ; // flagi waznoci parametrw
  ParAC PAC									 ; // przetworzone parametry A/C
  //uywane gdy LC0_NEW_PARAM = 0
  ParCA PCA									 ; // przetworzone parametry C/A
  //uywane gdy LC0_NEW_PARAM = 0
  // dane wewntrzne i konfiguracja moduu
  unsigned int	BaseAdr					 ; // adres bazowy
  unsigned char ExMem					 ; // czy pamiec rozszerzona
  unsigned long int InExSize 			 ; //
  //////////////////////////////////////////////////////////////////////
  unsigned char mode						 ; // tryb pracy A/C
  unsigned char CLK						 ; // ~ parametr z konfiguracji
  unsigned char CA_channels			 ; // ~ parametr z konfiguracji
  char AC_V1							 	 ; // ~ parametr z konfiguracji
  char AC_V2							 	 ; // ~ parametr z konfiguracji
  unsigned char AC_DMA					 ; // ~ parametr z konfiguracji : numer kan DMA
  unsigned int Tconv						 ; // ~ parametr z konfiguracji
  unsigned int STable[32]				 ; // tablica min. czasw konwersji A/C
  char CA1_V1							 	 ; // ~ parametr z konfiguracji
  char CA1_V2							 	 ; // ~ parametr z konfiguracji
  char CA2_V1	,CA2_V2				 	 ; // ~ parametr z konfiguracji
  unsigned int  CA_Table[2]			 ; // ~ parametr z konfiguracji
  unsigned int  IRQ						 ; // nr linii IRQ lub 0xff gdy brak
  unsigned char PSTS1					 ; // rejestr statusu karty STATUS_OUT
  unsigned char IsConvtable			 ; // czy podano tablice min. czasow konw. A/C
  int  IsCTCProg[2]						 ; //czy liczniki 0 i 1 CTC user-a sa zaprogr.
  unsigned char RWCTCMode[2]			 ; //tryby pracy 0 i 1 kanalow CTC user-a
  unsigned char RBCTCMode[2]			 ; //tryby pracy 0 i 1 kanalow CTC Read Back Mode
  unsigned long  TSamp					 ; //wspolczynnik szybkosci komputera
} ;

/* struktura do monitorowania stanu DMA A/C*/
struct WaitForEndParam
{
 unsigned char strona ;  // rejestr strony
 unsigned int nst		 ;  // ilosc stron
 unsigned int est		 ;  // ostatnia strona
 unsigned char modnum ;  // numer modulu
 unsigned char page ;    // numer strony transmisji
 unsigned int st		;   //
 unsigned char kanDMA;   // numer kanalu DMA
 unsigned char LicznTransmisji ; //rejestr licznika transmisji DMA
 unsigned char RejStrony;        // rejestr strony       DMA
 unsigned char RejMaskiKan	;     // rejestr maski kanalu DMA
 unsigned char v3;				   // parametry pomocnicze
 unsigned char v4;					// ~ ~
 unsigned int base ;             // adres bazowy
 int cykl;                       // 1: tryb pracy cykliczny
} ;

/* prototypy funkcji globalnych */
void ACMeasure(unsigned char mod);
FILE* SearchFile(char *) ;
char* FindLine(int,FILE * , char * , char *,int ) ;
char * FindParam(char * , char *) ;
int ReadIniFile(char *,unsigned long * ) ;
int ParamToInt(FILE * , int  ,int *);
int ParamToTab(FILE * , int ,int ,unsigned int *,int)  ;
int ReadIniModule(char *  , unsigned char );
int ReadIniModuleAll(char *,unsigned long);
void LoadParameters(void);
char FAR PASCAL WaitForStart(unsigned char , unsigned char [],
						unsigned long  , char *,unsigned char,int) ;
char WaitForALevel( unsigned char [],char *,int);
BOOL IntBreak(MSG *);
char CheckModule(unsigned int);
unsigned char ProgDMA8(int kanal , int tryb , int cykl , int zapis , unsigned int il_b ,
 unsigned long int fadres);
void disableDMA8(int kanal);
char WaitForEndAC(unsigned char strona,
						unsigned int nst	  ,
						unsigned int est	  ,
						unsigned char page,
						unsigned int st,
						unsigned char kanDMA,
						unsigned char LicznTransmisji,
						unsigned char RejStrony,
						unsigned char RejMaskiKan ,
						unsigned char v3,
						unsigned char v4,
						unsigned int base,
						BOOL shard,
						unsigned long int *ARMNUM);

