/***************************************************************************/
/* "ambex-lc.h"                                                             */
/* Definicje struktur danych , funkcji i staych biblioteki "lc1116a.dll"  */
/* Karta AMBEX LC011-1612 . 							                            */
/* Przeznaczenie : jezyk C 						   */
/*                                                                         */
/* ************************************************************************/

/**************** REKORDY OPISOW ZLECEN FUNKCJI DRIVER'A *******************/

/************** struktury opisujace warunki startu i stopu *****************/
struct lc0_cond_level			/* warunek "poziom sygnalu cyfrowego"      */
	{
	unsigned char	mod_nr;		/* numer modulu                    */
	unsigned char	port_nr;		/* numer portu                     */
	unsigned char	inp_nr;		/* numer wejscia                   */
	unsigned char	value;		/* oczekiwana wartosc              */
	};

/*-------------------------------------------------------------------------*/
				/* warunek "zbocze sygnalu cyfrowego"      */
struct lc0_cond_slope
	{
	unsigned char	mod_nr;		/* numer modulu                    */
	unsigned char	port_nr;		/* numer portu                     */
	unsigned char	inp_nr;		/* numer wejscia                   */
	unsigned char	slope;		/* rodzaj zbocza                   */
	};
				/* kody rodzajow zbocza:                   				*/
#define	LC0_SLOPE_COND_UP	1		/* narastajace                   */
#define	LC0_SLOPE_COND_DOWN	0	/* opadajace                     */

/*-------------------------------------------------------------------------*/
struct lc0_cond_dig				/* warunek "kombinacja sygnalow cyfrowych"  */
	{
	unsigned char	mod_nr;		/* numer modulu                    */
	unsigned char	port_nr;		/* numer portu                     */
	unsigned char	mask;			/* maska aktywnych wejsc           */
	unsigned char	pattern;		/* testowany wzorzec               */
	};


/*-------------------------------------------------------------------------*/
struct	lc0_cond_date			/* warunek "data"                          */
	{
	unsigned char	second;		/* sekunda                         */
	unsigned char	minute;		/* minuta                          */
	unsigned char	hour;			/* godzina                         */
	unsigned char	day;			/* dzien miesiaca                  */
	};

/*-------------------------------------------------------------------------*/
				/* warunek "sygnal analogowy"             		 */
struct	lc0_cond_analog
	{
	unsigned char	mod_nr;		/* numer modulu                    */
	unsigned char	converter;	/* nr przetwornika                 */
	unsigned char	channel;		/* numer kanalu (b1..b7), kierunek */
										/*   przekroczenia (b8)            */
	int		level;				/* prog wyzwalania               	  */
	};
				/* kody kierunku przekroczenia progu:      			*/
#define	LC0_ANALOG_COND_UP	0x80	/* w kierunku wiekszych wartosci   */
#define	LC0_ANALOG_COND_DOWN	0		/* w kierunku mniejszych wartosci  */
#define	LC0_ANALOG_COND_MASK	0x80	/* maska kodu kierunku             */

/*-------------------------------------------------------------------------*/
union lc0_start			/* =========== warunki startu =============*/
	{
	struct	lc0_cond_level	level;		/* LC0_SLEVEL  */
	struct	lc0_cond_slope	slope;		/* LC0_SSLOPE  */
	struct	lc0_cond_dig	dig_eq;		/* LC0_SDIG_EQ */
	struct	lc0_cond_dig	dig_ne;		/* LC0_SDIG_NE */
	unsigned long		time;					/* LC0_STIME   */
	struct	lc0_cond_date	date;			/* LC0_SDATE   */
	struct	lc0_cond_analog	analog;	/* LC0_SANALOG */
	};

union lc0_stop			/* =========== warunki stopu ==============*/
	{
	unsigned long		samples;				/* LC0_ZSAMPLES */
	struct	lc0_cond_level	level;		/* LC0_ZLEVEL   */
	struct	lc0_cond_slope	slope;		/* LC0_ZSLOPE   */
	struct	lc0_cond_dig	dig_eq;		/* LC0_ZDIG_EQ  */
	struct	lc0_cond_dig	dig_ne;		/* LC0_ZDIG_NE  */
	unsigned long		time;					/* LC0_ZTIME    */
	struct	lc0_cond_date	date;			/* LC0_ZDATE    */
	struct	lc0_cond_analog	analog;	/* LC0_ZANALOG  */
	};

/*=========================================================================*/

/* Rekord opisu zlecenia funkcji  MODULE_INIT =============================*/
struct lc0_init
	{
	unsigned char	LC0_CODE;		/* kod funkcji (0)                 */
	char		LC0_STATUS;				/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;			/* dodatkowe informacje o bledach  */
	unsigned char	LC0_IMODULE;	/* mapa modulow                    */
	};

/* Rekord opisu zlecenia funkcji  GET_TOTAL_CONFIGURATION =================*/
struct lc0_total
	{
	unsigned char	LC0_CODE;		/* kod funkcji (1)                 */
	char		LC0_STATUS;				/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;			/* dodatkowe informacje o bledach  */
	unsigned char	LC0_TONF;		/* konfiguracja modulow            */
	unsigned char	LC0_TIAD;		/* przetworniki a/c                */
	unsigned char	LC0_TIDA;		/* przetworniki c/a                */
	unsigned char	LC0_TCTC;		/* kanaly CTC                      */
	unsigned char	LC0_TIDI;		/* porty wejsc cyfrowych           */
	unsigned char	LC0_TIDO;		/* porty wyjsc cyfrowych           */
	/*unsigned long	LC0_TMEMA; */		/* adres bufora w pamieci          */
											/*   rozszerzonej - absolutny      */
	/*unsigned long	LC0_TMEML;*/		/* dlugosc bufora w pamieci        */
											/*   rozszerzonej (w probkach;     */
											/*   0 - brak pamieci rozszerzonej)*/
	};

/* Rekord opisu zlecenia funkcji   GET_MODULE_CONFIGURATION ===============*/
struct lc0_module
	{
	unsigned char	LC0_CODE;			/* kod funkcji (2)                 */
	char		LC0_STATUS;					/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;				/* dodatkowe informacje o bledach  */
	unsigned char	LC0_MMODULE;		/* numer modulu                    */
	unsigned int	LC0_MBASE1;			/* adres bazowy pakietu 1          */
	unsigned int	LC0_MBASE2;			/* adres bazowy pakietu 2          */
	unsigned char	LC0_MIAD;			/* przetworniki a/c                */
	unsigned char	LC0_MIDA;			/* przetworniki c/a                */
	unsigned char	LC0_MCTC;			/* kanaly CTC                      */
	unsigned char	LC0_MIDI;			/* porty wejsc cyfrowych           */
	unsigned char	LC0_MIDO;			/* porty wyjsc cyfrowych           */
	unsigned int	LC0_MCLOCK;			/* czestotliwosc zegara w kHz      */
	unsigned char	LC0_MINT;			/* numer przerwania (programowy)   */
	int far 			*LC0_MMEMA ;		/* bufor w pamici rozszerzonej	  */
	unsigned long	LC0_MMEML	;     /* dugo bufora w pamici rozszewrzonej */
	};

/* Rekord opisu zlecenia funkcji  GET_INFO ================================*/
struct lc0_info
	{
	unsigned char	LC0_CODE;			/* kod funkcji (3)                 */
	char		LC0_STATUS;					/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;				/* dodatkowe informacje o bledach  */
	unsigned char	LC0_GTYPE;			/* rodzaj urzadzenia               */
	unsigned char	LC0_GMODULE;		/* numer modulu                    */
	unsigned char	LC0_GNUM;			/* numer przetwornika/portu/       */
												/*                      ukladu CTC */
	unsigned char	LC0_GCHAN;			/* liczba kanalow                  */
	unsigned char	LC0_GRES;			/* liczba bitow przetwornika       */
	unsigned int	LC0_GTIME;			/* czas konwersji przetwornika w ns*/
	char		LC0_GMINV;					/* dolna granica zakresu napiec w  */
												/*   dziesiatych czesciach volta   */
	char		LC0_GMAXV;					/* gorna granica zakresu napiec w  */
												/*   dziesiatych czesciach volta   */
	unsigned char	LC0_GDMA;			/* numer kanalu DMA                */
	unsigned int	LC0_GMINP[32];		/* minimalne okresy probkowania    */
	};

/* Rekord opisu zlecenia funkcji  SET_CLOCK ===============================*/
struct lc0_clock
	{
	unsigned char	LC0_CODE;			/* kod funkcji (4)                 */
	char		LC0_STATUS;					/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;				/* dodatkowe informacje o bledach  */
	unsigned int	LC0_LCLOCK;			/* czestotliowsc zegara w kHz      */
	};

/* Rekord opisu zlecenia funkcji  SET_VOLTAGE_RANGE =======================*/
struct lc0_volt
	{
	unsigned char	LC0_CODE;			/* kod funkcji (5)                 */
	char		LC0_STATUS;					/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;				/* dodatkowe informacje o bledach  */
	unsigned char	LC0_VTYPE;			/* rodzaj urzadzenia               */
	unsigned char	LC0_VMODULE;		/* numer modulu                    */
	unsigned char	LC0_VNUM;			/* numer przetwornika              */
	char		LC0_VMINV;					/* dolna granica zakresu napiec w  */
												/*   dziesiatych czesciach volta   */
	char		LC0_VMAXV;					/* gorna granica zakresu napiec w  */
												/*   dziesiatych czesciach volta   */
	char		LC0_VAMPL;		/* kod wzmacniacza instrumentalnego */
	};

/* Rekord opisu zlecenia funkcji  SET_TIME ================================*/
struct lc0_time
	{
	unsigned char	LC0_CODE;			/* kod funkcji (6)                 */
	char		LC0_STATUS;					/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;				/* dodatkowe informacje o bledach  */
	unsigned int	LC0_ETIME;			/* maksymalny czas obslugi         */
												/*   przerwania, ktore moze pojawic*/
												/*   sie w trakcie wykonywania     */
												/*   dlugiego pomiaru podawany w   */
												/*   mikrosekundach                */
	};

/* Rekord opisu zlecenia funkcji  WAIT_FOR_END ============================*/
struct lc0_wait
	{
	unsigned char	LC0_CODE;			/* kod funkcji (7)                 */
	char		LC0_STATUS;					/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;				/* dodatkowe informacje o bledach  */
	unsigned char	LC0_WTYPE;			/* rodzaj urzadzenia               */
	unsigned char	LC0_WMODULE;		/* numer modulu                    */
	unsigned char	LC0_WNUM;			/* numer przetwornika              */
	unsigned char	LC0_WMODE;			/* tryb pracy                      */
	unsigned long	LC0_WRMNUM;			/* rzeczywista liczba probek       */
	unsigned int	LC0_WREMAR;			/* rzeczywista dlugosc marginesu   */
												/* koncowego                       */
	};
		/* tryby pracy funkcji                     */
#define	LC0_W_WAIT	0				/* oczekiwanie                             */
#define	LC0_W_TEST	1				/* test konca                              */
#define	LC0_W_FINISHED	2			/* powiadomienie o koncu                   */

/* Rekord opisu zlecenia funkcji  BREAK ===================================*/
struct lc0_break
	{
	unsigned char	LC0_CODE;			/* kod funkcji (8)                 */
	char		LC0_STATUS;					/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;				/* dodatkowe informacje o bledach  */
	unsigned char	LC0_BMODE;			/* tryb pracy                      */
	void 		(FAR *LC0_BPROC)(void);	/* adres procedury obslugi */
												/*   przerwania 0x1B       */
	};
												/* bity trybu pracy funkcji              */
#define	LC0_BREAK_EXEC		0 /* przerwanie                            */
#define	LC0_BREAK_INST		1 /* instalacja Ctrl_Break...              */
#define	LC0_BREAK_PREV		4 /* ...z wywolaniem poprzedniej obslugi   */
#define	LC0_BREAK_UNINST	2 /* wyinstalowanie wszystkiego            */

/* Rekord opisu zlecenia funkcji  DIGITAL_INPUT ===========================*/
struct lc0_digital_in
	{
	unsigned char	LC0_CODE;		/* kod funkcji (9)                 */
	char		LC0_STATUS;				/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;			/* dodatkowe informacje o bledach  */
	unsigned char	LC0_DMODULE;	/* numer modulu                    */
	unsigned char	LC0_DNUM;		/* numer portu                     */
	unsigned char	LC0_DSTST;		/* typ warunku startu              */
	unsigned char	LC0_DVAL;		/* odczytana wartosc               */
	union lc0_start	LC0_DSTART;	/* parametry warunku startu        */
	};

/* Rekord opisu zlecenia funkcji  DIGITAL_OUTPUT ==========================*/
struct lc0_digital_out
	{
	unsigned char	LC0_CODE;		/* kod funkcji (10)                */
	char		LC0_STATUS;				/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;			/* dodatkowe informacje o bledach  */
	unsigned char	LC0_OMODULE;	/* numer modulu                    */
	unsigned char	LC0_ONUM;		/* numer portu                     */
	unsigned char	LC0_OSTST;		/* typ warunku startu              */
	unsigned char	LC0_OVAL;		/* wartosc do wyslania             */
	union lc0_start	LC0_OSTART;	/* parametry warunku startu        */
	};

/* Rekord opisu zlecenia funkcji  CTC_WRITE ===============================*/
struct lc0_ctc_write
	{
	unsigned char	LC0_CODE;		/* kod funkcji (11)                */
	char		LC0_STATUS;				/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;			/* dodatkowe informacje o bledach  */
	unsigned char	LC0_CMODULE;	/* numer modulu                    */
	unsigned char	LC0_CMODE;		/* tryb pracy funkcji              */
	unsigned char	LC0_CFUN;		/* tryb pracy kanalu               */
	unsigned int	LC0_CVAL;		/* nowa wartosc licznika           */
	};
				/* tryby pracy funkcji                     */
#define	LC0_SET_CTC_MODE	1			/* zaprogramuj tryb pracy kanalu   */
#define	LC0_SET_COUNTER_VALUE	2	/* zaladuj nowa wartosc licznika   */
#define LC0_CTC_ENABLE		4			/* zezwolenie CTC		   */
/* Rekord opisu zlecenia funkcji  CTC_READ ================================*/
struct lc0_ctc_read
	{
	unsigned char	LC0_CODE;			/* kod funkcji (12)                */
	char		LC0_STATUS;					/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;				/* dodatkowe informacje o bledach  */
	unsigned char	LC0_UMODULE;		/* numer modulu                    */
	unsigned char	LC0_UNUM;			/* numer kanalu                    */
	unsigned int	LC0_UVAL;			/* odczytana wartosc licznika      */
	};

/* Rekord opisu zlecenia funkcji  DATA_TRANSMIT ===========================*/
struct lc0_transmit
	{
	unsigned char	LC0_CODE;			/* kod funkcji (13)                */
	char		LC0_STATUS;					/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;				/* dodatkowe informacje o bledach  */
	unsigned char LC0_RMODULE ;		/* numer moduu */
	unsigned char	LC0_RMODE;			/* tryb przesylania                */
	int far		*LC0_RADDR;				/* adres bufora DMA - pomiarowego  */
	unsigned long	LC0_RLEN;	/* dlugosc bufora w DMA - pomiarowego    */
	unsigned long	LC0_RMEAS;	/* numer pierwszej probki          */
	unsigned long	LC0_RNUM;	/* liczba probek do przeslania     */
	int far			*LC0_RMEMA;	/* adres bufora w pamieci          */
										/*   aplikacji ( @@@ )wskanik     */
	unsigned long	LC0_RRNUM;	/* rzeczywista liczba probek       */

	};
				/* tryby pracy funkcji                     */
#define	LC0_TO_EXT_DIR		1	/* do pamieci aplikacji	 - programowy*/
#define	LC0_FROM_EXT_DIR	0	/* z pamieci modulu / aplikacji */

/* Rekord opisu zlecenia funkcji ANALOG_INPUT =============================*/
struct lc0_analog_in
	{
	unsigned char	LC0_CODE;		/* kod funkcji (14)                */
	char		LC0_STATUS;				/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;			/* dodatkowe informacje o bledach  */
	unsigned char	LC0_AMODULE;	/* numer modulu                    */
	unsigned char	LC0_ANUM;		/* numer przetwornika              */
	unsigned int	LC0_AMODE;		/* tryb pracy funkcji              */
	unsigned char	LC0_ASTST;		/* typy warunkow startu i stopu    */
	unsigned long	LC0_APER;		/* okres probkowania               */
	unsigned int	LC0_APER2;		/* krotnosc okresu probkowania     */
	unsigned char	LC0_ACHAN;		/* liczba kanalow podstawowych     */
											/*   (b8 okresla czy praca         */
											/*   wielokanalowa (0) czy         */
											/*   jednokanalowa (1))            */
	unsigned char	LC0_ACHAN2;		/* liczba kanalow dodatkowych      */
	int far		*LC0_AADDR;			/* adres buforaw pam. podstawowej  */
											/* ????  - praca programowa*/
	unsigned long	LC0_ALEN;		/* dlugosc bufora                  */
	int far		*LC0_AMEMA;			/* adres bufora w pam. rozszerzonej*/
											/*   (wskanik)                   */
	unsigned int	LC0_ABMAR;		/* dlugosc marginesu poczatkowego  */
	unsigned int	LC0_AEMAR;		/* dlugosc marginesu koncowego     */
	unsigned int	LC0_AHAND;		/* numer handler'a zbioru          */
	union lc0_start	LC0_ASTART;	/* parametry warunku startu        */
	union lc0_stop	LC0_ASTOP;		/* parametry warunku stopu         */
	unsigned int	LC0_ARDIV1;		/* pierwszy podzielnik zegara      */
	unsigned int	LC0_ARDIV2;		/* drugi podzielnik zegara         */
	unsigned long	LC0_ARMNUM;		/* rzeczywista liczba probek       */
	unsigned int	LC0_ARBMAR;		/* rzeczywista dlugosc marg. pocz. */
	unsigned int	LC0_AREMAR;		/* rzeczywista dlugosc marg. konc. */
	unsigned long	LC0_ARLEN;		/* rzeczywista liczba przepisanych */
											/*   probek                        */
	unsigned int	LC0_ARBUF;		/* dla pracy z buforem cyklicznym: */
											/*   numer probki okreslajacej     */
											/*   poczatek bufora po zakonczeniu*/
											/*   pomiaru                       */
	};

/* Rekord opisu zlecenia funkcji  ANALOG_OUTPUT ===========================*/
struct lc0_analog_out
	{
	unsigned char	LC0_CODE;		/* kod funkcji (15)                */
	char		LC0_STATUS;				/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;			/* dodatkowe informacje o bledach  */
	unsigned char	LC0_NMODULE;	/* numer modulu                    */
	unsigned char	LC0_NNUM;		/* numer przetwornika              */
	unsigned int	LC0_NMODE;		/* tryb pracy funkcji              */
	unsigned char	LC0_NSTST;		/* typy warunkow startu i stopu    */
	unsigned char	LC0_NCHAN;		/* liczba kanalow (b8 okresla      */
											/*   czy praca wielokanalowa (0)   */
											/*   czy jednokanalowa (1))        */
	unsigned long	LC0_NPER;		/* okres probkowania */
	union	{
		int  far	*base_memory;
		int  far	*extended_memory;
		}LC0_NADDR;						/* adres bufora (segment:offset dla*/
											/*   pamieci podstawowej, absolutny*/
											/*   dla pamieci rozszerzonej)     */
	unsigned long	LC0_NLEN;		/* dlugosc bufora w pam. podst.    */
	unsigned int	LC0_NHAND;		/* numer handler'a zbioru          */
	union lc0_start	LC0_NSTART;	/* parametry warunku startu        */
	union lc0_stop	LC0_NSTOP;		/* parametry warunku stopu         */
	unsigned long	LC0_NRMNUM;		/* rzeczywista liczba wyslanych    */
											/*   probek                        */
	};

/* Rekord opisu zlecenia funkcji  LEAVE_DRIVER ============================*/
struct lc0_leave
	{
	unsigned char	LC0_CODE;		/* kod funkcji (16)                */
	char		LC0_STATUS;				/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;			/* dodatkowe informacje o bledach  */
	};

/* Rekord opisu zlecenia funkcji  INTERRUPT_SERVICE */
struct lc0_interrupt
	{
	unsigned char	LC0_CODE;		/* kod funkcji (17)                */
	char		LC0_STATUS;				/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;			/* dodatkowe informacje o bledach  */
	unsigned char	LC0_SMODULE;	/* numer modulu                    */
	/*void far (*LC0_SPROC)(void);*/	/* adres procedury obslugi         */
	int far		*LC0_SSTAT;			/* adres slowa komunikacyjnego     */
	};
/* Rekord opisu zlecenia funkcji MEMORY_USE*/
struct lc0_memory
	{
	unsigned char	LC0_CODE;		/* kod funkcji (18)                */
	char		LC0_STATUS;				/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT;			/* dodatkowe informacje o bledach  */
	unsigned char LC0_MMODULE;		/* nr moduu do ktrego odnosi si ta operacja */
	unsigned char LC0_MMODE;		/* obecnie == 1						  */
	unsigned long LC0_MNUM;			/* dana liczba prbek w nowym buforze*/

	unsigned long LC0_MRNUM;		/* rzeczywista wielko bufora w prbkach */
	int far *LC0_MRMEMA;				/* adres nowego bufora w pamici		*/
	};

/* Rekord opisu zlecenia funkcji CONFIG		*/
struct lc0_config
	{
	unsigned char	LC0_CODE; 		/* kod funkcji (19)                */
	char		LC0_STATUS;				/* kod odpowiedzi driver'a         */
	char		LC0_ERR_STAT; 			/* dodatkowe informacje o bledach  */
	char		*LC0_INI_FILE;			/* cieka do pliku 'ambex.ini' 	  */
											/* gdy NULL to standardowe pszeszukanie */
											/* lub z LoadLibrary()					*/
	};


#define	LC0_IS_START	1			/* przerwanie wystapilo z powodu           */
											/*   rozpoczecia pomiaru                   */
#define	LC0_IS_ONE	2				/* przerwanie nastapilo z powodu zmierzenia*/
											/*   kolejnej serii pomiarowej             */
#define	LC0_IS_END_ADC	4			/* przerwanie nastapilo z powodu           */
											/*   zakonczenia przetwarzania a/c         */
#define	LC0_IS_END_DAC	8			/* przerwanie nastapilo z powodu           */
											/*   zakonczenia przetwarzania c/a         */
#define	LC0_IS_BROKEN	16			/* zakonczono przetwarzanie z powodu       */
											/* wykonania funkcji BREAK                 */
#define LC0_IS_SAMPLE	32			/* przerwanie nastapilo z powodu zmierzenia*/
											/*  kolejnej probki                        */

/* ***************** kody funkcji driver'a *********************************/
#define	MODULE_INIT						16
#define	GET_TOTAL_CONFIGURATION 	17
#define	GET_MODULE_CONFIGURATION   18
#define GET_INFO							19
#define SET_CLOCK							20
#define SET_VOLTAGE_RANGE				21
#define SET_TIME							22
#define WAIT_FOR_END						23
#define BREAK								24
#define DIGITAL_INPUT					25
#define DIGITAL_OUTPUT					26
#define CTC_WRITE                   27
#define CTC_READ							28
#define DATA_TRANSMIT					29
#define ANALOG_INPUT						30
#define ANALOG_OUTPUT					31
#define LEAVE_DRIVER						32
#define	INTERRUPT_SERVICE				33
#define MEMORY_USE						34
#define CONFIG								35
/*************** numery przerwan obslugiwanych przez driver ****************/
#define	LC010_16	0x99		/* LC-010-1612                     */
#define	LC011_08	0x90		/* LC-011-0812                     */
#define	LC011_16	0x91		/* LC-011-1612                     */
#define	LC015_16	0x92		/* LC-015-1612                     */
#define	LC020_08_0	0x93	/* LC-020-0812 v.0                 */
#define	LC020_08_2	0x94	/* LC-020-0812 v.1 i v.2           */
#define	LC020_32	0x95		/* LC-020-3212                     */
#define	LC030_16	0x96		/* LC-030-1612                     */
#define	LC060_06	0x97		/* LC-060-0612                     */

/******************** kody odpowiedzi funkcji driver'a *********************/
#define	LC0_OK			0

/* ======= ostrzezenia ======== */
#define	LC0_NON_EX_MOD          1	/* nie istniejacy(e) modul(y)      */
#define	LC0_OTHER_LEN           2	/* przepisano mniejsza liczbe      */
												/*   pomiarow                      */
#define	LC0_PREMATURE_END	3			/* przedwczesne zakonczenie z      */
												/*   powodu przepelnienia bufora   */
#define	LC0_IN_PROGRESS		4		/* badana transmisja jeszcze trwa  */
#define  LC0_IS_INIT				5		/* zadano inicjacji ju zainicjowaneg */

/* ========== bledy =========== */
#define	LC0_UNKN_FUNC		-1			/* nieznany kod funkcji            */
#define	LC0_NO_MODULE		-2			/* brak modulu(ow)                 */
#define	LC0_BAD_DEV_TYP	-3			/* bledny typ urzadzenie           */
#define	LC0_NONEX_DEV		-4			/* nie istnieje urzadzenie o tym   */
					/*   numerze                       */
#define	LC0_BAD_FREQ		-5			/* zla czestotliwosc zegara        */
#define	LC0_BAD_RANGE		-6			/* zly zakres napiec               */
#define	LC0_NO_OPER			-7			/* zadna operacja nie jest         */
												/*   wykonywana                    */
#define	LC0_BAD_MARGIN		-8			/* bledna dlugosc marginesu        */
												/*   poczatkowego                  */
#define	LC0_BAD_BUF_ADR	-9			/* bledny adres bufora             */
#define	LC0_BAD_BUF_LEN	-10		/* bledna dlugosc bufora           */
#define	LC0_DEV_BUSY		-11		/* urzadzenie jest zajete          */
#define	LC0_BAD_PER			-12		/* zly okres probkowania           */
#define	LC0_BAD_CHAN_N		-13		/* zla liczba kanalow              */
#define	LC0_BAD_CHAN		-14		/* numer nie istniejacego kanalu   */
#define	LC0_BROKEN			-15		/* przerwano funkcja BREAK         */
#define	LC0_INTR_NOT_INST	-16		/* procedura obslugi przerwania nie*/
												/*   jest zainstalowana            */
#define	LC0_ILL_START_CODE	-17	/* nielegalny typ warunku startu   */
#define	LC0_ILL_STOP_CODE		-18	/* nielegalny typ warunku stopu    */
#define	LC0_BAD_PROC			-19	/* bledny adres procedury obslugi  */
												/*   przerwania lub slowa          */
												/*   komunikacyjnego               */
#define	LC0_TOO_LONG_MARG		-20	/* margines dluzszy od bufora      */
#define	LC0_ILL_START			-21	/* bledne parametry warunku startu */
#define	LC0_ILL_STOP			-22	/* bledne parametry warunku stopu  */
#define	LC0_BAD_MNUM			-23	/* bledny numer pierwszej probki   */
#define	LC0_NOT_SUPPORTED		-24	/* dla danego modulu funkcja nie   */
												/*   jest realizowana              */
#define	LC0_BAD_CTC_MODE		-25	/* bledny tryb pracy CTC           */
#define	LC0_NO_PARAMS			-26	/* nie podano parametrow           */
												/*   przetwarzania                 */
#define	LC0_OVERRUN				-27  	/* zakonczono przetwarzanie z      */
												/*   powodu bledu OVERRUN          */
#define	LC0_NO_DMA				-28 	/* z danym urzadzeniem nie jest    */
												/*   zwiazany zaden kanal DMA      */
#define	LC0_NO_IRQ				-29  	/* z danym modulem nie jest        */
												/*   zwiazane zadne przerwanie     */
#define	LC0_NOT_FULLY_SUP		-30	/* zadany tryb wykonania funkcji   */
												/*   nie jest realizowany dla      */
												/*   danego typu modulu lub funkcja*/
												/*   w opracowaniu                 */
#define	LC0_NO_EXTMEM			-31  	/* brak pamieci roszerzonej        */
#define	LC0_NO_SEC_FREQ		-32	/* modul nie moze wykonywac        */
												/*   pomiarow z podwojna           */
												/*   czestotliwoscia               */
#define	LC0_INTR_INST			-33	/* procedura obslugi przerwania    */
												/*   juz zainstalowana             */
#define	LC0_BAD_PER2			-34	/* bledna wielokrotnosc okresu     */
												/*   probkowania (0 lub 1)         */
#define	LC0_BAD_MODE			-35  	/* bledny tryb pracy               */
#define	LC0_BAD_EXTMEM			-36  	/* zly adres bufora w pamieci      */
												/*   rozszerzonej                  */
#define	LC0_CTC_NOT_PROGRAMMED 	-37	/* zapis licznika przy niezapro-   */
												/*   gramowanym trybie pracy       */
#define	LC0_REJECTED		-38		/* za wiele rownoleglych wejsc do  */
												/*   driver'a                      */
#define  LC0_BAD_CONFIG		-39		/* bd w pliku konfiguracyjnym *.ini*/
#define	LC0_NOT_INIT		-40		/* modu nie zainicjowany */
#define	LC0_NO_DMA_TRANS		-41		/* brak moliwoci przeprowadzenia */
												/* buforowanej transmisji DMA		  */
/************************** dodatkowe informacje o bledach *****************/
#define	LC0_E_OK					0	/* brak dodatkowych informacji     */
#define	LC0_E_NO_MODULE		-1	/* nie ma takiego modulu           */
#define	LC0_E_NONEX_DEV		-2	/* nie istnieje urzadzenie o tym   */
											/*   numerze                       */
#define	LC0_E_BAD_CHAN			-3	/* numer nieistniejacego kanalu    */
#define	LC0_E_BAD_TIME			-4	/* zly odcinek czasu               */
#define	LC0_E_BAD_DATE			-5	/* zla specyfikacja daty           */
#define	LC0_E_BAD_THRE			-6	/* bledny prog wyzwalania          */
											/*   analogowego                   */
#define	LC0_E_BROKEN_WAIT		-7	/* funkcja przerwana w trakcie     */
											/*   oczekiwania na spelnienie     */
											/*   warunku startu                */
#define	LC0_E_BROKEN_RUN		-8	/* funkcja przerwana w trakcie     */
											/*   przetwarzania                 */
#define	LC0_E_BAD_LEN			-9	/* zadeklarowano za duzo probek    */
#define  LC0_E_MOD_UNABLE		-10 /* modu zajty lub niezainicjowany */

/************************** kody warunkow startu ***************************/
#define	LC0_SIMMED		 0	/* natychmiastowy                          */
#define	LC0_SHARD       1	/* od sygnalu sprzetowego                  */
#define	LC0_SLEVEL      2	/* od poziomu sygnalu cyfrowego            */
#define	LC0_SSLOPE      3	/* od zbocza sygnalu cyfrowego             */
#define	LC0_SDIG_EQ     4	/* od kombinacji bitow - rowne             */
#define	LC0_SDIG_NE     5	/* od kombinacji bitow - rozne             */
#define	LC0_STIME       6	/* po uplynieciu okreslonego czasu         */
#define	LC0_SDATE       7	/* o podanym czasie                        */
#define	LC0_SANALOG     8	/* od sygnalu analogowego                  */

/************************** kody warunkow stopu ****************************/
#define	LC0_ZSAMPLES	 0x00	/* po zmierzeniu okreslonej liczby probek  */
#define	LC0_ZBREAK      0x10	/* po wykonaniu funkcji BREAK              */
#define	LC0_ZLEVEL      0x20	/* od poziomu sygnalu cyfrowego            */
#define	LC0_ZSLOPE      0x30	/* od zbocza sygnalu cyfrowego             */
#define	LC0_ZDIG_EQ     0x40	/* od kombinacji bitow - rowne             */
#define	LC0_ZDIG_NE     0x50	/* od kombinacji bitow - rozne             */
#define	LC0_ZTIME       0x60	/* po uplynieciu okreslonego czasu         */
#define	LC0_ZDATE       0x70	/* o podanym czasie                        */
#define	LC0_ZANALOG     0x80	/* od sygnalu analogowego                  */

/*************************** kody numerow modulow **************************/
#define	LC0_MODA	1	/* modul A                                 */
#define	LC0_MODB	2	/* modul B                                 */
#define	LC0_MODC	3	/* modul C                                 */
#define	LC0_MODD	4	/* modul D                                 */

/************************** maski modulow w mapie **************************/
#define LC0_MODAMAP	1	/* modul A                                 */
#define LC0_MODBMAP	2	/* modul B                                 */
#define LC0_MODCMAP	4	/* modul C                                 */
#define LC0_MODDMAP	8	/* modul D                                 */

/************************* kody typow urzadzen *****************************/
#define	LC0_DINPUT	1	/* wejsciowy port cyfrowy                  */
#define	LC0_DOUTPUT	2	/* wyjsciowy port cyfrowy                  */
#define	LC0_AINPUT	3	/* przetwornik a/c                         */
#define	LC0_AOUTPUT	4	/* przetwornik c/a                         */
#define	LC0_CTC		5	/* kanal CTC                               */

/*********** maski trybu pracy funkcji ANALOG_INPUT i ANALOG_OUTPUT ********/
#define LC0_MOD_START		1	/* start przetwarzania             */
#define LC0_MOD_NEW_PAR		2	/* nowe parametry                  */
#define LC0_MOD_SYNCHR		4	/* praca synchroniczna             */
#define	LC0_MOD_ASYNCHR	0	/* praca asynchroniczna            */
#define	LC0_MOD_INTR		8	/* praca bez przerwan              */
#define	LC0_MOD_INTR_TYPE	16	/* bit trybu przerwan              */
#define LC0_MOD_END_INTR	0	/* przerwanie po koncu             */
					/*   przetwarzania                 */
#define LC0_MOD_ONE_INTR	16	/* przerwanie po kazdej probce     */
#define LC0_MOD_BLOCK		32	/* praca blokowa                   */
#define	LC0_MOD_SINGLE		0	/* praca pojedyncza                */
#define LC0_MOD_CYCL			64	/* bufor cykliczny                 */
#define LC0_MOD_FILE_W		128	/* zapis do pliku                  */
#define LC0_MOD_FILE_R		128	/* odczyt z pliku                  */
#define LC0_MOD_MEM_W		256	/* przepisanie do pamieci          */
#define LC0_MOD_EXT_CLK		512	/* zegar zewnetrzny                */
#define	LC0_MOD_EXT_MEM	1024	/* pamiec rozszerzona              */
#define LC0_MOD_PAGE	2048	/* sposob progr. ston DMA  	*/

/************* wartosci fragmentow bajtu kontrolnego 8253/8254 *************/
#define CTC_NB		0		/* kod naturalny binarny                   */
#define CTC_BCD		1	/* kod BCD                                 */

#define CTC_MODE0	0		/* tryb 0                                  */
#define CTC_MODE1	2		/* tryb 1                                  */
#define CTC_MODE2	4		/* tryb 2                                  */
#define CTC_MODE3	6		/* tryb 3                                  */
#define CTC_MODE4	8		/* tryb 4                                  */
#define CTC_MODE5	10		/* tryb 5                                  */

#define CTC_LSB		0x10	/* tylko mlodszy bajt                      */
#define CTC_MSB		0x20	/* tylko starszy bajt                      */
#define CTC_BOTH		0x30	/* mlodszy - starszy                       */

#define	CTC_COUNT0	0x00	/* licznik 0                               */
#define	CTC_COUNT1	0x40	/* licznik 1                               */
#define	CTC_COUNT2	0x80	/* licznik 2                               */

/* */
/* prototypy funkcji API biblioteki	*/
/* */
void FAR PASCAL  _export LC0_ModuleInit(struct lc0_init FAR *param);
void FAR PASCAL  _export LC0_GetTotalConf(struct lc0_total FAR *param)	;
void FAR PASCAL  _export LC0_GetModule(struct lc0_module  FAR *param)	;
void FAR PASCAL  _export LC0_GetInfo(struct lc0_info FAR *param)		;
void FAR PASCAL  _export LC0_SetClock(struct lc0_clock FAR *param)	;
void FAR PASCAL  _export LC0_SetVoltage(struct lc0_volt FAR *param)	;
void FAR PASCAL  _export LC0_SetTime(struct lc0_time FAR *param)	;
void FAR PASCAL  _export LC0_Wait(struct lc0_wait FAR *param)	;
void FAR PASCAL  _export LC0_Interrupt(struct lc0_interrupt FAR *param)	;
void FAR PASCAL  _export LC0_DigitalIn(struct lc0_digital_in FAR *param)	;
void FAR PASCAL  _export LC0_DigitalOut(struct lc0_digital_out FAR *param)	;
void FAR PASCAL  _export LC0_CTCWrite(struct lc0_ctc_write FAR *param)	;
void FAR PASCAL  _export LC0_CTCRead(struct lc0_ctc_read FAR *param)	;
void FAR PASCAL  _export LC0_Leave(struct lc0_leave FAR *param)	;
void FAR PASCAL  _export LC0_Config(struct lc0_config FAR *param)	;
void FAR PASCAL  _export LC0_Break(struct lc0_break FAR *param);
void FAR PASCAL  _export LC0_DataTransmit(struct lc0_transmit FAR *param);
void FAR PASCAL  _export LC0_MemoryUse(struct lc0_memory FAR *param);
void FAR PASCAL  _export LC0_AnalogIn(struct lc0_analog_in FAR *param);
void FAR PASCAL  _export LC0_AnalogOut(struct lc0_analog_out FAR *param);