/************************************************************************/
/* Projekt : "lc1108a.dll" - biblioteka DLL WINDOWS dla karty LC-011-0812 */
/* Autor : Krzysztof Mroczek 	1996                                       */
/************************************************************************/
#define  STRICT
#include <windows.h>
#pragma hdrstop
#define _EXPORT _export
#include  <toolhelp.h>
#include  <dos.h>
#include  <stdlib.h>
#include  "lc1108a.h"
#include  "1108int.h"
#include  "px.h"

extern CModuleData *ModWsk[3]	;
extern Class1 *pPx ;
extern global GData				;
struct CModuleData *ModPtrAC;

/////////////////////////////////////////////////////////////////////////
// ANALOG_INPUT
//  Funkcja LC0_AnalogIn : sterowanie pomiarami a wykorzystaniem toru
//	  A/C karty . Jest zaimplementowany tryb pracy synchronicznej tzn.
//   sterowanie jest zwracane do wywoujcego programu po zakoczeniu pomiaru .
//   Po zainstalowaniu CTRL-BREAK pomiar mona przerwa w dowolnym momencie .
//   Tryby pracy :
//    - praca programowa : wyzwolenie pomiarw i odczyt wynikw programowo
//		- blokowo DMA : transmisja danych kanaem DMA : dziaa gdy Windows
//		  pracuje w trybie 'Enhanced' .
//	   - jednokoanalowo / wielokanalowo 1..n
//	   - pomiar po 1-ej prbce / caego bloku
//    - pomiar do bufora podanego przez uytkownika , bufora pamici rozszerzonej
//			DLL (ExtMem) lub z przepisaniem z pamici ExtMem do bufora urzytkownika.
//   Sprawdzanie parametrw przetwarzania odbywa si zgodnie z 'logik' i
//   definicj struktury 'lc0_analog_in'.
//   Algorytmy pomiarowe s zgodne z instukcj obsugi karty LC-011-0812 :
//	  cz dotyczca algorytmw programowania .
//  Parametry wejciowe :
//   param : daleki wskanik do struktury 'lc0_analog_in' z parametrami
//		wywoania i statusu .
/////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_AnalogIn(lc0_analog_in FAR *param)
{
 struct WaitForEndParam WEPAC;
 char errcode ;
 unsigned char mod ;
 BOOL single		 ;
 BOOL block			 ;
 BOOL syn			 ;
 BOOL longbuf	  	 ;
 BOOL shard        ;
 unsigned char chan ;
 unsigned long ll ;
 lc0_analog_in *par=NULL;
 unsigned int CTCWord1;
 unsigned char umask[] = {0xfe,0xfd,0xfb,0xf7,0xef,0xdf,0xbf,0x7f};
 register unsigned char  val;
 unsigned long loop;
 str1 pstr ;
 unsigned char err ;
 unsigned int il_b ;
 char  errex;
 unsigned char part[5] ,*ptr;
 unsigned long ptime ;
 unsigned int base,ii ;
 register unsigned int samp ;
 unsigned char val1,val2 ;
 int far  *ptrfar;
 int huge *ptrhuge ;
 MSG mes ;
 unsigned char norm ;
 unsigned long int period ;
 unsigned char step,term;
 unsigned long int J;

 param->LC0_ERR_STAT = LC0_E_OK		  ;
 param->LC0_STATUS = LC0_OK ;
 param->LC0_ARLEN = 0;
 param->LC0_ARMNUM =0;

 /* sprawdzanie statusu wywolywanego moduu */
 if((param->LC0_AMODULE >= LC0_MODA) && (param->LC0_AMODULE <= LC0_MODC))
  {
	errcode = ModWsk[(param->LC0_AMODULE) -1 ]->CheckApp();

	if(errcode != LC0_OK)
	 {
		param->LC0_STATUS = errcode ;
		return ;
	 }
  }
 else
  {
	param->LC0_STATUS = LC0_NO_MODULE ;
	return ;
  }
 mod = param->LC0_AMODULE -1 ;

 if(ModWsk[mod]->PAC.DevBusy)
  {
	param->LC0_STATUS = LC0_DEV_BUSY ;
	return ;
  }
 ModWsk[mod]->PAC.DevBusy=TRUE;

 /* analiza parametrw przetwarzania podanych przez uytkownika */
 if(((param->LC0_AMODE) & LC0_MOD_NEW_PAR)==0 ) //stare
  {
	 if(ModWsk[mod]->ACValid)  // s wane
	  {
		par = &(ModWsk[mod]->ACParam) ;
	  }
	 else
	  {
		param->LC0_STATUS = LC0_NO_PARAMS ;ModWsk[mod]->PAC.DevBusy=FALSE;
		return ;
	  }
  }
 else
  {
	par = param ;
  }

 if(((param->LC0_AMODE) & LC0_MOD_NEW_PAR)!=0)
  {

	if(par->LC0_ANUM == 0 || par->LC0_ANUM >AC_NUM )
	 {
	  param->LC0_STATUS = LC0_NONEX_DEV ;ModWsk[mod]->PAC.DevBusy=FALSE;
	  ModWsk[mod]->ACValid = FALSE ;
	  return ;
	 }

	if((par->LC0_ACHAN & 0x80)==0)
	 {
	  if((par->LC0_ACHAN < 2) || (par->LC0_ACHAN > AC_CHANNELS)||
	  (par->LC0_ACHAN==3)||(par->LC0_ACHAN==5)||(par->LC0_ACHAN==6)||
	  (par->LC0_ACHAN==7))
		{
		 param->LC0_STATUS = LC0_BAD_CHAN_N ;
		 ModWsk[mod]->NormAC();
		 return ;
		}
		single = FALSE ;
		chan = par->LC0_ACHAN ;
	  }
	else
	 {
	  val= par->LC0_ACHAN & umask[7] ;
	  if(val == 0x00 || val > AC_CHANNELS)
		{
		 param->LC0_STATUS = LC0_BAD_CHAN ;
		 ModWsk[mod]->NormAC();
		 return ;
		}

	  single = TRUE ;
	  chan = val ;
	 }

  if((par->LC0_AMODE & 0xe000)!=0)
	{
	 param->LC0_STATUS = LC0_BAD_MODE ;
	 ModWsk[mod]->NormAC();
	 return ;
	}

  if((par->LC0_AMODE & LC0_MOD_SYNCHR)  ==0 )
	syn = 0 ;
  else
	syn = 1 ;
  if((par->LC0_AMODE & LC0_MOD_BLOCK)  ==0 )
	block = 0 ;
  else
	block = 1 ;

  ll = par->LC0_ASTOP.samples ;
  if(ll>32768L)
	longbuf = TRUE ;
  else
	longbuf = FALSE ;
  ll = par->LC0_ASTOP.samples ;
  if(ll>32768L)
	longbuf = TRUE ;
  else
	longbuf = FALSE ;
  if(par->LC0_AMODE & LC0_MOD_EXT_MEM )
	{

	 if(ModWsk[mod]->ExMem ==0 || ModWsk[mod]->ExSize ==0 || ModWsk[mod]->ptrex ==NULL )
	  {
		param->LC0_STATUS = LC0_NO_EXTMEM ;
		ModWsk[mod]->NormAC();
		return ;
	  }

	 if((ModWsk[mod]->ExSize)/2 < ll)
	  {
		param->LC0_STATUS = LC0_BAD_BUF_LEN;
		ModWsk[mod]->NormAC();
		return ;
	  }

	 errcode = 0;
	 if(longbuf) //HUGE
	  {
		if(::IsBadHugeWritePtr((void huge *)(param->LC0_AMEMA),2*ll))
		 {
		 errcode = 1;
		 }
	  }
	 else
	  {
		if(::IsBadWritePtr((void far *)(param->LC0_AMEMA),2*(UINT)ll))
		 {
		  errcode = 1;
		 }
	  }
	 if(errcode !=0)
	  {
		param->LC0_STATUS = LC0_BAD_BUF_ADR;
		ModWsk[mod]->NormAC();
		return ;
	  }

	 if((par->LC0_AMODE & LC0_MOD_MEM_W) !=0)
	  {
		 if(param->LC0_ALEN == 0)
		  param->LC0_STATUS = LC0_BAD_BUF_LEN ;
		 if(param->LC0_ALEN >  32768L)
		  {
			if(::IsBadHugeWritePtr((void huge *)(param->LC0_AADDR),2*(param->LC0_ALEN)))
			 {
			  param->LC0_STATUS = LC0_BAD_BUF_ADR ;
			 }
		  }
		 else
		  {
			if(::IsBadWritePtr((void far *)(param->LC0_AADDR),2*(UINT)(param->LC0_ALEN)))
			 {
			  param->LC0_STATUS = LC0_BAD_BUF_ADR ;
			 }
		  }
		 if(param->LC0_STATUS != LC0_OK)
		  {
			ModWsk[mod]->NormAC();
			return ;
		  }

	 }
	}
  else
	{
	 if(param->LC0_ALEN == 0)
	  param->LC0_STATUS = LC0_BAD_BUF_LEN ;

	 if(param->LC0_ALEN < ll)
		param->LC0_STATUS = LC0_BAD_BUF_LEN ;

	 if(param->LC0_STATUS != LC0_OK)
	  {
		ModWsk[mod]->NormAC();
		return ;
	  }

	  if(param->LC0_ALEN >  32768L)
		{
		 if(::IsBadHugeWritePtr((void huge *)(param->LC0_AADDR),2*(param->LC0_ALEN)))
		  {
			  param->LC0_STATUS = LC0_BAD_BUF_ADR ;
		  }
		}
	  else
		{
		 if(::IsBadWritePtr((void far *)(param->LC0_AADDR),2*(UINT)(param->LC0_ALEN)))
		  {
			  param->LC0_STATUS = LC0_BAD_BUF_ADR ;
		  }
		}
	  if(param->LC0_STATUS != LC0_OK)
		{
		 ModWsk[mod]->NormAC();
		 return ;
		}
	}

	if((par->LC0_ASTST & 0xf0) != 0)
	 {
	  param->LC0_STATUS = LC0_ILL_STOP ;
	  ModWsk[mod]->NormAC();
	  return ;
	 }

	if(block)
	 {

	  if(ModWsk[mod]->AC_DMA == 0xff)
		{
		 param->LC0_STATUS = LC0_NO_DMA ;
		 ModWsk[mod]->NormAC();
		 return ;
		}

	  if(!syn)
		{
		 if(ModWsk[mod]->IRQ ==0xff)
		  {
			param->LC0_STATUS = LC0_NO_IRQ ;
			ModWsk[mod]->NormAC();
			return ;
		  }
		}

	  unsigned long omin , omax ;
	  float CTCfloat ;
	  if((par->LC0_AMODE & LC0_MOD_EXT_CLK) ==0)
		{
		 if(single)
		  omin = ModWsk[mod]->STable[0] ;
		 else
		  omin = ModWsk[mod]->STable[chan -1];

		 omax = (unsigned long int)((16.0*10.0*65535.0)/(float)ModWsk[mod]->CLK) ;
		 if((par->LC0_APER < omin) || (par->LC0_APER)>omax)
		  {
			param->LC0_STATUS = LC0_BAD_PER ;
			ModWsk[mod]->NormAC();
			return ;
		  }

		 CTCfloat = (float)(((float)ModWsk[mod]->CLK * (float)par->LC0_APER)/160.0) ;
		 CTCWord1 = (unsigned int)CTCfloat ;
		 param->LC0_ARDIV1=CTCWord1;param->LC0_ARDIV2=0;
		}
	 }
	else
	 {

	  if(par->LC0_ASTST ==LC0_SHARD)
		{
		 param->LC0_STATUS = LC0_ILL_START ;
		 ModWsk[mod]->NormAC();
		 return ;
		}

	  if((par->LC0_AMODE & LC0_MOD_EXT_CLK) !=0)
		{
		 param->LC0_STATUS = LC0_BAD_MODE ;
		 ModWsk[mod]->NormAC() ;
		 return ;
		}
	 }

	if(ModWsk[mod]->IsAsyncOpAC !=0)
	 {
	  param->LC0_STATUS = LC0_DEV_BUSY ;
	  ModWsk[mod]->ACValid = FALSE ;
	  return ;
	 }

	ModWsk[mod]->ACValid = TRUE ;
	ModWsk[mod]->ACParam = *par ;
	ModWsk[mod]->PAC.single=single ;
	ModWsk[mod]->PAC.block=block ;
	ModWsk[mod]->PAC.syn=syn ;
	ModWsk[mod]->PAC.longbuf=longbuf ;
	ModWsk[mod]->PAC.shard=shard ;
	ModWsk[mod]->PAC.chan=chan ;
	if((par->LC0_AMODE & LC0_MOD_EXT_CLK) ==0)
	 ModWsk[mod]->PAC.CTCWord1=CTCWord1 ;
	ModWsk[mod]->PAC.PStop.samples=ll ;
	ModWsk[mod]->PAC.PStart=par->LC0_ASTART ;
	ModWsk[mod]->PAC.PStSt=par->LC0_ASTST ;
	ModWsk[mod]->PAC.Mode=par->LC0_AMODE ;
  }
 else
  {
	single=ModWsk[mod]->PAC.single ;
	block=ModWsk[mod]->PAC.block ;
	syn=ModWsk[mod]->PAC.syn ;
	longbuf=ModWsk[mod]->PAC.longbuf ;
	shard=ModWsk[mod]->PAC.shard ;
	chan=ModWsk[mod]->PAC.chan ;
	CTCWord1=ModWsk[mod]->PAC.CTCWord1 ;
	ll=ModWsk[mod]->PAC.PStop.samples ;
	par->LC0_ASTART=ModWsk[mod]->PAC.PStart ;
	par->LC0_ASTST =ModWsk[mod]->PAC.PStSt ;
	par->LC0_AMODE=ModWsk[mod]->PAC.Mode ;
  }
 /*****************************************************************
	Koniec czci zwizanej z analiz parametrw przetwarzania :
	dalej cz pomiarowa - algorytmy patrz instrukacja obsugi
 ******************************************************************/
  if(((param->LC0_AMODE) & LC0_MOD_START)!=0)
	{
	 base = ModWsk[mod]->BaseAdr ;
	 if(par->LC0_AMODE & LC0_MOD_EXT_MEM)
	  {
		ptrfar  = param->LC0_AMEMA ;
		ptrhuge = (int huge *)(param->LC0_AMEMA) ;
	  }
	 else
	  {
		ptrfar  = param->LC0_AADDR ;
		ptrhuge = (int huge *)(param->LC0_AADDR) ;
	  }

	 if(par->LC0_ASTST !=LC0_SHARD)
	  {
		ptr = (unsigned char *)(&(par->LC0_ASTART));
		for(ii=0;ii<5;ii++)
		 part[ii]=*(ptr+ii);
		ptime = par->LC0_ASTART.time ;
		shard = FALSE ;
	  }
	 else
	  shard = TRUE ;

	 param->LC0_ARMNUM = 0;
	 if(ll==0)
	  {
		ModWsk[mod]->PAC.DevBusy = FALSE;
		return ;
	  }
	 if(block)
	  {

		if((par->LC0_AMODE & 0x1000) !=0)
		 WEPAC.page =1;
		else
		 WEPAC.page =0;

		if(syn)
		 {

		  if((GData.WinFlags & WF_STANDARD) != 0)
			{
			 param->LC0_STATUS = LC0_NO_DMA_TRANS ;
			 ModWsk[mod]->NormAC();
			 return ;
			}

		  pstr.par1 = 2*ll;
		  if(longbuf)
			{
			 pstr.par2 = FP_OFF(ptrfar);
			 pstr.par3 = FP_SEG(ptrfar);
			}
		  else
			{
			 pstr.par2 = FP_OFF(ptrhuge);
			 pstr.par3 = FP_SEG(ptrhuge);
			}
		  pstr.par4 = 0; pstr.par5 = 0;

		  err = pPx->Fun6(&pstr,0);

		  switch(err)
			{
			 case 0x04		:
			 case 0x06		:param->LC0_STATUS = LC0_NO_DMA_TRANS ;
								 break ;
			 case 0x05		:
								 param->LC0_STATUS = LC0_PREMATURE_END ;

								 break;
			 case 0x07		:if(par->LC0_AMODE & LC0_MOD_EXT_MEM)
									param->LC0_STATUS = LC0_BAD_EXTMEM ;
								 else
									param->LC0_STATUS = LC0_BAD_BUF_ADR ;
								 if(pstr.par4 != 0)
								  pPx->Fun7(&pstr,0);
								 break ;
			};

		  if(param->LC0_STATUS !=LC0_OK )
			{
			 ModWsk[mod]->NormAC() ;
			 return ;
			}

		  err = pPx->Fun3(ModWsk[mod]->AC_DMA);
		  if(err!= 0)
			{
			 param->LC0_STATUS = LC0_NO_DMA_TRANS ;
			 ModWsk[mod]->NormAC() ;
			 pPx->Fun7(&pstr,0);
			 return ;
			}

		  ldiv_t dx;
		  if(longbuf)
			{
			 il_b = (unsigned int)65535 ;
			 dx=ldiv(2L*ll,65536L);
			 WEPAC.nst=(unsigned int)dx.quot;
			 WEPAC.est=(2.0*(float)ll - (float)WEPAC.nst*65536.0) ;
			}
		  else
			{
			 il_b = (unsigned int)(2*ll -1);
			 WEPAC.nst = 0;
			 WEPAC.est = il_b;
			}
		  WEPAC.RejMaskiKan = 0x0a ;
		  WEPAC.modnum=mod;
		  WEPAC.st=0;
		  WEPAC.kanDMA = ModWsk[mod]->AC_DMA ;
		  WEPAC.v3=(unsigned char)((WEPAC.est-1)& 0x00ff);
		  WEPAC.v4=(unsigned char)((WEPAC.est-1)>> 8);
		  WEPAC.base = ModWsk[mod]->BaseAdr ;
		  ModPtrAC=ModWsk[mod];
		  switch(WEPAC.kanDMA)
			{
			 case 0 :WEPAC.LicznTransmisji = 0x01 ;
						WEPAC.RejStrony = 0x87;
						break ;
			 case 1 :WEPAC.LicznTransmisji = 0x03 ;
						WEPAC.RejStrony = 0x83;
						break ;
			 case 2 :WEPAC.LicznTransmisji = 0x05 ;
						WEPAC.RejStrony = 0x81;
						break ;
			 case 3 :WEPAC.LicznTransmisji = 0x07 ;
						WEPAC.RejStrony = 0x82;
						break ;
			};

		  if(par->LC0_ASTST !=LC0_SHARD)
			{
			 errcode = WaitForStart(par->LC0_ASTST ,part,ptime ,&errex,param->LC0_AMODULE,0);
			 if(errcode!=LC0_OK)
			  {
				param->LC0_STATUS = errcode ;
				param ->LC0_ERR_STAT = errex ;
				ModWsk[mod]->NormAC() ;
				pPx->Fun7(&pstr,0);
				pPx->Fun2(ModWsk[mod]->AC_DMA);
				return ;
			  }
			}

		  if(!single)
			{
			 period =  ModWsk[mod]->TSamp;
			 outportb(base+CTC+3,0x34);
			 ModWsk[mod]->Reset();
			 // ustawienie wstpne multipleksera
			 outportb(base+MUX_W,0);
			 switch (chan)
			  {
				case 2  :val1 = 0xd0;
						 break;
				case 4  :val1 = 0xb0;
						 break;
				case 8  :val1 = 0x70;
						 break;
			  };
			 val1 |= _EN_DMA | _SINGLE;
			 ModWsk[mod]->PSTS1 = val1 ;
			 outportb(base+STATUS_OUT,val1);
			 term = chan;
			 norm = ModWsk[mod]->PSTS1 ; //wartosc nieaktywna
			 // gramy deza

			 inportb(base+SET_EN_START);
			 // cay blok
			 for(loop=0;loop<1;loop++)
			  {
				outportb(base+ADC_W,0xff);
				for(step=0;step<term;step++)
				 {
				  for(J=0;J<period;J++)
					{
					 _asm nop
					}

				  inportb(base+ADC_R);
				  inportb(base+ADC_R);
				 }
			  }

			 ModWsk[mod]->PSTS1 = norm ;
			 outportb(base+STATUS_OUT,ModWsk[mod]->PSTS1);
			}

		  ModWsk[mod]->Reset();

		  inportb(base);
		  if(!single)
			{
			  outportb(base+CTC +3 ,0x34);
			  outportb(base+MUX_W,0);
			}

		  if((par->LC0_AMODE & LC0_MOD_EXT_CLK) ==0)
			{
			 outportb(base+CTC +3 ,0x34);
			 outportb(base+CTC,(unsigned char)(CTCWord1 & 0x00ff));
			 outportb(base+CTC,(unsigned char)(CTCWord1 >> 8));
			}

		  if(single)
			{
			 val1 = _EN_3_CHN | _EN_2_CHN | _EN_1_CHN  | _EN_DMA ;
			 ModWsk[mod]->PSTS1 = val1 ;
			 ModWsk[mod]->PSTS1 &=0xfd;
			 outportb(base+STATUS_OUT,val1) ;
			 outportb(base+MUX_W,chan-1);
			}
		  else
			{
			 switch (chan)
			  {
				 case 2  :val1 = 0xd0;
							 break;
				 case 4  :val1 = 0xb0;
							 break;
				 case 8  :val1 = 0x70;
							 break;
			  };
			 val1 |= _SINGLE;
			 ModWsk[mod]->PSTS1 = val1 ;
			 outportb(base+STATUS_OUT,val1);
			}

			norm = (ModWsk[mod]->PSTS1)|_EN_DMA ;
			WEPAC.strona=ProgDMA8(ModWsk[mod]->AC_DMA,1,0,0,il_b ,pstr.par5);
			if((par->LC0_AMODE & LC0_MOD_EXT_CLK) ==0)
			  ModWsk[mod]->PSTS1 |=_DIS_CTC_0;

			if(!single)
			  ModWsk[mod]->Reset();

			errcode = WaitForEndAC( WEPAC.strona,
											WEPAC.nst,
											WEPAC.est,
											WEPAC.page,
											WEPAC.st,
											WEPAC.kanDMA,
											WEPAC.LicznTransmisji,
											WEPAC.RejStrony,
											WEPAC.RejMaskiKan ,
											WEPAC.v3,
											WEPAC.v4,
											WEPAC.base,
											shard,
											&(param->LC0_ARMNUM));

		  ModWsk[mod]->PSTS1 = norm ;
		  outportb(base+STATUS_OUT,ModWsk[mod]->PSTS1);

		  ModWsk[mod]->Reset();
		  disableDMA8(ModWsk[mod]->AC_DMA);

		  if(param->LC0_ARMNUM >ll )
			param->LC0_ARMNUM = ll;

		  if(errcode == LC0_BROKEN)
			{
			 param->LC0_STATUS = errcode ;
			 param ->LC0_ERR_STAT =LC0_E_BROKEN_RUN ;
			 ModWsk[mod]->MessageBreak();
			}
		  else
			param->LC0_STATUS = errcode ;

		  if((pstr.par4 !=0) && (param->LC0_ARMNUM !=0))
			{
			 pstr.par1 = 2*(param->LC0_ARMNUM) ;
			 err = pPx->Fun9(&pstr,0);
			 if(err != 0)
			  {
				param->LC0_STATUS= LC0_PREMATURE_END ;
			  }
			}


		  pPx->Fun7(&pstr,0);
		  pPx->Fun2(ModWsk[mod]->AC_DMA);

		 }
		else
		 {
		  param->LC0_STATUS = LC0_NOT_SUPPORTED ;
		  ModWsk[mod]->NormAC();
		  return ;
		 }
	  }
	 else
	  {

		errcode = WaitForStart(par->LC0_ASTST ,part,ptime ,&errex,param->LC0_AMODULE,0);
		if(errcode!=LC0_OK)
		  {
			param->LC0_STATUS = errcode ;
			param ->LC0_ERR_STAT = errex ;
			ModWsk[mod]->NormAC() ;
			return ;
		  }

		period =  ModWsk[mod]->TSamp;
		outportb(base+CTC+3,0x34);
		ModWsk[mod]->Reset();
		if(single)
		 {
		  val1 = _EN_3_CHN | _EN_2_CHN | _EN_1_CHN  | _EN_DMA ;
		  ModWsk[mod]->PSTS1 = val1 ;
		  outportb(base+STATUS_OUT,val1) ;
		  outportb(base+MUX_W,chan-1);
		  term=1;
		 }
		else
		 {
		  outportb(base+MUX_W,0);
		  switch (chan)
			{
			 case 2  :val1 = 0xd0;
						 break;
			 case 4  :val1 = 0xb0;
						 break;
			 case 8  :val1 = 0x70;
						 break;
			};
		  val1 |= _EN_DMA | _SINGLE;
		  ModWsk[mod]->PSTS1 = val1 ;
		  outportb(base+STATUS_OUT,val1);
		  term = chan;
		 }
		 norm = ModWsk[mod]->PSTS1 ;
		 inportb(base+SET_EN_START);
		 for(loop=0;loop<ll;loop++)
		  {
			outportb(base+ADC_W,0xff);
			for(step=0;step<term;step++)
			 {
				for(J=0;J<period;J++)
				 {
				  _asm nop
				 }
				val1 = inportb(base+ADC_R);
				val2 = inportb(base+ADC_R);
				samp = (val2 <<8)+ val1 ;
				if(longbuf)
				 *(ptrhuge+(param->LC0_ARMNUM)) = samp;
				else
				 *(ptrfar + (UINT)(param->LC0_ARMNUM))=samp;
				param->LC0_ARMNUM ++;
				if(param->LC0_ARMNUM == ll)
				  goto laba;
			 }

			if(ModWsk[mod]->SynEnable)
			 {
			  if(IntBreak(&mes)==FALSE)
				{
				 ModWsk[mod]->PSTS1 = norm ;
				 outportb(base+STATUS_OUT,ModWsk[mod]->PSTS1);
				 ModWsk[mod]->Reset();
				 ModWsk[mod]->MessageBreak();
				 param->LC0_ERR_STAT = LC0_E_BROKEN_RUN ;
				 param->LC0_STATUS = LC0_BROKEN ;
				 break ;
				}
			 }
		  }

  laba:ModWsk[mod]->PSTS1 = norm ;
		 outportb(base+STATUS_OUT,ModWsk[mod]->PSTS1);

		 ModWsk[mod]->Reset();
	  }

	 if((par->LC0_AMODE & LC0_MOD_EXT_MEM) && (par->LC0_AMODE & LC0_MOD_MEM_W))
	  {
		unsigned long i ;
		for(i=0;i<param->LC0_ARMNUM;i++)
		 {
		  if(param->LC0_ARLEN >= param->LC0_ALEN)
			{
			 param->LC0_STATUS = LC0_OTHER_LEN ;
			 break ;
			}
		  if(longbuf)
			{
			 *(((int huge *)(param->LC0_AADDR))+i) = *(ptrhuge+i);
			}
		  else
			{
			 *(((int far *)(param->LC0_AADDR))+(UINT)i) = *(ptrfar+(UINT)i);
			}
		  param->LC0_ARLEN ++ ;
		 }
	  }
	}

 ModWsk[mod]->PAC.DevBusy=FALSE;
}




