/************************************************************************/
/* Projekt : "lc1108a.dll" - biblioteka DLL WINDOWS dla karty LC-011-0812 */
/* Autor : Krzysztof Mroczek 1996                                        */
/************************************************************************/
#define  STRICT
#include <windows.h>
#pragma hdrstop
#define _EXPORT _export
#include  <dos.h>
#include  "lc1108a.h"
#include  "1108int.h"

#define CTC02P 16

extern CModuleData *ModWsk[3]	;
extern global GData				;
struct CModuleData *ModPtrCA;
/////////////////////////////////////////////////////////////////////////
// ANALOG_OUT
// Funkcja LC0_AnalogOut :
//  Sterowanie torem C/A i konwersjami C/A moduu .
//  Jest zaimplementowana praca synchroniczna tzn. driver zwraca sterowanie
//  do wywolujcego go programu po zakoczeniu przetwarzania .
//  Tryby pracy :
//   - praca programowa z programowymi sterowaniami
//   - praca 1-o / wielokanalowa
//	  - pojedyncze lub wielokrotne sterowanie
// Parametry wywoania :
//  param : daleki wskanik do struktury 'lc0_analog_out' z parametrami
//    wywoania i statusu .
// 
/////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_AnalogOut(lc0_analog_out FAR *param)
{
 char errcode ;
 unsigned char mod ;
 BOOL single		 ;
 BOOL block			 ;
 BOOL longbuf		 ;

 unsigned long ll  ;
 lc0_analog_out *par;

 int far  *ptrfar;
 int huge *ptrhuge ;
 char  errex;
 unsigned char part[5] ,*ptr;
 unsigned long ptime , I=0 ;
 unsigned int base,samp,ii ;
 unsigned char val1,val2 ;
 MSG mes;

 param->LC0_ERR_STAT = LC0_E_OK		  ;
 param->LC0_STATUS = LC0_OK ;
 param->LC0_NRMNUM = 0 ;

 if((param->LC0_NMODULE >= LC0_MODA) && (param->LC0_NMODULE <= LC0_MODD))
  {
	errcode = ModWsk[(param->LC0_NMODULE) -1 ]->CheckApp();

	if(errcode != LC0_OK)
	 {
		param->LC0_STATUS = errcode ;
		return ;
	 }
  }
 else
  {
	param->LC0_STATUS = LC0_NO_MODULE ;
	return ;
  }

  mod = param->LC0_NMODULE -1 ;
 if(ModWsk[mod]->PCA.DevBusy)
 {
	param->LC0_STATUS = LC0_DEV_BUSY ;
	return ;
 }
 ModWsk[mod]->PCA.DevBusy=TRUE;

 if(((param->LC0_NMODE) & LC0_MOD_NEW_PAR)==0 ) //stare
  {

	 if(ModWsk[mod]->CAValid)
		par = &(ModWsk[mod]->CAParam) ;
	 else
	  {
		param->LC0_STATUS = LC0_NO_PARAMS ;
		ModWsk[mod]->PCA.DevBusy=FALSE;
		return ;
	  }
  }
 else
  {
	par = param ;
  }

 if(((param->LC0_NMODE) & LC0_MOD_NEW_PAR)!=0)
  {

	if(par->LC0_NNUM == 0 || par->LC0_NNUM >ModWsk[mod]->CA_channels )
	{
	 param->LC0_STATUS = LC0_NONEX_DEV ;
	 ModWsk[mod]->NormCA();
	 return ;
	}


	if((par->LC0_NCHAN & 0x80)==0)
	{
	 if(par->LC0_NCHAN != 0x01 )
	  {
		param->LC0_STATUS = LC0_BAD_CHAN_N ;
		ModWsk[mod]->NormCA();
		return ;
	  }
	 single = FALSE ;
	}
	else
	 {
	  if(par->LC0_NCHAN != 0x81 )
		{
		 param->LC0_STATUS = LC0_BAD_CHAN ;
		 ModWsk[mod]->NormCA();
		 return ;
		}
	  single = TRUE ;
	 }


	if((par->LC0_NMODE & LC0_MOD_CYCL) != 0)
	 {
	  param->LC0_STATUS = LC0_BAD_MODE;
		ModWsk[mod]->NormCA();
		return ;
	 }

	if((par->LC0_NMODE & LC0_MOD_BLOCK) != 0)
	 {
	  block = TRUE ;
	  ll = par->LC0_NSTOP.samples ;
	 }
	else
	 {
	  block = FALSE ;
	  if(single)
		ll = 1 ;
	  else
		ll = 2;
	 }

	if(block)
	 if(ll > 32768)
	  longbuf = TRUE ;
	 else
	  longbuf = FALSE ;
	if(par->LC0_NMODE & LC0_MOD_EXT_MEM)
	 {

	  if(ModWsk[mod]->ExMem ==0 || ModWsk[mod]->ExSize ==0 || ModWsk[mod]->ptrex ==NULL )
		{
		 param->LC0_STATUS = LC0_NO_EXTMEM ;
		 ModWsk[mod]->NormCA();
		 return ;
		}


	  if((ModWsk[mod]->ExSize)/2 < ll)
		{
		 param->LC0_STATUS = LC0_BAD_BUF_LEN;
		 ModWsk[mod]->NormCA();
		 return ;
		}

	  errcode = 0;
	  if(longbuf)
		{
		 if(::IsBadHugeReadPtr((void huge *)(param->LC0_NADDR.extended_memory),2*ll))
		  errcode = 1;
		}
	  else
		{
		 if(::IsBadReadPtr((void far *)(param->LC0_NADDR.extended_memory),2*(UINT)ll))
			errcode = 1;
		}
	  if(errcode !=0)
		{
		 param->LC0_STATUS = LC0_BAD_BUF_ADR;
		 ModWsk[mod]->NormCA();
		 return ;
		}
	 }
	else
	 {
	  if(param->LC0_NLEN == 0)
		{
		 param->LC0_STATUS = LC0_BAD_BUF_LEN ;
		 ModWsk[mod]->NormCA();
		 return ;
		}

	  if(block)
		{
		 if(par->LC0_NLEN < ll)
		  {
			param->LC0_STATUS = LC0_BAD_BUF_LEN ;
			ModWsk[mod]->NormCA();
			return ;
		  }
		}

	  errcode = 0;
	  if(param->LC0_NLEN > 32768)
		{

		 if(::IsBadHugeReadPtr((void huge *)(param->LC0_NADDR.base_memory),2*(param->LC0_NLEN)))
			errcode = 1;
		}
	  else
		{

		 if(::IsBadReadPtr((void far *)(param->LC0_NADDR.base_memory),2*(UINT)(param->LC0_NLEN)))
		  errcode = 1;
		}

	  if(errcode !=0)
		{
		 param->LC0_STATUS = LC0_BAD_BUF_ADR ;
		 ModWsk[mod]->NormCA();
		 return ;
		}
	 }

	if((par->LC0_NSTST & 0xf0) != 0)
	 {
	  param->LC0_STATUS = LC0_ILL_STOP ;
	  ModWsk[mod]->NormCA();
	  return ;
	 }

	ModWsk[mod]->CAValid = TRUE ;
	ModWsk[mod]->CAParam = *par ;

	ModWsk[mod]->PCA.block=block ;

	ModWsk[mod]->PCA.single=single ;
	ModWsk[mod]->PCA.longbuf=longbuf ;
	ModWsk[mod]->PCA.PStop.samples=ll ;
	ModWsk[mod]->PCA.PStart=par->LC0_NSTART ;
	ModWsk[mod]->PCA.PStSt=par->LC0_NSTST ;
	ModWsk[mod]->PCA.Mode=par->LC0_NMODE ;

  }
 else
  {
	block=ModWsk[mod]->PCA.block ;
	single=ModWsk[mod]->PCA.single ;
	longbuf=ModWsk[mod]->PCA.longbuf ;
	ll=ModWsk[mod]->PCA.PStop.samples ;
	par->LC0_NSTART=ModWsk[mod]->PCA.PStart ;
	par->LC0_NSTST =ModWsk[mod]->PCA.PStSt ;
	par->LC0_NMODE=ModWsk[mod]->PCA.Mode ;
  }
 if(param->LC0_NMODE & LC0_MOD_START)
  {

	if(par->LC0_NMODE & LC0_MOD_EXT_MEM)
	 {
	  ptrfar  = param->LC0_NADDR.extended_memory ;
	  ptrhuge = (int huge *)(param->LC0_NADDR.extended_memory) ;
	 }
	else
	 {
	  ptrfar  = param->LC0_NADDR.base_memory ;
	  ptrhuge = (int huge *)(param->LC0_NADDR.base_memory) ;
	 }
	base = ModWsk[mod]->BaseAdr ;

	ptr = (unsigned char *)(&(par->LC0_NSTART));
	for(ii=0;ii<5;ii++)
	 part[ii]=*(ptr+ii);
	ptime = par->LC0_NSTART.time ;

	errcode = WaitForStart(par->LC0_NSTST ,part,ptime ,&errex,param->LC0_NMODULE,1);
	if(errcode!=LC0_OK) //by bd
	 {
	  param->LC0_STATUS = errcode ;
	  param ->LC0_ERR_STAT = errex ;
	  ModWsk[mod]->NormCA();
	  return ;
	 }

	if(block && (ll==0))
	 {
	  ModWsk[mod]->NormCA();
	  return ;
	 }
	ModWsk[mod]->Reset();
	do
	  {
		samp = *(ptrhuge +I++);
		val1 = (unsigned char)(samp & 0x00ff) ;
		val2 = (unsigned char)((samp & 0x0f00)>>8);
		if(single)
		 {
		  if(par->LC0_NNUM == 1)
			{
			 outportb(base+DAC1_L,val1);
			 outportb(base+DAC1_H,val2);
			}
		  else
			{
			 outportb(base+DAC2_L,val1);
			 outportb(base+DAC2_H,val2);
			}
		  param->LC0_NRMNUM ++;
		 }
		else
		 {
		  outportb(base+DAC1_L,val1);
		  outportb(base+DAC1_H,val2);
		  samp = *(ptrhuge +I++);
		  val1 = (unsigned char)(samp & 0x00ff) ;
		  val2 = (unsigned char)((samp & 0x0f00)>>8);
		  outportb(base+DAC2_L,val1);
		  outportb(base+DAC2_H,val2);
		  param->LC0_NRMNUM +=2;
		 }

		if(ModWsk[mod]->SynEnable)
		 {
		  if(ModWsk[mod]->AsyncEnable==0)
			{
			 ModWsk[mod]->AsyncEnable=1;
			 param->LC0_ERR_STAT = LC0_E_BROKEN_RUN ;
			 param->LC0_STATUS = LC0_BROKEN ;
			 break;
			}
		  if(IntBreak(&mes)==FALSE)
			{
			 ModWsk[mod]->MessageBreak();
			 param->LC0_ERR_STAT = LC0_E_BROKEN_RUN ;
			 param->LC0_STATUS = LC0_BROKEN ;
			 break;
			}
		 }
	  }
	while(I < ll)  ;
	ModWsk[mod]->Reset();
  }
 ModWsk[mod]->PCA.DevBusy=FALSE;
}

