/************************************************************************/
/* Projekt : "lc1108a.dll" - biblioteka DLL WINDOWS dla karty LC-011-0812 */
/* Autor : Krzysztof Mroczek	1996                                       */
/************************************************************************/
#define  STRICT
#include <windows.h>
#pragma hdrstop
#define _EXPORT _export
#include  "lc1108a.h"
#include  "1108int.h"

extern CModuleData *ModWsk[3]	;
////////////////////////////////////////////////////////////////////////////
// BREAK
// Funkcja LC0_Break :
//  Intalacja / deinstalacja procedury monitorowania wcisnicia klawisz
//  CTRL-BREAK oraz zatrzymanie procesu A/C / C/A / DIN/DOUT w przypadku
//  operacji asynchronicznych .
// Dzialanie :
//  1. instalacja : zainstalowanie procedury przerwania procesu po wcisnieciu
//     CTRL-BREAK dla operacji synchronicznych i sprawdzania warunkow startu
//  2. deinstalacja : wylaczenie sprawdzania CTRL-BREAK zainstalowanego
//    wg. p.1
//  3. przerwanie procesu : dzialania tylko dla procesw asynchronicznych
// Operacja jest wykonywana dla wszystkich moduw przypisanej danej aplikacji.
// Parametry wejciowe :
//  param : daleki wskanik do  struktury 'lc0_break' z parametrami wywolania
//   i statusu .
////////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_Break(lc0_break FAR *param)
{
  char errcode ;
  int i , e1=0,e2=0;
  BOOL as ;

  param->LC0_STATUS = LC0_OK;
  param->LC0_ERR_STAT = LC0_E_OK		  ;

  if(param->LC0_BMODE>2)
	{
	 param->LC0_STATUS = LC0_BAD_MODE ;
	}
  else
	{
	 for(i=0;i<3;i++)
	  {
		 errcode = ModWsk[i]->CheckApp();

		 if(errcode==LC0_OK)
		  {
			switch(param->LC0_BMODE)
			 {
				case		0 :as = ModWsk[i]->IsAsyncOpAC || ModWsk[i]->IsAsyncOpCA ;
								if(as == TRUE)
								 {
								  ModWsk[i]->AsyncEnable = 0;
								  e1++;
								  param->LC0_ERR_STAT = LC0_E_BROKEN_RUN;
								 }
								else
								 e2++;
								break;
				case		1 :
								if(ModWsk[i]->SynEnable == 0)
								 {
								  ModWsk[i]->BreakProc = param->LC0_BPROC ;

								  ModWsk[i]->SynEnable = 1 ;
								 }
								else
								 param->LC0_STATUS = LC0_INTR_INST ;
								break;
				case		2 :
								ModWsk[i]->SynEnable = 0 ;
								break ;
			 };

		  }
	  }
	 if((e1==0) && (e2>0))
	  param->LC0_STATUS = LC0_NO_OPER ;
	}
}

