/************************************************************************/
/* Projekt : "lc1108a.dll" - biblioteka DLL WINDOWS dla karty LC-011-0812 */
/* Autor : Krzysztof Mroczek 1996                                        */
/************************************************************************/
#define  STRICT
#include <windows.h>
#pragma hdrstop
#define _EXPORT _export
#include  <dos.h>
#include  "lc1108a.h"
#include  "1108int.h"

extern CModuleData *ModWsk[3]	;

///////////////////////////////////////////////////////////////////////////
// CTC_WRITE
// Funkcja LC0_CTCWrite :
//  Zaprogramowanie wybranego licznika ukadu 8254 uytkownika oraz wpis
//  wartoci poczatkowej do licznika . Programowanie sprztu zgodne z
//  ukadem 8253/54 . Dla koci 8254 jest zaimplementowany zapis sowa
//  sterujcego Read Back Command , po ktrego odczycie odpowiedni bajt
//  statusu moe by odczytany funkcj LC0_CTCRead .
// Parametry wejciowe :
//  param : daleki wskanik do struktury 'lc0_ctc_write' z parametrami wywoania
//   i ststusu .
//////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_CTCWrite(lc0_ctc_write FAR *param)
{
	char errcode ;
	unsigned char p,val,val1,kan=0;
	unsigned int badr,adr1,adr2;
	unsigned char maska[]={0x01,0x02,0x04,0x08};

	param->LC0_ERR_STAT = LC0_E_OK		  ;
	param->LC0_STATUS = LC0_OK;
	if((param->LC0_CMODULE >= LC0_MODA) && (param->LC0_CMODULE <= LC0_MODC))
	 {
		errcode = ModWsk[(param->LC0_CMODULE) -1 ]->CheckApp();
		if(errcode!=LC0_OK)
		 {
			param->LC0_STATUS = errcode;
			return;
		 }
		badr = ModWsk[(param->LC0_CMODULE) -1 ]->BaseAdr;

		if((param->LC0_CMODE & 0x03) == 0x00 )
		 {
		  param->LC0_STATUS = LC0_BAD_CTC_MODE ;
		  return;
		 }

		 p=param->LC0_CFUN & 0x0c ;
		 if(p==0x0c)
		  {
			param->LC0_STATUS = LC0_BAD_CTC_MODE ;
			return;
		  }

		  p=param->LC0_CFUN & 0xC0 ;
		  if(p==0xC0)
			{

			 p= (param->LC0_CFUN & 0x0e) >>1;
			 for(int ii=0;ii<3;ii++)
				{
				  if((p & maska[ii])!=0)
					{
					 p = ii;
					 break;
					}
				}

			  if(p==0)
				{
				 param->LC0_STATUS = LC0_NONEX_DEV  ;
				 return;
				}

			  if((p==1) || (p==2))
				{
				 ModWsk[(param->LC0_CMODULE) -1 ]->RBCTCMode[p-1] = 1; //uwaga!!!
				 adr2 = badr+CTC + p ;
				 kan=p;
				}
			}
		  else
			{
			  if(p==0x00)
				{
				 param->LC0_STATUS = LC0_NONEX_DEV ;
				 return;
				}
			  if(p==0x40)
				{
				 ModWsk[(param->LC0_CMODULE) -1 ]->RBCTCMode[0] = 0;
				 adr2 = badr+CTC + 1 ;
				 kan =1;
				}
			  else
				{
				 ModWsk[(param->LC0_CMODULE) -1 ]->RBCTCMode[1] = 0;
				 adr2 = badr+CTC + 2 ;
				 kan=2;
				}
			  p=param->LC0_CFUN & 0x30 ;
			  if(p==0)
				{
				 param->LC0_STATUS = LC0_BAD_CTC_MODE ;
				 return;
				}
			  ModWsk[(param->LC0_CMODULE) -1 ]->RWCTCMode[kan-1] = p >> 4;
			}
			adr1 = badr+CTC + 3 ;
			val = param->LC0_CFUN ;
	 }
	else
	 {
		param->LC0_STATUS = LC0_NO_MODULE ;
		return ;
	 }

	 if((param->LC0_CMODE & 0x01)!=0 )
	  {
		outportb(adr1,val);
		if((param->LC0_CFUN & 0xC0) != 0xC0)
		 ModWsk[(param->LC0_CMODULE) -1 ]->IsCTCProg[kan-1] = 1;
		else
		 ModWsk[(param->LC0_CMODULE) -1 ]->IsCTCProg[kan-1] = 2;
	  }

	 if(((param->LC0_CMODE & 0x02)!=0 )&&
	 (ModWsk[(param->LC0_CMODULE) -1 ]->RBCTCMode[kan-1] == 0) )
	  {

		if(ModWsk[(param->LC0_CMODULE) -1 ]->IsCTCProg[kan-1] ==0)
		 {
		  param->LC0_STATUS = LC0_CTC_NOT_PROGRAMMED ;
		  return ;
		 }

		val = (unsigned char)(param->LC0_CVAL & 0x00ff);
		outportb(adr2,val);
		if(ModWsk[(param->LC0_CMODULE) -1 ]->RWCTCMode[kan-1] == 3)
		 {
		  val1 = (unsigned char)(param->LC0_CVAL >> 8);
		  outportb(adr2,val1);
		 }

		ModWsk[(param->LC0_CMODULE) -1 ]->IsCTCProg[kan-1] = 2;
	  }
}

//////////////////////////////////////////////////////////////////////////
// CTC_READ
// Funkcja LC0_CTCRead :
//  Odczyt wartoci licznika CTC 8254 dostepnego dla uzytkownika oraz po
//  wczeniejszym zapisie komendy Read Back Command bajtu ststusu .
// Uwaga : Read Back Command jest tylko dla ukadw 8254 : patrz noty
// katalogowe ukadw 8253/8254 .
// Parametry wejciowe :
//  param : daleki wskanik do struktury 'lc0_ctc_read' z parametrami
//  wywoania i statusu .
//////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_CTCRead(lc0_ctc_read FAR *param)
{
 char errcode ;
 unsigned char val1,val2=0;
 unsigned int badr,adr1,adr2;

	param->LC0_ERR_STAT = LC0_E_OK		  ;
	param->LC0_STATUS = LC0_OK ;
	if((param->LC0_UMODULE >= LC0_MODA) && (param->LC0_UMODULE <= LC0_MODC))
	 {
		errcode = ModWsk[(param->LC0_UMODULE) -1 ]->CheckApp();
	 }
	else
	 {
		param->LC0_STATUS = LC0_NO_MODULE ;
		return ;
	 }
	if(errcode == LC0_OK)
	 {
	  badr = ModWsk[(param->LC0_UMODULE) -1 ]->BaseAdr;
	  if((param->LC0_UNUM ==0) || (param->LC0_UNUM >CTC_NUM) )
		{
		 param->LC0_STATUS = LC0_NONEX_DEV ;
		 return;
		}
	  switch(param->LC0_UNUM)
		{
		 case 1 :adr1 = badr+CTC+3;
					adr2 = badr+CTC+1;
					val1 = 0x40;
					break;
		 case 2 :adr1 = badr+CTC+3;
					adr2 = badr+CTC+2;
					val1 = 0x80;
					break;
		}
	  if(ModWsk[(param->LC0_UMODULE) -1 ]->IsCTCProg[param->LC0_UNUM-1] != 2)
		 {
		  param->LC0_STATUS = LC0_CTC_NOT_PROGRAMMED ;
		  return ;
		 }
	  if(ModWsk[(param->LC0_UMODULE) -1 ]->RBCTCMode[param->LC0_UNUM-1] ==0)
		 outportb(adr1,val1);
	  val1 = inportb(adr2);
	  if(ModWsk[(param->LC0_UMODULE) -1 ]->RWCTCMode[param->LC0_UNUM-1] ==3)
		{
		  if(ModWsk[(param->LC0_UMODULE) -1 ]->RBCTCMode[param->LC0_UNUM-1] ==0)
			val2=inportb(adr2);
		  else
			val2 = 0;
		}
	  param->LC0_UVAL = val1 + (val2<<8);
	 }
	else
	 param->LC0_STATUS = errcode ;
}

