/************************************************************************/
/* Projekt : "lc1108a.dll" - biblioteka DLL WINDOWS dla karty LC-011-0812 */
/* Autor : Krzysztof Mroczek 	 1996                                      */
/************************************************************************/
#define  STRICT
#include <windows.h>
#pragma hdrstop
#define _EXPORT _export
#include <dos.h>
#include  "lc1108a.h"
#include  "1108int.h"

extern CModuleData *ModWsk[3]	;

///////////////////////////////////////////////////////////////////////////
// DIGITAL_INPUT
// Funkcja LC0_DigitalIn :
//  Odczyt bajtu z wybranego portu cyfrowego karty :
//  Dziaaj parametry startu
// Parametry wejciowe :
//  param : daleki wskanik do struktury 'lc0_digital_in' z parametrami
//  wywoania i statusu .
///////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_DigitalIn(lc0_digital_in FAR *param)
{
 char errcode , errex;
 unsigned char par[5] ,*ptr;
 unsigned long ptime ;
 unsigned int ii ;

 param->LC0_ERR_STAT = LC0_E_OK		  ;
 param->LC0_STATUS = LC0_OK ;
 if((param->LC0_DMODULE >= LC0_MODA) && (param->LC0_DMODULE <= LC0_MODC))
  {
	errcode = ModWsk[(param->LC0_DMODULE) -1 ]->CheckApp();

	if(errcode != LC0_OK)
	 {
		param->LC0_STATUS = errcode ;
		return ;
	 }
  }
 else
  {
	param->LC0_STATUS = LC0_NO_MODULE ;
	return ;
  }
 // nr portu == 1
 if(param->LC0_DNUM != 1)
  {
	 param->LC0_STATUS = LC0_NONEX_DEV ;
	 return ;
  }
 /*parametry startu */
 ptr = (unsigned char *)(&(param->LC0_DSTART));
 for(ii=0;ii<5;ii++)
  par[ii]=*(ptr+ii);
 ptime = param->LC0_DSTART.time ;
 errcode = WaitForStart(param->LC0_DSTST ,par,ptime ,&errex,param->LC0_DMODULE,1);
  if(errcode!=LC0_OK)
	{
	  param->LC0_STATUS = errcode ;
	  param ->LC0_ERR_STAT = errex ;
	  return ;
	}
  // odczyt portu
  int pid ;
  pid = ModWsk[(param->LC0_DMODULE) - 1]->BaseAdr ;
  param->LC0_DVAL = inportb(pid + DIG_IN);
}

////////////////////////////////////////////////////////////////////////////
// DIGITAL_OUTPUT
// Funkcja LC0_DigitalOut :
//  Zapis bajtu do wybranego portu cyfrowego moduu :
//  Diaaj parametry startu .
// Parametry wejciowe :
//  param : daleki wskanik do struktury 'lc0_digital_out' z parametrami
//  wywoania i statusu .
////////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_DigitalOut(lc0_digital_out FAR *param)
{
 char errcode , errex;
 unsigned char par[5] ,*ptr;
 unsigned long ptime ;
 unsigned int ii;

 param->LC0_ERR_STAT = LC0_E_OK		  ;
 param->LC0_STATUS = LC0_OK ;
 if((param->LC0_OMODULE >= LC0_MODA) && (param->LC0_OMODULE <= LC0_MODC))
  {
	errcode = ModWsk[(param->LC0_OMODULE) -1 ]->CheckApp();

	if(errcode != LC0_OK)
	 {
		param->LC0_STATUS = errcode ;
		return ;
	 }
  }
 else
  {
	param->LC0_STATUS = LC0_NO_MODULE ;
	return ;
  }

 if(param->LC0_ONUM != 1)
  {
	 param->LC0_STATUS = LC0_NONEX_DEV ;
	 return ;
  }

 ptr = (unsigned char *)(&(param->LC0_OSTART));
 for(ii=0;ii<5;ii++)
  par[ii]=*(ptr+ii);
 ptime = param->LC0_OSTART.time ;

  errcode = WaitForStart(param->LC0_OSTST ,par,ptime ,&errex,param->LC0_OMODULE,1);

  if(errcode!=LC0_OK)
	{
	  param->LC0_STATUS = errcode ;
	  param ->LC0_ERR_STAT = errex ;
	  return ;
	}

  int pid , oval;
  pid = ModWsk[(param->LC0_OMODULE) - 1]->BaseAdr ;
  oval = param->LC0_OVAL ;
  outportb(pid+DIG_OUT,oval);
}

