/************************************************************************/
/* Projekt : "lc1108a.dll" - biblioteka DLL WINDOWS dla karty LC-011-0812 */
/* Autor : Krzysztof Mroczek 	1996                                       */
/************************************************************************/
#define  STRICT
#include <windows.h>
#pragma hdrstop
#define _EXPORT _export
#include  "lc1108a.h"
#include  "1108int.h"

extern CModuleData *ModWsk[3]	;
///////////////////////////////////////////////////////////////////////////
// DATA_TRANSMIT
// Funkcja LC0_DataTransmit
//  Transmisja danych pomidzy buforem uzytkownika a buforem w pamici
//  rozszerzonej
// Parametry wywoania :
//  param : daleki wskanik do struktury 'lc0_transmit' z parametrami wywoania
//  i statusu .
////////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_DataTransmit(lc0_transmit FAR *param)
{
  unsigned long   i ;
  BOOL err;
  param->LC0_ERR_STAT = LC0_E_OK ;
  param->LC0_STATUS = LC0_OK;
  param->LC0_RRNUM = 0;
  param->LC0_STATUS = LC0_OK ;
  char errcode ;
  unsigned char mod;

  if((param->LC0_RMODULE >= LC0_MODA) && (param->LC0_RMODULE <= LC0_MODC))
	 {
		errcode = ModWsk[(param->LC0_RMODULE) -1 ]->CheckApp();

		if(errcode!=LC0_OK)
		 {
		  param->LC0_STATUS = errcode;
		 }
	 }
	else
	 {
		param->LC0_STATUS = LC0_NO_MODULE ;
	 }

  if(param->LC0_STATUS !=LC0_OK)
	return;

  if(param->LC0_RMODE > 1)
	{
	 param->LC0_STATUS = LC0_BAD_MODE ;
	 return ;
	}
  mod= param->LC0_RMODULE -1;
  if(ModWsk[mod]->ExMem ==0 || ModWsk[mod]->ptrex ==NULL)
	{
	 param->LC0_STATUS = LC0_NO_EXTMEM ;
	 return ;
	}

  if(param->LC0_RMEAS == 0)
	 {
		param->LC0_STATUS = LC0_BAD_MNUM;
		return;
	 }

  if(param->LC0_RMODE==LC0_FROM_EXT_DIR)
	{
	 err =::IsBadHugeWritePtr((void huge *)(param->LC0_RADDR),2*(param->LC0_RLEN));
	 if(err)
	  {
		param->LC0_STATUS = LC0_BAD_BUF_ADR;
		return ;
	  }
	 err=::IsBadHugeReadPtr((void huge *)(param->LC0_RMEMA),2*(param->LC0_RNUM +
	 param->LC0_RMEAS -1));
	 if(err)
	  {
		param->LC0_STATUS = LC0_BAD_EXTMEM;
		return ;
	  }
	unsigned long j ;
	j =(ModWsk[mod]->ExSize)/2;
	 for(i=0;i<param->LC0_RNUM ;i++)
	  {
		 if( i >j )
		  {
			 param->LC0_STATUS = LC0_OTHER_LEN ;
			 param->LC0_RRNUM = i -1 ;
			 break ;
			}
		  if(i==param->LC0_RLEN)
			{
			 param->LC0_STATUS = LC0_OTHER_LEN ;
			 break ;
			}

		 *((int huge *)(param->LC0_RADDR) + i )= *((int huge *)(param->LC0_RMEMA) +i +
		 param->LC0_RMEAS -1);
		 param->LC0_RRNUM++;
	  }
	 }
  else
	{
	 err =::IsBadHugeReadPtr((void huge *)(param->LC0_RADDR),2*(param->LC0_RLEN));
	 if(err)
	  {
		param->LC0_STATUS = LC0_BAD_BUF_ADR;
		return ;
	  }
	 err =::IsBadHugeWritePtr((void huge *)(param->LC0_RMEMA),2*(param->LC0_RNUM));
	 if(err)
	  {
		param->LC0_STATUS = LC0_BAD_EXTMEM;
		return ;
	  }
	 if(param->LC0_RMEAS >param->LC0_RLEN)
	  {
		param->LC0_STATUS = LC0_BAD_MNUM ;
		return ;
	  }
	 for(i=0;i<param->LC0_RNUM ;i++)
	  {
		 if(param->LC0_RLEN <= param->LC0_RMEAS -1 + i)
			{
			 param->LC0_STATUS = LC0_OTHER_LEN ;
			 break ;
			}

		 *((int huge *)(param->LC0_RMEMA) + i )= *((int huge *)(param->LC0_RADDR) +i +
		 param->LC0_RMEAS -1);
		 param->LC0_RRNUM++;

	  }
	  param->LC0_RRNUM = i ;
	}
}

