/************************************************************************/
/* Projekt : "lc1108a.dll" - biblioteka DLL WINDOWS dla karty LC-011-0812 */
/* Autor : Krzysztof Mroczek 	 1996                                      */
/************************************************************************/
#define  STRICT
#include <windows.h>
#pragma hdrstop
#define _EXPORT _export
#include  "lc1108a.h"
#include  "1108int.h"

 extern CModuleData *ModWsk[3]	;

////////////////////////////////////////////////////////////////////////////
// GET_TOTAL_CONFIGURATION
// Funkcja LC0_GetTotalConf :
//  Uzyskanie informacji o konfiguracji globalnej wszystkich zainstalowanych
//  moduw LC-011-0812 .
// Parametry wywoania :
// param : daleki wskanik do struktury 'lc0_total' z parametrami wywoania
//  i statusu .
////////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_GetTotalConf(lc0_total FAR *param)
{
 unsigned char mask[] = {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
 param->LC0_TONF = 0;
 param->LC0_TIAD = 0;
 param->LC0_TIDA = 0;
 param->LC0_TCTC = 0;
 param->LC0_TIDI = 0;
 param->LC0_TIDO = 0;
 param->LC0_STATUS = LC0_OK ;
 param->LC0_ERR_STAT = LC0_E_OK ;
 int i ;
 for(i=0;i<3;i++)
  {
	if(ModWsk[i]->IsLoaded==TRUE)
	 {
	  param->LC0_TONF|=mask[i];
	  if(ModWsk[i]->mode==1)
		param->LC0_TONF|=mask[i+4];
	  param->LC0_TIAD += AC_NUM ;
	  param->LC0_TIDA += ModWsk[i]->CA_channels ;
	  param->LC0_TCTC += CTC_NUM ;
	  param->LC0_TIDI += DIN_NUM ;
	  param->LC0_TIDO += DOUT_NUM ;
	 }
  }
}

////////////////////////////////////////////////////////////////////////////
// GET_MODULE_INFORMATION
// Funkcja LC0_GetModule :
//  Uzyskanie informacji o konfiguracji szczegowej danego moduu .
// Parametry wywoania :
//  param : daleki wskanik do struktury 'lc0_module' z parametrami wywoania
//  i statusu .
////////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_GetModule(lc0_module  FAR *param)
{
 int i ;
 param->LC0_ERR_STAT = LC0_E_OK ;
 if((param->LC0_MMODULE >=LC0_MODA)&&(param->LC0_MMODULE <=LC0_MODC))
  {
	if(ModWsk[(param->LC0_MMODULE)-1]->InitError == LC0_BAD_CONFIG)
	 {
	  param->LC0_STATUS = LC0_BAD_CONFIG ;
	  return;
	 }

	if(ModWsk[(param->LC0_MMODULE)-1]->IsLoaded == TRUE)
	 {
	  i = param->LC0_MMODULE -1 ;
	  param->LC0_STATUS = LC0_OK ;
	  param->LC0_MBASE1 = ModWsk[i]->BaseAdr ;
	  param->LC0_MIAD	  = AC_NUM ;
	  param->LC0_MIDA	  = ModWsk[i]->CA_channels ;
	  param->LC0_MCTC	  = CTC_NUM ;
	  param->LC0_MIDI	  = DIN_NUM	;
	  param->LC0_MIDO	  = DOUT_NUM ;
	  param->LC0_MCLOCK = (ModWsk[i]->CLK)*1000 ;
	  // nieokrelone
	  param->LC0_MINT	  = 0 ;
	  param->LC0_MMEMA	 = (int FAR *)ModWsk[i]->ptrex ;
	  param->LC0_MMEML	 = (ModWsk[i]->ExSize)/2 ;
	  param->LC0_MBASE2 = 0;
	 }
	else
	 param->LC0_STATUS = LC0_NO_MODULE ;
  }
 else
  param->LC0_STATUS = LC0_NO_MODULE ;

}

////////////////////////////////////////////////////////////////////////////
// GET_INFO
// Funkcja LC0_GetInfo :
//  Uzyskanie inormacji o parametrach konkretnego toru danego moduu
//  LC-011-0812 .
// Parametry wejciowe :
//  param : daleki wskanik do struktury 'lc0_info' z parametrami wywoania
//  i ststusu ;
////////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_GetInfo(lc0_info FAR *param)
{
 int i ;
 param->LC0_ERR_STAT = LC0_E_OK ;//
 param->LC0_STATUS = LC0_OK ;
 if((param->LC0_GMODULE >=LC0_MODA)&&(param->LC0_GMODULE <=LC0_MODC))
  {
	if(ModWsk[(param->LC0_GMODULE)-1]->IsLoaded == TRUE)
	 {
	  i = param->LC0_GMODULE -1 ;
	  switch(param->LC0_GTYPE)
		{
		 case LC0_DINPUT	:if(param->LC0_GNUM == DIN_NUM)
								  {
									 param->LC0_GCHAN = DBITS ;
								  }
								 else
								  param->LC0_STATUS = LC0_NONEX_DEV ;
								 break ;
		 case LC0_DOUTPUT	:if(param->LC0_GNUM == DOUT_NUM)
								  {
									 param->LC0_GCHAN = DBITS ;
								  }
								 else
								  param->LC0_STATUS = LC0_NONEX_DEV ;
								 break ;
		 case LC0_AINPUT	:if(param->LC0_GNUM == AC_NUM)
								  {
									 param->LC0_GCHAN = AC_CHANNELS ;
									 param->LC0_GRES = AC_BITS ;
									 param->LC0_GTIME = ModWsk[i]->Tconv ;
									 param->LC0_GMINV = ModWsk[i]->AC_V1 ;
									 param->LC0_GMAXV = ModWsk[i]->AC_V2 ;
									 param->LC0_GDMA  = ModWsk[i]->AC_DMA ;
									 int j ;
									 for(j=0;j<32;j++)
									  param->LC0_GMINP[j]=ModWsk[i]->STable[j];
								  }
								 else
								  param->LC0_STATUS = LC0_NONEX_DEV ;
								 break ;
		 case LC0_AOUTPUT	:if(ModWsk[i]->CA_channels ==0)
								  {
									param->LC0_STATUS = LC0_BAD_DEV_TYP ;
									break;
								  }
								 if(param->LC0_GNUM >2 || param->LC0_GNUM == 0)
								  {
									param->LC0_STATUS = LC0_NONEX_DEV ;
									break;
								  }
								 if((param->LC0_GNUM ==2) && (ModWsk[i]->CA_channels ==1))
								  {
									param->LC0_STATUS = LC0_NONEX_DEV ;
									break;
								  }
								 param->LC0_GCHAN = 1 ;
								 param->LC0_GRES = CA_BITS ;
								 param->LC0_GTIME = CA_CONV ;
								 param->LC0_GDMA  = 0xff ;
								 if(param->LC0_GNUM == 1)
									{
									 param->LC0_GMINV = ModWsk[i]->CA1_V1;
									 param->LC0_GMAXV	= ModWsk[i]->CA1_V2 ;
									}
								  else
									{
									 param->LC0_GMINV = ModWsk[i]->CA2_V1;
									 param->LC0_GMAXV	= ModWsk[i]->CA2_V2 ;
									}
								 break ;
		 case LC0_CTC		:if((param->LC0_GNUM == 0) || (param->LC0_GNUM > CTC_NUM) )
								  param->LC0_STATUS = LC0_NONEX_DEV ;

								 break ;
		 default				:param->LC0_STATUS = LC0_NONEX_DEV ;
								 break;
		}
	 }
	else
	 param->LC0_STATUS = LC0_NO_MODULE ;
  }
 else
  param->LC0_STATUS = LC0_NO_MODULE ;
}

