/************************************************************************/
/* Projekt : "lc1108a.dll" - biblioteka DLL WINDOWS dla karty LC-011-0812 */
/* Autor : Krzysztof Mroczek 	1996                                       */
/************************************************************************/
#define  STRICT
#include <windows.h>
#pragma hdrstop
#define _EXPORT _export

#include  "lc1108a.h"
#include  "1108int.h"

extern CModuleData *ModWsk[3]	;
//////////////////////////////////////////////////////////////////////////
// MEMORY_USE
// Funkcja LC0_MemoryUse :
//  Zarzdzanie buforem pamici rozszerzonej moduu : zmiana rozmiaru bufora +
//  optymalizacja jego . Dziaa wtedy , gdy bufor zosta zadeklarowany
//  przez uytkownika .
// Parametry wejciowe :
//  'param' : daleki wskanik do struktury 'lc0_memory' z parametrami
//   			 wywoania i statusu .
//////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_MemoryUse(lc0_memory FAR *param)
{
  int huge *nptr;
  char errcode ;
  unsigned char modnum;
  HGLOBAL h;
  BOOL OKMod = FALSE , nonlock=FALSE ,er=FALSE;

  param->LC0_STATUS = LC0_OK;
  param->LC0_ERR_STAT = LC0_E_OK;

  if((param->LC0_MMODULE >= LC0_MODA) && (param->LC0_MMODULE <= LC0_MODC))
	 {
		errcode = ModWsk[(param->LC0_MMODULE) -1 ]->CheckApp();
		if(errcode!=LC0_OK)
		 {
		  param->LC0_STATUS = errcode;
		 }
	 }
	else
	 {
		param->LC0_STATUS = LC0_NO_MODULE ;
	 }

  if(param->LC0_STATUS !=LC0_OK)
	return;

  if(param->LC0_MMODE!=1)
	{
	  param->LC0_STATUS = LC0_BAD_MODE;
	  return;
	}

	modnum= param->LC0_MMODULE -1;
	OKMod = TRUE ;

  if(ModWsk[modnum]->ExMem ==0 || ModWsk[modnum]->ptrex == NULL)
	{
	  param->LC0_STATUS = LC0_NO_EXTMEM;
	  return;
	}

  if(param->LC0_MNUM!=0)
	{
	 ::GlobalUnlock(ModWsk[modnum]->hexmem);
	 if(2* (param->LC0_MNUM) > ModWsk[modnum]->ExSize)
	  {
		::GlobalFree(ModWsk[modnum]->hexmem);
		h = ::GlobalAlloc(GMEM_MOVEABLE|GMEM_NODISCARD|GMEM_NOCOMPACT|
		GMEM_LOWER,2*(param->LC0_MNUM));
		if(h!=NULL)
		 {
		  nptr = (int huge *)(::GlobalLock(h));
		  if(nptr==NULL)
			er=TRUE;
		 }
		else
		 {
		  er=TRUE;
		 }

		if(!er)
		 {
		  ModWsk[modnum]->hexmem = h ;
		  ModWsk[modnum]->ptrex = nptr ;
		  ModWsk[modnum]->ExSize = 2*(param->LC0_MNUM);
		  nonlock = TRUE;
		 }
		else
		 {

			ModWsk[modnum]->hexmem =::GlobalAlloc(GMEM_MOVEABLE|GMEM_NODISCARD|GMEM_NOCOMPACT|
			GMEM_LOWER,2*(ModWsk[modnum]->ExSize));
			if(ModWsk[modnum]->hexmem == NULL)
			 {
			  ModWsk[modnum]->hexmem = NULL ;
			  ModWsk[modnum]->ExSize = 0 ;
			  param->LC0_STATUS = LC0_BAD_EXTMEM ;
			  ModWsk[modnum]->ptrex = NULL ;
			  nonlock = TRUE ;
			 }
			param->LC0_STATUS = LC0_OTHER_LEN ;
		 }
	  }
	 else
	  {
		h=::GlobalReAlloc(ModWsk[modnum]->hexmem,2*(param->LC0_MNUM),GMEM_NODISCARD)  ;
		if(h!=NULL)
		 {
		  ModWsk[modnum]->hexmem = h ;
		  ModWsk[modnum]->ExSize = 2*(param->LC0_MNUM);
		 }
		else
		 {
		  param->LC0_STATUS = LC0_BAD_EXTMEM ;
		 }
	  }

	 if(!nonlock)
	  {
		ModWsk[modnum]->ptrex = (int huge *)(::GlobalLock(ModWsk[modnum]->hexmem));
		if(ModWsk[modnum]->ptrex==NULL)
		{
		 ModWsk[modnum]->hexmem = NULL ;
		 ModWsk[modnum]->ExSize = 0 ;
		 param->LC0_STATUS = LC0_BAD_EXTMEM ;
		}
	  }
	}
  else		//bd
	{
	  param->LC0_STATUS = LC0_BAD_EXTMEM ;
	}

  if(OKMod)
	{
	 param->LC0_MRNUM = (ModWsk[modnum]->ExSize)/2;
	 param->LC0_MRMEMA =(int far *)(ModWsk[modnum]->ptrex);
	}
  else
	{
	 param->LC0_MRNUM = 0;
	 param->LC0_MRMEMA = NULL;
	}
}

