/************************************************************************/
/* Projekt : "lc1108a.dll" - biblioteka DLL WINDOWS dla karty LC-011-0812 */
/* Autor : Krzysztof Mroczek 	1996                                      */
/************************************************************************/
#define  STRICT
#include <windows.h>
#pragma hdrstop
#define _EXPORT _export
#include  "lc1108a.h"
#include  "1108int.h"

 extern CModuleData *ModWsk[3]	;

/////////////////////////////////////////////////////////////////////////
// MODULE_INIT
// Funkcja : LC0_ModuleInit
//  Inicjacja i zerowanie moduw . W przypadku moduw niezainicjowanych
//  nastpuje wyczne przydzielenie moduu wywolujacegu zadaniu oraz
//  zerowanie sprztowe . Dla moduw ju zainicjowanych wykonywane
//  jest tylko zerowanie sprztu .
// Parametry wejciowe :
//  param : daleki wskanik do rekordu 'lc0_init'  z parametrami
//  wywolania i statusu .
/////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_ModuleInit(lc0_init FAR *param)
{

 unsigned char f_ok=0 , f_no_module = 0 , f_is_init=0;
 unsigned char module ;
 unsigned char mask[] = {0x01,0x02,0x04,0x08};
 int i ;
 HTASK hApp;
 char errcode ;

 param->LC0_ERR_STAT = LC0_E_OK ;
 for(i=0;i<3;i++)
  {
	 module = ((param->LC0_IMODULE) & mask[i]);
	 if(module != 0)
	  {
		 if(ModWsk[i]->IsLoaded)
		  {
			 if(ModWsk[i]->IsInit)
			  {
				hApp = ::GetCurrentTask();
				if(hApp == ModWsk[i]->AppTask)
				 {
				  f_ok++;
				  ModWsk[i]->ClearCard();
				 }
				else
				 f_is_init++;
			  }
			 else
			  {
				ModWsk[i]->ClearCard();
				errcode = ModWsk[i]->AllocExtMem();
				if(errcode!=LC0_OK) //bd alokacji
				 {
				  param->LC0_STATUS = errcode ;
				  return ;
				  }
				f_ok++;
				ModWsk[i]->IsInit = TRUE ;
				ModWsk[i]->AppTask = ::GetCurrentTask();
			  }
		  }
		 else
		  f_no_module ++ ;
	  }
  }

 // ustalenie statusu
 if(f_ok!=0)
  {
	 if(f_no_module==0)
	  param->LC0_STATUS = LC0_OK ;
	 else
	  param->LC0_STATUS = LC0_NON_EX_MOD ;
  }
 else
  {
	if(f_is_init!=0)
	 param->LC0_STATUS = LC0_IS_INIT ;
	else
	 {
		if(f_no_module!=0)
		 param->LC0_STATUS = LC0_NO_MODULE ;
		else
		 param->LC0_STATUS = LC0_OK ;
	 }
  }
}

