/************************************************************************/
/* Projekt : "lc1108a.dll" - biblioteka DLL WINDOWS dla karty LC-011-0812 */
/* Autor : Krzysztof Mroczek 1996                                        */
/************************************************************************/
#define  STRICT
#include <windows.h>
#pragma hdrstop
#define _EXPORT _export
#include  "lc1108a.h"
#include  "1108int.h"

 extern CModuleData *ModWsk[3]	;

//funkcje nieaktywne
//////////////////////////////////////////////////////////////////////
// SET_CLOCK
//////////////////////////////////////////////////////////////////////
extern "C" void FAR PASCAL _export LC0_SetClock(lc0_clock FAR *param)
 {
	param->LC0_STATUS = LC0_NOT_SUPPORTED ;//funkcja nie realizowana dla LC011
	param->LC0_ERR_STAT = LC0_E_OK		  ;//brak dodatkowych informacji
 }

////////////////////////////////////////////////////////////////////////
// SET_VOLTAGE_RANGE
////////////////////////////////////////////////////////////////////////
extern "C" void FAR PASCAL _export LC0_SetVoltage(lc0_volt FAR *param)
 {
	char errcode ;
	param->LC0_ERR_STAT = LC0_E_OK		  ;//brak dodatkowych informacji
	if((param->LC0_VMODULE >= LC0_MODA) && (param->LC0_VMODULE <= LC0_MODC))
	 {
		errcode = ModWsk[(param->LC0_VMODULE) -1 ]->CheckApp();

	 }
	else
	 {
		param->LC0_STATUS = LC0_NO_MODULE ;
		return ;
	 }
	if(errcode == LC0_OK)
	 param->LC0_STATUS = LC0_NOT_SUPPORTED ;//funkcja nie realizowana
	else
	 param->LC0_STATUS = errcode ;
 }

/////////////////////////////////////////////////////////////////////////
// SET_TIME
/////////////////////////////////////////////////////////////////////////
extern "C"  void FAR PASCAL _export LC0_SetTime(lc0_time FAR *param)
 {
	param->LC0_ERR_STAT = LC0_E_OK		  ;//brak dodatkowych informacji
	param->LC0_STATUS = LC0_NOT_SUPPORTED ;//funkcja nie realizowana

 }

//////////////////////////////////////////////////////////////////////////
// WAIT
//////////////////////////////////////////////////////////////////////////
extern "C" void FAR PASCAL _export LC0_Wait(lc0_wait FAR *param)
 {
	char errcode ;
	param->LC0_ERR_STAT = LC0_E_OK		  ;//brak dodatkowych informacji
	if((param->LC0_WMODULE >= LC0_MODA) && (param->LC0_WMODULE <= LC0_MODC))
	 {
		errcode = ModWsk[(param->LC0_WMODULE) -1 ]->CheckApp();

	 }
	else
	 {
		param->LC0_STATUS = LC0_NO_MODULE ;
		return ;
	 }
	if(errcode == LC0_OK)
	 param->LC0_STATUS = LC0_NOT_FULLY_SUP ;
	else
	 param->LC0_STATUS = errcode ;
 }

////////////////////////////////////////////////////////////////////////////
// INTERRUPT_SERVICE
////////////////////////////////////////////////////////////////////////////
extern "C" void FAR PASCAL _export LC0_Interrupt(lc0_interrupt FAR *param)
 {
	char errcode ;
	param->LC0_ERR_STAT = LC0_E_OK		  ;//brak dodatkowych informacji
	if((param->LC0_SMODULE >= LC0_MODA) && (param->LC0_SMODULE <= LC0_MODC))
	 {
		errcode = ModWsk[(param->LC0_SMODULE) -1 ]->CheckApp();
	
	 }
	else
	 {
		param->LC0_STATUS = LC0_NO_MODULE ;
		return ;
	 }
	if(errcode == LC0_OK)
		param->LC0_STATUS = LC0_NOT_FULLY_SUP ;//funkcja w opracowaniu
	else
		param->LC0_STATUS = errcode ;

 }
