(************************************************************************** *)
(* "ambex-lc.pas"                                                           *)
(* Definicje struktur danych , funkcji i staych driver'w Windows do kart  *)
(* kontrolno pomiarowych f-y AMBEX .				            *)
(* Przeznaczenie : jezyk Pascal    					   *)
(*                                                                         *)
(* *********************************************************************** *)

(**************** REKORDY OPISOW ZLECEN FUNKCJI DRIVER'A *******************)

(************** struktury opisujace warunki startu i stopu *****************)
type
lc0_cond_level =		(* warunek "poziom sygnalu cyfrowego"      *)
	record
	    mod_nr:	byte;		(* numer modulu                    *)
	    port_nr:	byte;		(* numer portu                     *)
	    inp_nr:	byte;		(* numer wejscia                   *)
	    value:	byte;		(* oczekiwana wartosc              *)
	end;

(*-------------------------------------------------------------------------*)
type
lc0_cond_slope =		(* warunek "zbocze sygnalu cyfrowego"      *)
	record
	    mod_nr:	byte;		(* numer modulu                    *)
	    port_nr:	byte;		(* numer portu                     *)
	    inp_nr:	byte;		(* numer wejscia                   *)
	    slope:	byte;		(* rodzaj zbocza                   *)
	end;

const
				(* kody rodzajow zbocza:	           *)
LC0_SLOPE_COND_UP	= 1;	(* narastajace                             *)
LC0_SLOPE_COND_DOWN	= 0;	(* opadajace                               *)

(*-------------------------------------------------------------------------*)
type
lc0_cond_dig =		(* warunek "kominacja sygnalow cyfrowych"          *)
	record
	    mod_nr:	byte;		(* numer modulu                    *)
	    port_nr:	byte;		(* numer portu                     *)
	    mask:	byte;		(* maska aktywnych wejsc           *)
	    pattern:	byte;		(* testowany wzorzec               *)
	end;


(*-------------------------------------------------------------------------*)
type
lc0_cond_date =		(* warunek "data"                                  *)
	record
	    second:	byte;		(* sekunda                         *)
	    minute:	byte;		(* minuta                          *)
	    hour:	byte;		(* godzina                         *)
	    day:	byte;		(* dzien miesiaca                  *)
	end;

(*-------------------------------------------------------------------------*)
type
lc0_cond_analog =		(* warunek "sygnal analogowy"              *)
	record
	    mod_nr:	byte;		(* numer modulu                    *)
	    converter:	byte;		(* nr przetwornika                 *)
		 channel:	byte;		(* numer kanalu (b1..b6),          *)
						(*   kierunek przekroczenia (b8)   *)
						(*   zbocze lub poziom (b7)   *)
		 level:	integer;	(* prog wyzwalania                 *)
	end;

const
			(* kody kierunku przekroczenia progu:	           *)
LC0_ANALOG_COND_UP	= $80;	(* w kierunku wiekszych wartosci           *)
LC0_ANALOG_COND_DOWN	= 0;	(* w kierunku mniejszych wartosci          *)
LC0_ANALOG_COND_MASK	= $80;	(* maska kodu kierunku                     *)
			(* kody typu wyzwolenia	           *)
LC0_ANALOG_TYPE_SLOPE	= 0;	(* zbocze           *)
LC0_ANALOG_TYPE_LEVEL	= $40;(* poziom           *)
LC0_ANALOG_TYPE_MASK	= $40;	(* maska typu wyzwolenia                    *)


(*-------------------------------------------------------------------------*)
type
lc0_start =			(* =========== warunki startu =============*)
	record
	    case integer of
		1: (level:	lc0_cond_level);	(* LC0_SLEVEL  *)
		2: (slope:	lc0_cond_slope);	(* LC0_SSLOPE  *)
		3: (dig_eq:	lc0_cond_dig);		(* LC0_SDIG_EQ *)
		4: (dig_ne:	lc0_cond_dig);		(* LC0_SDIG_NE *)
		5: (time:	longint);		(* LC0_STIME   *)
		6: (date:	lc0_cond_date);		(* LC0_SDATE   *)
		7: (analog:	lc0_cond_analog)	(* LC0_SANALOG *)
	end;

type
lc0_stop =			(* =========== warunki stopu ==============*)
	record
	    case integer of
		1: (samples:	longint);		(* LC0_ZSAMPLES *)
		2: (level:	lc0_cond_level);	(* LC0_ZLEVEL   *)
		3: (slope:	lc0_cond_slope);	(* LC0_ZSLOPE   *)
		4: (dig_eq:	lc0_cond_dig);		(* LC0_ZDIG_EQ  *)
		5: (dig_ne:	lc0_cond_dig);		(* LC0_ZDIG_NE  *)
		6: (time:	longint);		(* LC0_ZTIME    *)
		7: (date:	lc0_cond_date);		(* LC0_ZDATE    *)
		8: (analog:	lc0_cond_analog)	(* LC0_ZANALOG  *)
	end;

(*=========================================================================*)

(* Rekord opisu zlecenia funkcji  MODULE_INIT =============================*)
type
lc0_init =
	record
	    LC0_CODE:		byte;	(* kod funkcji (0)                 *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_IMODULE:	byte;	(* mapa modulow                    *)
	end;

(* Rekord opisu zlecenia funkcji  GET_TOTAL_CONFIGURATION =================*)
type
lc0_total =
	record
	    LC0_CODE:		byte;	(* kod funkcji (1)                 *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_TONF:		byte;	(* konfiguracja modulow            *)
	    LC0_TIAD:		byte;	(* przetworniki a/c                *)
	    LC0_TIDA:		byte;	(* przetworniki c/a                *)
	    LC0_TCTC:		byte;	(* kanaly CTC                      *)
	    LC0_TIDI:		byte;	(* porty wejsc cyfrowych           *)
	    LC0_TIDO:		byte;	(* porty wyjsc cyfrowych           *)

	end;				   

(* Rekord opisu zlecenia funkcji   GET_MODULE_CONFIGURATION ===============*)
type
lc0_module =
	record
	    LC0_CODE:		byte;	(* kod funkcji (2)                 *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_MMODULE:	byte;	(* numer modulu                    *)
	    LC0_MBASE1:		word;	(* adres bazowy pakietu 1          *)
	    LC0_MBASE2:		word;	(* adres bazowy pakietu 2          *)
	    LC0_MIAD:		byte;	(* przetworniki a/c                *)
	    LC0_MIDA:		byte;	(* przetworniki c/a                *)
	    LC0_MCTC:		byte;	(* kanaly CTC                      *)
	    LC0_MIDI:		byte;	(* porty wejsc cyfrowych           *)
	    LC0_MIDO:		byte;	(* porty wyjsc cyfrowych           *)
	    LC0_MCLOCK:		word;	(* czestotliwosc zegara w kHz      *)
	    LC0_MINT:		byte;	(* numer przerwania (programowy)   *)
            LC0_MMEMA:		pointer; (* bufor w pamici rozszerzonej   *)
	    LC0_MMEML:          longint; (* dugo bufora w pamici rozszerzonej *)
	end;

(* Rekord opisu zlecenia funkcji  GET_INFO ================================*)
type
lc0_info =
	record
	    LC0_CODE:		byte;	(* kod funkcji (3)                 *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_GTYPE:		byte;	(* rodzaj urzadzenia               *)
	    LC0_GMODULE:	byte;	(* numer modulu                    *)
	    LC0_GNUM:		byte;	(* numer przetwornika/portu/       *)
					(*                      ukladu CTC *)
	    LC0_GCHAN:		byte;	(* liczba kanalow                  *)
	    LC0_GRES:		byte;	(* liczba bitow przetwornika       *)
	    LC0_GTIME:		word;	(* czas konwersji przetwornika w ns*)
	    LC0_GMINV:		shortint;	(* dolna granica zakresu   *)
	    					(*   napiec w dziesiatych  *)
						(*   czesciach volta   *)
	    LC0_GMAXV:		shortint;	(* gorna granica zakresu   *)
	    					(*   napiec w dziesiatych  *)
						(*   czesciach volta   *)
	    LC0_GDMA:		byte;	(* numer kanalu DMA                *)
	    				(* minimalne okresy probkowania    *)
	    LC0_GMINP:		array [1..32] of word;
	end;

(* Rekord opisu zlecenia funkcji  SET_CLOCK ===============================*)
type
lc0_clock =
	record
	    LC0_CODE:		byte;	(* kod funkcji (4)                 *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_LCLOCK:		word;	(* czestotliowsc zegara w kHz      *)
	end;

(* Rekord opisu zlecenia funkcji  SET_VOLTAGE_RANGE =======================*)
type
lc0_volt =
	record
	    LC0_CODE:		byte;	(* kod funkcji (5)                 *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_VTYPE:		byte;	(* rodzaj urzadzenia               *)
	    LC0_VMODULE:	byte;	(* numer modulu                    *)
	    LC0_VNUM:		byte;	(* numer przetwornika              *)
	    LC0_VMINV:		shortint;	(* dolna granica zakresu   *)
	    					(*   napiec w dziesiatych  *)
						(*   czesciach volta   *)
	    LC0_VMAXV:		shortint;	(* gorna granica zakresu   *)
	    					(*   napiec w dziesiatych  *)
						(*   czesciach volta   *)
	    LC0_VAMPL:		shortint;	(* kod wzm. wzmac. instr.  *)	
	end;

(* Rekord opisu zlecenia funkcji  SET_TIME ================================*)
type
lc0_time =
	record
	    LC0_CODE:		byte;	(* kod funkcji (6)                 *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_ETIME:		word;	(* maksymalny czas obslugi         *)
					(*   przerwania, ktore moze pojawic*)
					(*   sie w trakcie wykonywania     *)
					(*   dlugiego pomiaru podawany w   *)
					(*   mikrosekundach                *)
	end;

(* Rekord opisu zlecenia funkcji  WAIT_FOR_END ============================*)
type
lc0_wait_f_e =
	record
	    LC0_CODE:		byte;	(* kod funkcji (7)                 *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_WTYPE:		byte;	(* rodzaj urzadzenia               *)
	    LC0_WMODULE:	byte;	(* numer modulu                    *)
	    LC0_WNUM:		byte;	(* numer przetwornika              *)
	    LC0_WMODE:		byte;	(* tryb pracy                      *)
	    LC0_WRMNUM:		longint;(* rzeczywista liczba probek       *)
	    LC0_WREMAR:		word;	(* rzeczywista dlugosc marginesu   *)
					(*   koncowego                     *)
	end;

const
				(* tryby pracy funkcji                     *)
LC0_W_WAIT	= 0;		(* oczekiwanie                             *)
LC0_W_TEST	= 1;		(* test konca                              *)
LC0_W_FINISHED	= 2;		(* powiadomienie o koncu                   *)

(* Rekord opisu zlecenia funkcji  BREAK ===================================*)
type
lc0_sbreak =
	record
	    LC0_CODE:		byte;	(* kod funkcji (8)                 *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_BMODE:		byte;	(* tryb pracy                      *)
	    LC0_BPROC:		pointer;(* adres procedury obslugi         *)
					(*   przerwania CTRL-BREAK         *)
	end;

const
				(* bity trybu pracy funkcji                *)
LC0_BREAK_EXEC		= 0;	(* przerwanie                              *)
LC0_BREAK_INST		= 1;	(* instalacja Ctrl_Break...                *)
LC0_BREAK_PREV		= 4;	(* ...z wywolaniem poprzedniej obslugi     *)
LC0_BREAK_UNINST	= 2;	(* wyinstalowanie wszystkiego              *)

(* Rekord opisu zlecenia funkcji  DIGITAL_INPUT ===========================*)
type
lc0_digital_in =
	record
	    LC0_CODE:		byte;	(* kod funkcji (9)                 *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_DMODULE:	byte;	(* numer modulu                    *)
	    LC0_DNUM:		byte;	(* numer portu                     *)
	    LC0_DSTST:		byte;	(* typ warunku startu              *)
	    LC0_DVAL:		byte;	(* odczytana wartosc               *)
	    LC0_DSTART:		lc0_start;	(* parametry warunku startu*)
	end;

(* Rekord opisu zlecenia funkcji  DIGITAL_OUTPUT ==========================*)
type
lc0_digital_out =
	record
	    LC0_CODE:		byte;	(* kod funkcji (10)                *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_OMODULE:	byte;	(* numer modulu                    *)
	    LC0_ONUM:		byte;	(* numer portu                     *)
	    LC0_OSTST:		byte;	(* typ warunku startu              *)
	    LC0_OVAL:		byte;	(* wartosc do wyslania             *)
	    LC0_OSTART:		lc0_start;	(* parametry warunku startu*)
	end;

(* Rekord opisu zlecenia funkcji  CTC_WRITE ===============================*)
type
lc0_ctc_write =
	record
	    LC0_CODE:		byte;	(* kod funkcji (11)                *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_CMODULE:	byte;	(* numer modulu                    *)
	    LC0_CMODE:		byte;	(* tryb pracy funkcji              *)
	    LC0_CFUN:		byte;	(* tryb pracy kanalu               *)
	    LC0_CVAL:		word;	(* nowa wartosc licznika           *)
	end;

const
				(* tryby pracy funkcji                     *)
LC0_SET_CTC_MODE	= 1;	(* zaprogramuj tryb pracy kanalu           *)
LC0_SET_COUNTER_VALUE	= 2;	(* zaladuj nowa wartosc licznika           *)
LC0_CTC_ENABLE          = 4;	(* zezwolenie CTC                          *)

(* Rekord opisu zlecenia funkcji  CTC_READ ================================*)
type
lc0_ctc_read =
	record
	    LC0_CODE:		byte;	(* kod funkcji (12)                *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_UMODULE:	byte;	(* numer modulu                    *)
	    LC0_UNUM:		byte;	(* numer kanalu                    *)
	    LC0_UVAL:		word;	(* odczytana wartosc licznika      *)
	end;

(* Rekord opisu zlecenia funkcji  DATA_TRANSMIT ===========================*)
type
lc0_transmit =
	record
	    LC0_CODE:		byte;	(* kod funkcji (13)                *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
            LC0_RMODULE:        byte;   (* numer modulu                    *)
	    LC0_RMODE:		byte;	(* tryb przesylania                *)
	    LC0_RADDR:		pointer;(* adres bufora w pam. podstawowej *)
	    LC0_RLEN:		longint;(* dlugosc bufora w pam. podst.    *)
	    LC0_RMEAS:		longint;(* numer pierwszej probki  *)
	    LC0_RNUM:		longint;(* liczba probek do przeslania     *)
	    LC0_RMEMA:		pointer;(* adres bufora w pamieci          *)
	    				(*   rozszerzonej (absolutny)      *)
	    LC0_RRNUM:		longint;(* rzeczywista liczba probek       *)

	end;

const
				(* tryby pracy funkcji                     *)
LC0_TO_EXT_DIR		= 1;	(* do pamieci rozszerzonej                 *)
LC0_FROM_EXT_DIR	= 0;	(* z pamieci modulu / rozszerzonej         *)

(* Rekord opisu zlecenia funkcji ANALOG_INPUT =============================*)
type
lc0_analog_in =
	record
	    LC0_CODE:		byte;	(* kod funkcji (14)                *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_AMODULE:	byte;	(* numer modulu                    *)
	    LC0_ANUM:		byte;	(* numer przetwornika              *)
	    LC0_AMODE:		word;	(* tryb pracy funkcji              *)
	    LC0_ASTST:		byte;	(* typy warunkow startu i stopu    *)
	    LC0_APER:		longint;(* okres probkowania               *)
	    LC0_APER2:		word;	(* krotnosc okresu probkowania     *)
	    LC0_ACHAN:		byte;	(* liczba kanalow podstawowych     *)
					(*   (b8 okresla czy praca         *)
					(*   wielokanalowa (0) czy         *)
					(*   jednokanalowa (1))            *)
	    LC0_ACHAN2:		byte;	(* liczba kanalow dodatkowych      *)
	    LC0_AADDR:		pointer;(* adres bufora w pam. podstawowej *)
	    LC0_ALEN:		longint;(* dlugosc bufora                  *)
	    LC0_AMEMA:		pointer;(* adres bufora w pamieci          *)
	    				(*   rozszerzonej                  *)
	    LC0_ABMAR:		word;	(* dlugosc marginesu poczatkowego  *)
	    LC0_AEMAR:		word;	(* dlugosc marginesu koncowego     *)
	    LC0_AHAND:		word;	(* numer handler'a zbioru          *)
	    LC0_ASTART:		lc0_start;	(* parametry warunku startu*)
	    LC0_ASTOP:		lc0_stop;	(* parametry warunku stopu *)
	    LC0_ARDIV1:		word;	(* pierwszy podzielnik zegara      *)
	    LC0_ARDIV2:		word;	(* drugi podzielnik zegara         *)
	    LC0_ARMNUM:		longint;(* rzeczywista liczba probek       *)
	    LC0_ARBMAR:		word;	(* rzeczywista dlugosc marg. pocz. *)
	    LC0_AREMAR:		word;	(* rzeczywista dlugosc marg. konc. *)
	    LC0_ARLEN:		longint;(* rzeczywista liczba przepisanych *)
					(*   probek                        *)
	    LC0_ARBUF:		word;	(* dla pracy z buforem cyklicznym: *)
					(*   numer probki okreslajacej     *)
					(*   poczatek bufora po zakonczeniu*)
					(*   pomiaru                       *)
	end;

(* Rekord opisu zlecenia funkcji  ANALOG_OUTPUT ===========================*)
type
lc0_memory =
	record
	    case integer of
		1: (base_memory:	pointer);
		2: (extended_memory:	pointer)
	end;

type
lc0_analog_out =
	record
	    LC0_CODE:		byte;	(* kod funkcji (15)                *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_NMODULE:	byte;	(* numer modulu                    *)
	    LC0_NNUM:		byte;	(* numer przetwornika              *)
	    LC0_NMODE:		word;	(* tryb pracy funkcji              *)
	    LC0_NSTST:		byte;	(* typy warunkow startu i stopu    *)
	    LC0_NCHAN:		byte;	(* liczba kanalow (b8 okresla      *)
					(*   czy praca wielokanalowa (0)   *)
					(*   czy jednokanalowa (1))        *)
	    LC0_NPER:		longint;(* okres probkowania               *)
	    LC0_NADDR: 		lc0_memory;	(* adres bufora            *)
	    				(*   (segment:offset dla           *)
					(*   pamieci podstawowej, absolutny*)
					(*   dla pamieci rozszerzonej)     *)
	    LC0_NLEN:		longint;(* dlugosc bufora w pam. podst.    *)
	    LC0_NHAND:		word;	(* numer handler'a zbioru          *)
	    LC0_NSTART:		lc0_start;	(* parametry warunku startu*)
	    LC0_NSTOP:		lc0_stop;	(* parametry warunku stopu *)
	    LC0_NRMNUM:		longint;(* rzeczywista liczba wyslanych    *)
					(*   probek                        *)
	end;

(* Rekord opisu zlecenia funkcji  LEAVE_DRIVER ============================*)
type
lc0_sleave =
	record
	    LC0_CODE:		byte;	(* kod funkcji                 *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	end;

(* Rekord opisu zlecenia funkcji  INTERRUPT_SERVICE =======================*)
type
lc0_interrupt_s =
	record
	    LC0_CODE:		byte;	(* kod funkcji (17)                *)
	    LC0_STATUS:		shortint;	(* kod odpowiedzi driver'a *)
	    LC0_ERR_STAT:	shortint;	(* dodatkowe informacje o  *)
	    					(* bledach                 *)
	    LC0_SMODULE:	byte;	(* numer modulu                    *)
	    LC0_SPROC:		pointer;(* adres procedury obslugi         *)
	    LC0_SSTAT:		pointer;(* adres slowa komunikacyjnego     *)
	end;
 (* Rekord opisu zlecenia funkcji MEMORY_USE *)
 type
 lc0_memory_u =
         record
            LC0_CODE:           byte;   (*kod funkcji *)
            LC0_STATUS:         shortint;     (* kod odpowiedzi driver'a *)
            LC0_ERR_STAT:       shortint;     (* dodatkowe informacje o bledach *)
            LC0_MMODULE:        byte;   (* nr modulu *)
            LC0_MMODE:          byte;   (* obecnie ==1 *)
            LC0_MNUM:           longint; (* zadana liczba probek w nowym buforze *)
            LC0_MRNUM:          longint; (* rzeczywista wielkosc bufora w probkach *)
            LC0_MRMEMA:         pointer; (* adres nowego bufora *)
         end;

 (* Rekord opisu funkcji CONFIG *)

 type
 lc0_sconfig =
         record
            LC0_CODE:           byte;   (*kod funkcji *)
            LC0_STATUS:         shortint;     (* kod odpowiedzi driver'a *)
            LC0_ERR_STAT:       shortint;     (* dodatkowe informacje o bledach *)
            LC0_INI_FILE:       pointer;      (* wskaznik do lancucha znakowego bedocego*)
                                              (* sciezka do pliku AMBEX.INI *)
         end;

const
LC0_IS_START	= 1;		(* przerwanie wystapilo z powodu           *)
				(*   rozpoczecia pomiaru                   *)
LC0_IS_ONE	= 2;		(* przerwanie nastapilo z powodu zmierzenia*)
				(*   kolejnej serii pomiarowej             *)
LC0_IS_END_ADC	= 4;		(* przerwanie nastapilo z powodu           *)
				(*   zakonczenia przetwarzania a/c         *)
LC0_IS_END_DAC	= 8;		(* przerwanie nastapilo z powodu           *)
				(*   zakonczenia przetwarzania c/a         *)
LC0_IS_BROKEN	= 16;		(* zakonczono przetwarzanie z powodu       *)
				(* wykonania funkcji BREAK                 *)
LC0_IS_SAMPLE	= 32;		(* przerwanie wystapilo z powodu zmierzenia*)
				(*   kolejnej probki                       *)


(********************** pozostale stale ************************************)
const
(******************* kody funkcji driver'a *********************************)
MODULE_INIT 			=  16;
GET_TOTAL_CONFIGURATION 	=  17;
GET_MODULE_CONFIGURATION	=  18;
GET_INFO			=  19;
SET_CLOCK			=  20;
SET_VOLTAGE_RANGE		=  21;
SET_TIME			=  22;
WAIT_FOR_END			=  23;
BREAK				=  24;
DIGITAL_INPUT			=  25;
DIGITAL_OUTPUT			= 26;
CTC_WRITE			= 27;
CTC_READ			= 28;
DATA_TRANSMIT			= 29;
ANALOG_INPUT			= 30;
ANALOG_OUTPUT			= 31;
LEAVE_DRIVER			= 32;
INTERRUPT_SERVICE		= 33;
MEMORY_USE                      = 34;
CONFIG                          = 35;

(*************** numery przerwan obslugiwanych przez driver ****************)
LC010_16	= $99;		(* LC-010-1612                             *)
LC011_08	= $90;		(* LC-011-0812                             *)
LC011_16	= $91;		(* LC-011-1612                             *)
LC015_16	= $92;		(* LC-015-1612                             *)
LC020_08_0	= $93;		(* LC-020-0812 v.0                         *)
LC020_08_2	= $94;		(* LC-020-0812 v.1 i v.2                   *)
LC020_32	= $95;		(* LC-020-3212                             *)
LC030_16	= $96;		(* LC-030-1612                             *)
LC060_06	= $97;		(* LC-060-0612                             *)

(******************** kody odpowiedzi funkcji driver'a *********************)
LC0_OK	= 0;

(* ======= ostrzezenia ======== *)
LC0_NON_EX_MOD		= 1;	(* nie istniejacy(e) modul(y)              *)
LC0_OTHER_LEN		= 2;	(* przepisano mniejsza liczbe pomiarow     *)
LC0_PREMATURE_END	= 3;	(* przedwczesne zakonczenie z powodu       *)
				(*   przepelnienia bufora                  *)
LC0_IN_PROGRESS		= 4;	(* badana transmisja jeszcze trwa          *)
LC0_IS_INIT             = 5;    (* modul byl wczesniej zainicjowany        *)

(* ========== bledy =========== *)
LC0_UNKN_FUNC		=  -1;	(* nieznany kod funkcji                    *)
LC0_NO_MODULE		=  -2;	(* brak modulu(ow)                         *)
LC0_BAD_DEV_TYP		=  -3;	(* bledny typ urzadzenie                   *)
LC0_NONEX_DEV		=  -4;	(* nie istnieje urzadzenie o tym numerze   *)
LC0_BAD_FREQ		=  -5;	(* zla czestotliwosc zegara                *)
LC0_BAD_RANGE		=  -6;	(* zly zakres napiec                       *)
LC0_NO_OPER		=  -7;	(* zadna operacja nie jest wykonywana      *)
LC0_BAD_MARGIN		=  -8;	(* bledna dlugosc marginesu poczatkowego   *)
LC0_BAD_BUF_ADR		=  -9;	(* bledny adres bufora                     *)
LC0_BAD_BUF_LEN		= -10;	(* bledna dlugosc bufora                   *)
LC0_DEV_BUSY		= -11;	(* urzadzenie jest zajete                  *)
LC0_BAD_PER		= -12;	(* zly okres probkowania                   *)
LC0_BAD_CHAN_N		= -13;	(* zla liczba kanalow                      *)
LC0_BAD_CHAN		= -14;	(* numer nie istniejacego kanalu           *)
LC0_BROKEN		= -15;	(* przerwano funkcja BREAK                 *)
LC0_INTR_NOT_INST	= -16;	(* procedura obslugi przerwania nie jest   *)
				(*   zainstalowana                         *)
LC0_ILL_START_CODE	= -17;	(* nielegalny typ warunku startu           *)
LC0_ILL_STOP_CODE	= -18;	(* nielegalny typ warunku stopu            *)
LC0_BAD_PROC		= -19;	(* bledny adres procedury obslugi          *)
				(*   przerwania lub slowa komunikacyjnego  *)
LC0_TOO_LONG_MARG	= -20;	(* margines dluzszy od bufora              *)
LC0_ILL_START		= -21;	(* bledne parametry warunku startu         *)
LC0_ILL_STOP		= -22;	(* bledne parametry warunku stopu          *)
LC0_BAD_MNUM		= -23;	(* bledny numer pierwszej probki           *)
LC0_NOT_SUPPORTED	= -24;	(* dla danego modulu funkcja nie jest      *)
				(*   realizowana                           *)
LC0_BAD_CTC_MODE	= -25;	(* bledny tryb pracy CTC                   *)
LC0_NO_PARAMS		= -26;	(* nie podano parametrow przetwarzania     *)
LC0_OVERRUN		= -27;	(* zakonczono przetwarzanie z powodu bledu *)
				(*   OVERRUN                               *)
LC0_NO_DMA		= -28;	(* z danym urzadzeniem nie jest zwiazany   *)
				(*   zaden kanal DMA                       *)
LC0_NO_IRQ		= -29;	(* z danym modulem nie jest zwiazane zadne *)
				(*   przerwanie                            *)
LC0_NOT_FULLY_SUP	= -30;	(* zadany tryb wykonania funkcji nie jest  *)
				(*   realizowany dla danego typu modulu lub*)
				(*   funkcja w opracowaniu                 *)
LC0_NO_EXTMEM		= -31;	(* brak pamieci roszerzonej                *)
LC0_NO_SEC_FREQ		= -32;	(* modul nie moze wykonywac pomiarow z     *)
				(*   podwojna czestotliwoscia              *)
LC0_INTR_INST		= -33;	(* procedura obslugi przerwania juz        *)
				(*   zainstalowana                         *)
LC0_BAD_PER2		= -34;	(* bledna wielokrotnosc okresu probkowania *)
				(*   (0 lub 1)                             *)
LC0_BAD_MODE		= -35;	(* bledny tryb pracy                       *)
LC0_BAD_EXTMEM		= -36;	(* zly adres bufora w pamieci rozszerzonej *)
LC0_CTC_NOT_PROGRAMMED	= -37;	(* zapis licznika przy niezaprogramowanym  *)
				(*   trybie pracy                          *)
LC0_REJECTED		= -38;	(* za wiele rownoleglych wejsc do driver'a *)
LC0_BAD_CONFIG          = -39;  (* blad w pliku konfiguracyjnym *)
LC0_NOT_INIT            = -40;  (* modol nie zainicjowany *)
LC0_NO_DMA_TRANS        = -41;  (* brak mozliwosci buforowanych transferow DMA *)
LC0_BAD_RAM_SEK		   = -42;  (* bdna sekwencja pomiarowa *)

(************************** dodatkowe informacje o bledach *****************)
LC0_E_OK		= 0;	(* brak dodatkowych informacji             *)
LC0_E_NO_MODULE		= -1;	(* nie ma takiego modulu                   *)
LC0_E_NONEX_DEV		= -2;	(* nie istnieje urzadzenie o tym numerze   *)
LC0_E_BAD_CHAN		= -3;	(* numer nieistniejacego kanalu            *)
LC0_E_BAD_TIME		= -4;	(* zly odcinek czasu                       *)
LC0_E_BAD_DATE		= -5;	(* zla specyfikacja daty                   *)
LC0_E_BAD_THRE		= -6;	(* bledny prog wyzwalania analogowego      *)
LC0_E_BROKEN_WAIT	= -7;	(* funkcja przerwana w trakcie oczekiwania *)
				(*   na spelnienie warunku startu          *)
LC0_E_BROKEN_RUN	= -8;	(* funkcja przerwana w trakcie             *)
				(*   przetwarzania                         *)
LC0_E_BAD_LEN		= -9;	(* zadeklarowano za duzo probek do         *)
				(*   zmierzenia                            *)
LC0_E_MOD_UNABLE        = -10;  (* modul zajety lub nie zainicjowany *)

(************************** kody warunkow startu ***************************)
LC0_SIMMED	= 0;		(* natychmiastowy                          *)
LC0_SHARD	= 1;		(* od sygnalu sprzetowego                  *)
LC0_SLEVEL	= 2;		(* od poziomu sygnalu cyfrowego            *)
LC0_SSLOPE	= 3;		(* od zbocza sygnalu cyfrowego             *)
LC0_SDIG_EQ	= 4;		(* od kombinacji bitow - rowne             *)
LC0_SDIG_NE	= 5;		(* od kombinacji bitow - rozne             *)
LC0_STIME	= 6;		(* po uplynieciu okreslonego czasu         *)
LC0_SDATE	= 7;		(* o podanym czasie                        *)
LC0_SANALOG	= 8;		(* od sygnalu analogowego                  *)

(************************** kody warunkow stopu ****************************)
LC0_ZSAMPLES	= $00;		(* po zmierzeniu okreslonej liczby probek  *)
LC0_ZBREAK	= $10;		(* po wykonaniu funkcji BREAK              *)
LC0_ZLEVEL	= $20;		(* od poziomu sygnalu cyfrowego            *)
LC0_ZSLOPE	= $30;		(* od zbocza sygnalu cyfrowego             *)
LC0_ZDIG_EQ	= $40;		(* od kombinacji bitow - rowne             *)
LC0_ZDIG_NE	= $50;		(* od kombinacji bitow - rozne             *)
LC0_ZTIME	= $60;		(* po uplynieciu okreslonego czasu         *)
LC0_ZDATE	= $70;		(* o podanym czasie                        *)
LC0_ZANALOG	= $80;		(* od sygnalu analogowego                  *)

(*************************** kody numerow modulow **************************)
LC0_MODA	= 1;		(* modul A                                 *)
LC0_MODB	= 2;		(* modul B                                 *)
LC0_MODC	= 3;		(* modul C                                 *)
LC0_MODD	= 4;		(* modul D                                 *)

(************************** maski modulow w mapie **************************)
LC0_MODAMAP	= 1;		(* modul A                                 *)
LC0_MODBMAP	= 2;		(* modul B                                 *)
LC0_MODCMAP	= 4;		(* modul C                                 *)
LC0_MODDMAP	= 8;		(* modul D                                 *)

(************************* kody typow urzadzen *****************************)
LC0_DINPUT	= 1;		(* wejsciowy port cyfrowy                  *)
LC0_DOUTPUT	= 2;		(* wyjsciowy port cyfrowy                  *)
LC0_AINPUT	= 3;		(* przetwornik a/c                         *)
LC0_AOUTPUT	= 4;		(* przetwornik c/a                         *)
LC0_CTC		= 5;		(* kanal CTC                               *)

(*********** maski trybu pracy funkcji ANALOG_INPUT i ANALOG_OUTPUT ********)
LC0_MOD_START		=    1;	(* start przetwarzania                     *)
LC0_MOD_NEW_PAR		=    2;	(* nowe parametry                          *)
LC0_MOD_SYNCHR		=    4;	(* praca synchroniczna                     *)
LC0_MOD_ASYNCHR		=    0;	(* praca asynchroniczna                    *)
LC0_MOD_INTR		=    8;	(* praca bez przerwan                      *)
LC0_MOD_INTR_TYPE	=   16;	(* bit trybu przerwan                      *)
LC0_MOD_END_INTR	=    0;	(* przerwanie po koncu przetwarzania       *)
LC0_MOD_ONE_INTR	=   16;	(* przerwanie po kazdej probce             *)
LC0_MOD_BLOCK		=   32;	(* praca blokowa                           *)
LC0_MOD_SINGLE		=    0;	(* praca pojedyncza                        *)
LC0_MOD_CYCL		=   64;	(* bufor cykliczny                         *)
LC0_MOD_FILE_W		=  128;	(* zapis do pliku                          *)
LC0_MOD_FILE_R		=  128;	(* odczyt z pliku                          *)
LC0_MOD_MEM_W		=  256;	(* przepisanie do pamieci                  *)
LC0_MOD_EXT_CLK		=  512;	(* zegar zewnetrzny                        *)
LC0_MOD_EXT_MEM		= 1024;	(* pamiec rozszerzona                      *)
LC0_MOD_RAM_SEK         = 2048; (* sekwencja pomiarowa                     *)
LC0_MOD_PAGE            = 4096; (* sposob programowania stron DMA          *)

(************* wartosci fragmentow bajtu kontrolnego 8253/8254 *************)
CTC_NB		= 0;		(* kod naturalny binarny                   *)
CTC_BCD		= 1;		(* kod BCD                                 *)

CTC_MODE0	= 0;		(* tryb 0                                  *)
CTC_MODE1	= 2;		(* tryb 1                                  *)
CTC_MODE2	= 4;		(* tryb 2                                  *)
CTC_MODE3	= 6;		(* tryb 3                                  *)
CTC_MODE4	= 8;		(* tryb 4                                  *)
CTC_MODE5	= 10;		(* tryb 5                                  *)

CTC_LSB		= $10;		(* tylko mlodszy bajt                      *)
CTC_MSB		= $20;		(* tylko starszy bajt                      *)
CTC_BOTH	= $30;		(* mlodszy - starszy                       *)

CTC_COUNT0	= $00;		(* licznik 0                               *)
CTC_COUNT1	= $40;		(* licznik 1                               *)
CTC_COUNT2	= $80;		(* licznik 2                               *)

(* definicje typow do struktur danych *)
type
 Plc0_init =    ^lc0_init ;
 Plc0_total=    ^lc0_total;
 Plc0_module=   ^lc0_module;
 Plc0_info=     ^lc0_info;
 Plc0_clock=    ^lc0_clock;
 Plc0_volt=     ^lc0_volt;
 Plc0_time=     ^lc0_time;
 Plc0_wait=     ^lc0_wait_f_e;
 Plc0_interrupt=^lc0_interrupt_s;
 Plc0_digital_in= ^lc0_digital_in;
 Plc0_digital_out= ^lc0_digital_out;
 Plc0_ctc_write=   ^lc0_ctc_write;
 Plc0_ctc_read=    ^lc0_ctc_read;
 Plc0_leave=       ^lc0_sleave;
 Plc0_config=      ^lc0_sconfig;
 Plc0_break=       ^lc0_sbreak;
 Plc0_transmit=    ^lc0_transmit;
 Plc0_memoryuse=   ^lc0_memory_u;
 Plc0_analog_in=   ^lc0_analog_in;
 Plc0_analog_out=  ^lc0_analog_out;

 (****************************************************************************************************)
 (* Funkcje biblioteki                                                                                *)
 (****************************************************************************************************)
(*
  PROCEDURE LC0_ModuleInit(param : Plc0_init);
  PROCEDURE LC0_GetTotalConf(param : Plc0_total);
  PROCEDURE LC0_GetModule(param : Plc0_module);
  PROCEDURE LC0_GetInfo(param : Plc0_info);
  PROCEDURE LC0_SetClock(param : Plc0_clock);
  PROCEDURE LC0_SetVoltage(param : Plc0_volt);
  PROCEDURE LC0_SetTime(param : Plc0_time);
  PROCEDURE LC0_Wait(param : Plc0_wait);
  PROCEDURE LC0_Interrupt(param : Plc0_interrupt);
  PROCEDURE LC0_DigitalIn(param : Plc0_digital_in);
  PROCEDURE LC0_DigitalOut(param : Plc0_digital_out);
  PROCEDURE LC0_CTCWrite(param : Plc0_ctc_write);
  PROCEDURE LC0_CTCRead(param : Plc0_ctc_read);
  PROCEDURE LC0_Leave(param : Plc0_leave);
  PROCEDURE LC0_Config(param : Plc0_config);
  PROCEDURE LC0_Break(param : Plc0_break);
  PROCEDURE LC0_DataTransmit(param : Plc0_transmit);
  PROCEDURE LC0_MemoryUse(param : Plc0_memoryuse);
  PROCEDURE LC0_AnalogIn(param : Plc0_analog_in);
  PROCEDURE LC0_AnalogOut(param : Plc0_analog_out);
 *)