(* WSMP1108.PAS ****************************************************************
	Program przykadowy pokazujcy sposb wykorzystania drivera moduw
	serii LC   firmy AMBEX.
	Sposb doaczenia biblioteki DLL : statycznie poprzez .TPW	   *)
(****************************************************************************
  Program korzysta ze standardowych funkcji API Windows 3.1 .
  W katalogu zawierajacym standardowe naglowki PAS musz sie znajdowac pliki:
  AMBEX-LC.PAS  - plik nagwkowy drivera ,
  LC1108U.TPW   - modu biblioteki LC1108A.DLL ,
  WSMP1108.RES - plik zasobw	,

  Pliki :
  - AMBEX.INI  - plik konfiguracyjny moduw serii LC ,
  - LC1108A.DLL - driver (biblioteka DLL) do kart LC-011-0812 ,
  powinny znajdowa si w jednym z katalogw ze standardowej cieki przeszu-
  kiwa Windows (wedug kolejnoci przeszukiwania) :
  1. katalog systemowy WINDOWS ,
  2. katalog WINDOWS\SYSTEM ,
  3. biecy katalog aplikacji ,
  4. katalog znajdujcy si na ciece przeszukiwa PATH .

  Opcje kompilatora (Borland Pascal)
  - Force far calls : on ,
  - Word align data : off ,
  - smart callbacks : on ,
  - windows stack frame : on ,

  UWAGA:
  Pomiary z wykorzystaniem blokowych transferw DMA s moliwe wwczas,gdy
  WINDOWS jest uruchomione w trybie Enhanced i s dostpne dla komputerw
  wyposaonych w procesory "386" i wysze , dla tej wersji biblioteki .
  Maksymaln wielko bufora DMA naley okreli poprzez ustawienie parametru
  "DMABufferSize=xx" sekcji [386Enh] w pliku "SYSTEM.INI" (domylnie 16kB),
  gdzie "xx" : rozmiar bufora w kB .                                *)
(***************************************************************************)

program wsmp1108;
{$R Wsmp1108}
uses Win31,WinProcs, WinTypes,Strings,lc1108u;

{$i ambex-lc.pas}

type
    buftype = array[1..320] of integer;		(* bufor na probki         *)

var
    buf: buftype;			(* bufor na probki                 *)
    s_init:      lc0_init;
    s_total:     lc0_total;
    s_module:    lc0_module;
    s_info:      lc0_info;
    s_break:     lc0_sbreak;
    s_analog_in: lc0_analog_in;
    s_analog_out:lc0_analog_out;
    s_leave:     lc0_sleave;


    modulenum: integer;			(* numer badanego modulu           *)
    paintnum:  integer ;
    paintdet:  integer;
    enddet:    integer;
    tstart:    byte;
    vhWnd:     HWnd;
    sstat:     integer;
    koniec:    integer;
    HDLL :     THandle;
    fproc:     TFarProc;

const
    BUFLEN	= 320;				(* dlugosc bufora          *)
    SAMPLES	= 20;				(* liczba probek           *)
    CHANNELS	= 8;				(* liczba kanalow          *)
    MY_MESSAGE  = WM_USER +1 ;

(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*   Zamiana cyfry szesnastkowej na jej reprezentacje znakowa.             *)
(* Parametry:                                                              *)
(*   dig - cyfra do zamiany                                                *)
(* Wartosc:                                                                *)
(*   Reprezentacja znakowa cyfry.                                          *)
(***************************************************************************)
function hexdigit(dig: word) : char;
begin
    if dig < 10 then hexdigit := chr(ord('0') + dig)
    else             hexdigit := chr(ord('A') + dig - 10);
end;

(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*   Wydrukowanie liczby calkowitej w postaci szesnastkowej.               *)
(* Parametry:                                                              *)
(*   val - wartosc do wydrukowania                                         *)
(***************************************************************************)
function writehex(val: word) :String ;
var s : string[4] ;
begin
    s:=hexdigit((val and $F000) shr 12)+hexdigit((val and $F00) shr 8)+
    hexdigit((val and $F0) shr 4)+hexdigit(val and $F);
    writehex :=s;
end;

(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*   Inicjalizacja zmiennych.                                              *)
(***************************************************************************)
procedure initprogram;
begin
    s_init.LC0_CODE		:= MODULE_INIT;
    s_total.LC0_CODE		:= GET_TOTAL_CONFIGURATION;
    s_module.LC0_CODE		:= GET_MODULE_CONFIGURATION;
    s_info.LC0_CODE		:= GET_INFO;
    s_break.LC0_CODE		:= BREAK;
    s_analog_in.LC0_CODE	:= ANALOG_INPUT;
    s_leave.LC0_CODE		:= LEAVE_DRIVER;
    paintnum :=0;
    paintdet:=0;
    enddet:=0;
    koniec:=0;
end;
(****************************************************************************
 Funkcja quit()

 Przeznaczenie : Wykonanie funkcji LEAVE_DRIVER

*****************************************************************************)
PROCEDURE quit;
begin
  LC0_Leave(@s_leave);
end ;


(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*   Rozpoznanie konfiguracji badanego modulu.                             *)
(* Sposob:                                                                 *)
(*   Przez wykorzystanie funkcji driver'a GET_TOTAL_CONFIGURATION,         *)
(*   GET_MODULE_CONFIGURATION, GET_INFO.                                   *)
(* Uwagi:                                                                  *)
(*   Funkcja nadaje wartosc zmiennej modulenum (numer badanego modulu)     *)
(*   wypelnia struktury total, module, info i inicjalizuje zainstalowane   *)
(*    moduly.                                                              *)
(***************************************************************************)
procedure askdriver;
label	lab1;
begin
    LC0_GetTotalConf(@s_total); 		(* GET_TOTAL_CONFIGURATION *)

				(* inicjalizacja zainstalowanych modulow   *)
    s_init.LC0_IMODULE := s_total.LC0_TONF and $F;
    LC0_ModuleInit(@s_init); 				(* MODULE_INIT     *)

					(* sprawdzenie, ktory modul jest   *)
					(* zainstalowany: A, B, C czy D    *)
    for modulenum := 1 to 4 do
	if ((s_total.LC0_TONF and (1 shl (modulenum - 1))) <> 0) then
	    goto lab1;

lab1:
					(* spytanie o konfiguracje modulu  *)
    s_module.LC0_MMODULE := modulenum;

    LC0_GetModule(@s_module);			(* GET_MODULE_CONFIGURATION*)

					(* spytanie o konfiguracje toru a/c*)
    s_info.LC0_GMODULE := modulenum;
    s_info.LC0_GTYPE   := LC0_AINPUT;
    s_info.LC0_GNUM    := 1;
    LC0_GetInfo(@s_info); 				(* GET_INFO        *)
end;

(*****************************************************************************)
(* GoToLine(*RECT) 0 przejcie do nastpnej linii przy wywietlaniu tekstu   *)
(*****************************************************************************)
procedure GoToLine(var rect : TRECT ; dc :HDC) ;
var
  tm :TTEXTMETRIC ;
begin
 GetTextMetrics(dc,tm);
 rect.top := rect.top + tm.tmHeight + tm.tmExternalLeading ;
 rect.bottom := rect.bottom + tm.tmHeight + tm.tmExternalLeading ;
end ;

(****************************************************************************)
(*Funkcja : drawscreen                                                      *)
(* Przeznaczenie : Wybranie odpowiedniej sekcji informacji do wywietlenia  *)
(* na ekranie w odpowiedzi na komunikat WM_PAINT                            *)
(* Parametr		: przepisuje do zmiennej globalnej paintnum         *)
(****************************************************************************)
procedure drawscreen;
 begin
  InvalidateRect(vhWnd,nil,TRUE);
  UpdateWindow(vhWnd);
 end ;


(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*   Wyswietlenie konfiguracji badanego modulu i jego toru a/c.            *)
(* Sposob:                                                                 *)
(*   Przez wykorzystanie informacji zawartych w strukturach module i info. *)
(***************************************************************************)
procedure displayconfiguration(dc:HDC ; var rect : TRECT);
var
    i: integer;
    line : Array[0..100]of char ;
    spar :string[255] ;
    sp1 : string[20];
begin
					(* konfiguracja modulu              *)
    rect.left := rect.left + 10 ;
    DrawText(dc,'Konfiguracja moduu:',-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc); GoToLine(rect,dc);

    StrPCopy(line,'Adres moduu: '+ writehex(s_module.LC0_MBASE1)+ '(hex)');
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);

    str(s_module.LC0_MIAD,spar) ;
    StrPCopy(line,'Liczba przetwornikw a/c: ' + spar);
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);

    str(s_module.LC0_MIDA,spar);
    StrPCopy(line,'Liczba przetwornikw c/a: ' + spar);
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);

    str(s_module.LC0_MIDI,spar);
    StrPCopy(line,'Liczba portw cyfrowych wejciowych: '+ spar);
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);

    str(s_module.LC0_MIDO,spar);
    StrPCopy(line,'Liczba portw cyfrowych wyjciowych: ' +spar);
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);

    str((longint(s_module.LC0_MCLOCK) / 1000):1:0,spar);
    StrPCopy(line,'Czstotliwo zegara moduu: ' + spar + ' MHz');
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);GoToLine(rect,dc);

    StrPCopy(line,'Konfiguracja toru a/c:');
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);GoToLine(rect,dc);

    str(s_info.LC0_GCHAN,spar);
    StrPCopy(line,'Liczba kanaw: ' + spar);
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);

    str(s_info.LC0_GRES,spar);
    StrPCopy(line,'Rozdzielczo: '+ spar +' bitow');
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);

    str((s_info.LC0_GMINV / 10):3:1,spar);str((s_info.LC0_GMAXV / 10):3:1,sp1);
    StrPCopy(line,'Zakres napi:' + spar+'..'+ sp1 +' V');
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);

    if s_info.LC0_GDMA = $FF then
     StrPCopy(line,'Tor a/c nie jest podczony do kanaw DMA')
    else
     begin
      str(s_info.LC0_GDMA,spar);
      StrPcopy(line,'Numer kanau DMA podczonego do toru a/c: ' + spar);
     end;
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);

    StrPCopy(line,'Minimalne okresy prbkowania [us]:');
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);
    rect.left := rect.left + 5;

    StrPCopy(line,'');
    spar := '';
    for i := 1 to s_info.LC0_GCHAN do
	begin
         str((s_info.LC0_GMINP[i] / 10):5:1,sp1);
         if i < s_info.LC0_GCHAN  then
          spar :=spar+ ' '+ sp1 +','
         else
          spar :=spar+ ' '+ sp1 ;
         if i =7 then
          begin
           StrPCopy(line,spar);
           DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
           StrPCopy(line,'');
           spar :='';
	   GoToLine(rect,dc);
          end
	end;
    StrPCopy(line,spar);
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    GoToLine(rect,dc);GoToLine(rect,dc);
    StrPCopy(line,'Wcinij dowolny klawisz lub kliknij by przej dalej ... ');
    DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
    ReleaseDC(dc,vhWnd);
end;
(***************************************************************************)
(* Funkcja : displaytext(HDC,RECT,unsigned char)			   *)
(* Przeznaczenie:                                                          *)
(*   Wyswietlenie komunikatw tekstowych dla transmisji	 A/C programu      *)
(* Korzysta ze zmiennej paintdet , ktra okrela biec faz transmisji    *)
(* blokowej oraz paintnum , ktra okrela rodzaj transmisji	.	  *)
(***************************************************************************)
function displaytext(dc : HDC ;rect : TRECT;start : byte ):integer ;
 var
  line : array[0..200] of char;
  spr  : string[200];
  str1  : string[10];
 begin
  rect.left := rect.left + 10;
  case paintdet of
   1   :begin
        (* blocktransmission *)
        StrPCopy(line,'Poprawne przetwarzanie blokowe .');
        DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
        end;
   2   :begin
       (* failblocktransmission *)
        StrPCopy(line,'Bdne przetwarzanie blokowe.');
	DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
        end ;
   3   :begin
       (* interruptbefore *)
        StrPCopy(line,'Przetwarzanie blokowe z oczekiwaniem 1000s.');
	DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
	GoToLine(rect,dc);
	StrPCopy(line,'Oczekiwanie naley przerwa Ctrl-Break.');
	DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
        end ;
   4   :begin
       (* singletransmission *)
        StrPcopy(line,'Przetwarzanie programowe - po 5 sekundach .');
	DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
        end;
   5   :begin
       (* singlewrite *)
        StrPCopy(line,'Wysanie pojedynczej wartoci na przetwornik CA.');
	DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
        end;
  end ;
  GoToLine(rect,dc);
  if paintdet < 4 then (* transmisje blokowe : paintdet = 1..3*)
  begin
   GoToLine(rect,dc);
   spr := 'Pomiar blokowy ,  ';str(CHANNELS,str1);
   spr := spr + str1 + ' kanaw, '; str(SAMPLES,str1);
   spr := spr + str1 + ' prbek, ' ; str((s_analog_in.LC0_APER / 10):5:1,str1);
   spr := spr + ' okres prbkowania ' + str1 + ' us :'   ;
   StrPCopy(line,spr);
   DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
  end ;
  case start of
    LC0_SIMMED :StrPCopy(line,'Warunek startu: natychmiast.');
    LC0_STIME  :begin
                 str(s_analog_in.LC0_ASTART.time,str1);
                 spr :='Warunek startu: upyw '+str1 + ' sekund.' ;
                 StrPCopy(line,spr);
                end;
  end ;
  GoToLine(rect,dc);
  DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
  displaytext := rect.top;
 end ;


(***************************************************************************
* Przeznaczenie:                                                          *
*   Wyswietlenie bufora z danymi pomiarowymi.                             *
* Parametry:                                                              *
*   buf - adres bufora                                                    *
*   c   - liczba kanalow                                                  *
*   s   - liczba probek na kanal                                          *
*   dc	- kontekt wyswietlania						  *
*  rect - okno do wywietlania					          *
***************************************************************************)
function displaybuf(var buf:buftype ; c,s : integer ; dc : HDC ; rect : TRECT):integer ;
var
 i,j : integer ;
 line : array[0..200] of char ;
 spr  : string[200];
 spr1 : string[200];
begin
 GoToLine(rect,dc);
 for i:= 0 to s-1 do
  begin
   str(i+1,spr);
   spr :=spr + ':  ';
   for j:=0 to c-1 do
    begin
     spr1:= writehex(buf[i*c+j+1]);
     spr:= spr + spr1 +',  ';
    end;
   StrPCopy(line,spr);
   DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
   GoToLine(rect,dc);
  end;
 displaybuf:=rect.top;
end;

(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*    Procedura obslugi przerwania pomiaru klawiszem Ctrl-Break.         *)
(*                                                                         *)
(* Sposob:                                                                 *)
(*                                                                         *)
(***************************************************************************)
procedure my_break;
begin
    koniec :=1;
    MessageBeep(0) ;
end;

(***************************************************************************)
(* Funkcja : installbreak						   *)
(* Przeznaczenie:                                                          *)
(*   Zainstalowanie procedury obslugi przerwania generowanego przez        *)
(*   Ctrl-Break.                                                           *)
(* Sposob:                                                                 *)
(*   Przez wywolanie funkcji BREAK.                                        *)
(***************************************************************************)
procedure installbreak;
begin
	s_break.LC0_BMODE := LC0_BREAK_INST;
	s_break.LC0_BPROC := @my_break;	(* podlozona zostanie      *)
                                                (*   procedura uytkownika    *)
	LC0_Break(@s_break);                    (* nil *)
end;



(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*   Wypisanie komunikatow o bledzie / ostrzezeniu / dodatkowej informacji *)
(*   bledzie.                                                              *)
(* Parametry:                                                              *)
(*   status   - LC0_STATUS                                                 *)
(*   err_stat - LC0_ERR_STAT                                               *)
(***************************************************************************)
procedure drivererror(status, err_stat: shortint);
var
 line : array [0..200] of char ;
 spr  : string[200];
begin
  str(status,spr);
  if status > 0 then
   StrPCopy(line,'Ostrzezenie (kod): '+ spr)
  else
   StrPCopy(line,'Bd (kod): '+ spr);
  MessageBox(vhWnd,line,'Sygna',MB_OK);
  if err_stat < 0 then
   begin
    str(err_stat,spr);StrPCopy(line,'Informacje dodatkowe(kod): '+spr) ;
    MessageBox(vhWnd,line,'Sygna',MB_OK);
   end;
end;

(***************************************************************************)
(* Funkcja PressOrClickAny(HDC,RECT)                                        *)
(*   Wypisuje na ekranie informacje o kocu kolejnego      kroku programu  *)
(***************************************************************************)
procedure PressOrClickAny(dc : HDC ;rect : TRECT);
var
  line: array[0..100] of char ;
begin
 GoToLine(rect,dc);GoToLine(rect,dc);
 StrPCopy(line,'Wcinij dowolny klawisz lub kliknij by przej dalej ... ');
 DrawText(dc,line,-1,rect,DT_LEFT or DT_SINGLELINE);
end;


(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*   Wykonanie transmisji blokowej.                                        *)
(* Sposob:                                                                 *)
(*   Przez wykonanie funkcji ANALOG_INPUT.                                 *)
(* Parametry:                                                              *)
(*   start - typ warunku startu                                            *)
(* Wartosc:                                                                *)
(* Uwagi:                                                                  *)
(*   Funkcja wywolujaca musi ustawic okres probkowania i parametry warunku *)
(*   startu.                                                               *)
(***************************************************************************)
procedure transmission(start: byte);
var
    c: char;
begin

    s_analog_in.LC0_AMODULE := modulenum;
    s_analog_in.LC0_ANUM := 1;
    s_analog_in.LC0_AMODE := LC0_MOD_START or
			     LC0_MOD_NEW_PAR or
			     LC0_MOD_SYNCHR or
			     LC0_MOD_BLOCK;
				(* stop po zmierzeniu okreslonej liczby    *)
				(* probek                                  *)
    s_analog_in.LC0_ASTST := start + LC0_ZSAMPLES;
				(* praca wielokanalowa, CHANNELS kanalow   *)
    s_analog_in.LC0_ACHAN := CHANNELS;
    s_analog_in.LC0_AADDR := @buf;
    s_analog_in.LC0_ALEN := BUFLEN;	(* dlugosc bufora                  *)
    s_analog_in.LC0_ABMAR := 0;
    s_analog_in.LC0_AEMAR := 0;		(* oba marginesy zerowe            *)
					(* calkowita liczba probek         *)
    s_analog_in.LC0_ASTOP.samples := SAMPLES * CHANNELS;
    LC0_AnalogIn(@s_analog_in); 			(* ANALOG_INPUT    *)
    if s_analog_in.LC0_STATUS <> LC0_OK then
	begin
	    enddet :=1 ;
	    drivererror(s_analog_in.LC0_STATUS, s_analog_in.LC0_ERR_STAT) ;
	end
    else
     enddet :=2 ;
    drawscreen;
end;

(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*   Wykonanie poprawnej transmisji blokowej i wyswietlenie zmierzonych    *)
(*   wartosci.                                                             *)
(* Sposob:                                                                 *)
(*   Przez wykonanie funkcji transmission.                                 *)
(***************************************************************************)
procedure blocktransmission;
begin
    tstart := LC0_SIMMED;
    paintdet := 1;
    s_analog_in.LC0_APER := s_info.LC0_GMINP[CHANNELS]+200;
    drawscreen;
    transmission(LC0_SIMMED);
end;

(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*   Wykonanie blednej transmisji blokowej.                                *)
(* Sposob:                                                                 *)
(*   Przez wykonanie funkcji ANALOG_INPUT z okresem probkowania mniejszym  *)
(*   niz minimalny wskazany przez driver.                                  *)
(***************************************************************************)
procedure failblocktransmission;
begin
    tstart := LC0_SIMMED;
    paintdet := 2;
    s_analog_in.LC0_APER := s_info.LC0_GMINP[CHANNELS] - 1;
    drawscreen;
    transmission(LC0_SIMMED);
end;

(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*   Wykonanie poprawnej transmisji blokowej ale przerwanej przez operatora*)
(*   (Ctrl-Break) w trakcie czekania na spelnienie warunku startu.         *)
(* Sposob:                                                                 *)
(*   Przez wykonanie funkcji ANALOG_INPUT z warunkiem startu LC0_STIME     *)
(*   (start po okreslonym czasie) i parametrem tego warunku - 1000s.       *)
(***************************************************************************)
procedure interruptedbefore;
begin
    tstart := LC0_STIME;
    paintdet := 3;
    s_analog_in.LC0_APER := s_info.LC0_GMINP[CHANNELS];
    s_analog_in.LC0_ASTART.time := 1000;
    drawscreen;
    transmission(LC0_STIME);
end;

(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*   Wykonanie pomiaru bloku probek za pomoca tranmsisji programowej, przy *)
(*   czym caly blok ma byc zmierzony po 5s od startu.                      *)
(* Sposob:                                                                 *)
(*   Przez wykonanie funkcji ANALOG_INPUT.                                 *)
(* Parametry:                                                              *)
(* Wartosc:                                                                *)
(* Uwagi:                                                                  *)
(***************************************************************************)
procedure singletransmission;
begin
    tstart := LC0_STIME ;
    paintdet := 4 ;
    s_analog_in.LC0_AMODULE := modulenum;
    s_analog_in.LC0_ANUM := 1;
    s_analog_in.LC0_AMODE := LC0_MOD_START or
			     LC0_MOD_NEW_PAR or
			     LC0_MOD_SINGLE;
				(* praca wielokanalowa, CHANNELS kanalow   *)
    s_analog_in.LC0_ACHAN := CHANNELS;
    s_analog_in.LC0_AADDR := @buf;
    s_analog_in.LC0_ALEN := BUFLEN;	(* dlugosc bufora (tylko na jeden  *)
    					(* pomiar)                         *)
    s_analog_in.LC0_ASTST := LC0_STIME+ LC0_ZSAMPLES;
    s_analog_in.LC0_ASTART.time := 5;	(* start po 5 sekundach            *)
    (* calkowita liczba probek         *)
    s_analog_in.LC0_ASTOP.samples := SAMPLES * CHANNELS;
    drawscreen;

    LC0_AnalogIn(@s_analog_in);				(* ANALOG_INPUT    *)
    if s_analog_in.LC0_STATUS <> LC0_OK then
	begin
	    enddet :=1 ;
	    drivererror(s_analog_in.LC0_STATUS, s_analog_in.LC0_ERR_STAT) ;
	end
    else
     enddet :=2 ;
    drawscreen;
end;

(***************************************************************************)
(* Przeznaczenie:                                                          *)
(*   Wyslanie pojedynczej wartosci na przetwornik CA.                      *)
(* Sposob:                                                                 *)
(*   Przez wykonanie funkcji ANALOG_OUTPUT.                                *)
(* Parametry:                                                              *)
(* Wartosc:                                                                *)
(* Uwagi:                                                                  *)
(***************************************************************************)
procedure singlewrite;
var
         val:  Integer;			(* wartosc do wyslania             *)
begin
        tstart := LC0_SIMMED ;
	paintdet := 5 ;
	if(s_module.LC0_MIDA = 0) then
	begin
         MessageBox(vhWnd,'Karta nie posiada zainstalowanych przetwornikow CA','Sygna',MB_OK);
	 drawscreen;
	 Exit;
	end;

	val := 4095;
	s_analog_out.LC0_NMODULE := modulenum;
	s_analog_out.LC0_NNUM := 1;
	s_analog_out.LC0_NMODE := LC0_MOD_START or
				 LC0_MOD_NEW_PAR or
				 LC0_MOD_SYNCHR;
						(* praca jednokanalowa     *)
	s_analog_out.LC0_NCHAN := $80 or $01;
	s_analog_out.LC0_NADDR.base_memory := @val;
					(*   daleki adres                  *)
	s_analog_out.LC0_NLEN := 1;		(* dlugosc bufora (tylko   *)
						(*   na jedna wartosc)     *)
	s_analog_out.LC0_NSTST := LC0_SIMMED + LC0_ZSAMPLES;
						(* praca jednokanalowa     *)
	s_analog_out.LC0_NSTOP.samples := 1;

				(* ANALOG_OUTPUT   *)
        LC0_AnalogOut(@s_analog_out);
	if s_analog_in.LC0_STATUS <> LC0_OK then
	 drivererror(s_analog_in.LC0_STATUS, s_analog_in.LC0_ERR_STAT) ;
        enddet :=1 ;
        drawscreen;

end;

(****************************************************************************

	Funkcja:   MainWndProc(HWND, UINT, WPARAM, LPARAM)

	Przeznaczenie:   Funkcja odpowiedzi okna na komunikaty .

	Komunikaty:

		 WM_COMMAND- Menu okna
		 WM_DESTROY- Zniszczenie okna i nastpnie powrt do Windows
		 WM_PAINT  - Odmalowywanie okna
		 WM_LBUTTONDOWN - Wczinicie lewego klawisza myszy
		 WM_KEYDOWN - Wcinicie klawisza
		 MY_MESSAGE - wywoanie kolejnej procedury programu

****************************************************************************)

function MainWndProc(vhWnd : HWND ;  message,wParam : Word ; lParam : Longint):Longint ; export;
var
 dc   : HDC;
 rect : TRECT;
 ps   : TPAINTSTRUCT ;
begin
 case message of
   WM_COMMAND:	(* komenda menu *)
     case wParam of
      101 : (* pomiary *)
       begin
        if paintnum = 0 then
	 begin
	  paintnum := 1;
	  PostMessage(vhWnd,MY_MESSAGE,0,0);
         end;
       end ;
      102 : (* koniec *)
       begin
          DestroyWindow(vhWnd);
       end;
      else
	  MainWndProc:=DefWindowProc(vhWnd, message, wParam, lParam);
     end ;
   WM_PAINT : (* wyswietlenie informacji *)
    begin
     dc := BeginPaint(vhWnd,ps);
     GetClientRect(vhWnd,rect);
     case paintnum of
      1 : (* konfiguracja *)
       	displayconfiguration(dc,rect);
      2,3,4,5,6 :
       begin
        rect.top :=displaytext(dc,rect,tstart);
        rect.left:=10;
        if enddet > 0 then
         begin
          if enddet=2 then
           begin
            rect.top:=displaybuf(buf,CHANNELS, SAMPLES,dc,rect);
           end;
          PressOrClickAny(dc,rect);
         end;
       end ;
     end;
     EndPaint(vhWnd,ps);
    end ;
   WM_LBUTTONDOWN ,WM_KEYDOWN :  (*  goto next*)
    begin
     if paintnum <> 0 then
      begin
       paintnum := paintnum +1 ;
       if paintnum = 7 then
        begin
         paintnum := 0 ;
         drawscreen;
        end
       else
         PostMessage(vhWnd,MY_MESSAGE,0,0);
      end ;
    end ;
   MY_MESSAGE : (* wykonanie kolejnego kroku algorytmu *)
    begin
     enddet := 0;
     case paintnum of
       1:begin
         askdriver;          (* odpytanie driver-a o konfiguracje *)
         drawscreen;         (* wyswietlenie konfiguracji modulu *)
         installbreak;       (* zainstalowanie procedury obslugi CTRL_BRAEK  *)
         end;
       2:blocktransmission;    (* wykonanie transmisji blokowej *)
       3:failblocktransmission;(* wykonanie bdnej transmisji blokowej *)
       4:interruptedbefore;    (*wykonanie transmisji blokowej przerwanej*)
                                 (* przez operatora przed startem *)
       5:singletransmission;	 (* wykonanie pomiaru programowego *)
       6:singlewrite;            (* wysanie pojedynczej wartoci na DAC*)
     end ;
    end ;
   WM_DESTROY: (* koniec programu *)
    begin
     PostQuitMessage(0);
    end ;
   else
    MainWndProc := DefWindowProc(vhWnd, Message, wParam, lParam);
 end ;
end ;


(***************************************************************************

	Procedura   WinMain

	Przeznaczenie: Inicjacja aplikacji , okna gwnego

****************************************************************************)

procedure WinMain;
var
 msg : TMsg;
 WndClas : TWndClass ;
begin
 if hPrevInst = 0 then
  begin
    WndClas.Style := 0;
    WndClas.lpfnWndProc:= @MainWndProc;
    WndClas.cbClsExtra := 0;
    WndClas.cbWndExtra := 0;
    WndClas.hInstance := HInstance;
    WndClas.hIcon := LoadIcon(HInstance,'ICON_1');
    WndClas.hCursor := LoadCursor(0, IDC_Arrow);
    WndClas.hbrBackground := GetStockObject(White_Brush);
    WndClas.lpszMenuName := 'MENU_1';
    WndClas.lpszClassName := 'DemoDriverWClass';
    if not RegisterClass(WndClas) then
      Halt;
  end ;
  vhWnd := CreateWindow('DemoDriverWClass','Przykad uycia biblioteki DLL Windows do kart AMBEX LC',
           WS_OverLappedWindow,CW_UseDefault,CW_UseDefault, CW_UseDefault,CW_UseDefault, 0, 0, hInstance, nil);
  if vhWnd = 0  then
   Halt;

  UpDateWindow(vhWnd);
  ShowWindow(vHwnd,Sw_ShowNormal);

  MessageBox(vhWnd,'Zamknij by rozpocz przykadow sesj pomiarow .','Informacja',MB_OK);
  paintnum := 1;
  PostMessage(vhWnd,MY_MESSAGE,0,0);

  while GetMessage(Msg, 0, 0, 0) do
  begin
    TranslateMessage(msg);
    DispatchMessage(msg);
  end;
  quit ;
end ;

begin
  WinMain;
end.
