Attribute VB_Name = "LCDecl"

'***************************************************************************
' "ambex-lc.bas"
' Definicje struktur danych , funkcji i staych driver'w Windows do kart
' kontrolno pomiarowych f-y AMBEX .
' Przeznaczenie : jezyk  MS Visual Basic v 4.0
'
' ***************************************************************************

'**************** REKORDY OPISOW ZLECEN FUNKCJI DRIVER'A *******************
'************** struktury opisujace warunki startu i stopu *****************
' kody rodzajow zbocza:    warunek "zbocze sygnalu cyfrowego"
Public Const LC0_SLOPE_COND_UP   As Byte = 1     ' narastajace
Public Const LC0_SLOPE_COND_DOWN As Byte = 0     ' opadajace

' kody kierunku przekroczenia progu : warunek "sygnal analogowy"
Public Const LC0_ANALOG_COND_UP As Byte = &H80    ' w kierunku wiekszych wartosci
Public Const LC0_ANALOG_COND_DOWN As Byte = 0    ' w kierunku mniejszych wartosci
Public Const LC0_ANALOG_COND_MASK As Byte = &H80  ' maska kodu kierunku
            ' kody typu wyzwolenia
Public Const LC0_ANALOG_TYPE_SLOPE As Byte = 0   ' zbocze
Public Const LC0_ANALOG_TYPE_LEVEL As Byte = &H40 ' poziom
Public Const LC0_ANALOG_TYPE_MASK  As Byte = &H40 ' maska

' struktura opisujca warunki startu operacji
Public Type lc0_start
    Parametr(1 To 5) As Byte
End Type

' znaczenie poszczeglnych parametrw w zalenoci od typu warunkw startu

' warunek "poziom sygnau cyfrowego"
    ' Parametr(1)   : numer modulu
    ' Parametr(2)   : numer portu
    ' Parametr(3)   : numer wejscia
    ' Parametr(4)   : oczekiwana wartosc
    
' warunek "zbocze sygnalu cyfrowego"
    ' Parametr(1)   : numer modulu
    ' Parametr(2)   : numer portu
    ' Parametr(3)   : numer wejscia
    ' Parametr(4)   : rodzaj zbocza
 
' warunek "kombinacja sygnalow cyfrowych"
    ' Parametr(1)   : numer modulu
    ' Parametr(2)   : numer portu
    ' Parametr(3)   : maska aktywnych wej
    ' Parametr(4)   : testowany wzorzec
    
' warunek "upyw czasu"
    ' Parametr(1..4) - czas podany w sekundach (zmienna typu Long)
    
' warunek "data"
    ' Parametr(1)   : sekunda
    ' Parametr(2)   : minuta
    ' Parametr(3)   : godzina
    ' Parametr(4)   : dzie miesica
    
' warunek "sygnal analogowy"
    ' Parametr(1)   : numer moduu
    ' Parametr(2)   : numer przetwornika
    ' Parametr(3)   : bity 6..0 numer kanau analogowego ; b7 zbocze/poziom ; b8 kierunek przekroczenia
    ' Parametr(4..5): prg wyzwolenia (bity 11..0) ; stopie redukcji zakce (bity b15..b12) : format Integer
    
' struktura opisujca warunki stopu operacji
Public Type lc0_stop
    SAMPLES As Long ' LC0_ZSAMPLES - ilo prbek do zmierzenia
    extra   As Byte ' dodatkowy bajt struktury
End Type

' definicje typw argumentw poszczeglnych funkcji driver'a

' Rekord opisu zlecenia funkcji  MODULE_INIT =============================
Public Type lc0_init
    LC0_CODE    As Byte      ' kod funkcji
    LC0_STATUS  As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte     ' dodatkowe informacje o bledach
    LC0_IMODULE As Byte      ' mapa modulow
End Type

' Rekord opisu zlecenia funkcji  GET_TOTAL_CONFIGURATION =================
Public Type lc0_total
    LC0_CODE  As Byte        ' kod funkcji
    LC0_STATUS As Byte       ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte     ' dodatkowe informacje o bledach
    LC0_TONF As Byte         ' konfiguracja modulow
    LC0_TIAD As Byte         ' przetworniki a/c
    LC0_TIDA As Byte         ' przetworniki c/a
    LC0_TCTC As Byte         ' kanaly CTC
    LC0_TIDI As Byte         ' porty wejsc cyfrowych
    LC0_TIDO As Byte         ' porty wyjsc cyfrowych
End Type

' Rekord opisu zlecenia funkcji   GET_MODULE_CONFIGURATION ===============
Public Type lc0_module
    LC0_CODE As Byte         ' kod funkcji
    LC0_STATUS As Byte       ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte     ' dodatkowe informacje o bledach
    LC0_MMODULE As Byte      ' numer modulu
    LC0_MBASE1 As Integer    ' adres bazowy pakietu 1
    LC0_MBASE2 As Integer    ' adres bazowy pakietu 2
    LC0_MIAD As Byte         ' przetworniki a/c
    LC0_MIDA As Byte         ' przetworniki c/a
    LC0_MCTC As Byte         ' kanaly CTC
    LC0_MIDI As Byte         ' porty wejsc cyfrowych
    LC0_MIDO As Byte         ' porty wyjsc cyfrowych
    LC0_MCLOCK As Integer    ' czestotliwosc zegara w kHz
    LC0_MINT As Byte         ' numer przerwania (programowy)
    LC0_MMEMA As Long        ' adres daleki (selektor:offset) bufora w pamici rozszerzonej
    LC0_MMEML As Long        ' dugo bufora w pamici rozszerzonej
End Type

' Rekord opisu zlecenia funkcji  GET_INFO ================================
Public Type lc0_info
    LC0_CODE As Byte         ' kod funkcji
    LC0_STATUS As Byte       ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte     ' dodatkowe informacje o bledach
    LC0_GTYPE As Byte        ' rodzaj urzadzenia
    LC0_GMODULE As Byte      ' numer modulu
    LC0_GNUM As Byte         ' numer przetwornika/portu/
                             ' ukladu CTC
    LC0_GCHAN As Byte        ' liczba kanalow
    LC0_GRES As Byte         ' liczba bitow przetwornika
    LC0_GTIME As Integer     ' czas konwersji przetwornika w ns
    LC0_GMINV As Byte        ' dolna granica zakresu napiec w
                             '   dziesiatych czesciach wolta
    LC0_GMAXV As Byte        ' gorna granica zakresu napiec w
                             '   dziesiatych czesciach volta
    LC0_GDMA As Byte         ' numer kanalu DMA
    LC0_GMINP(1 To 32) As Integer ' minimalne okresy probkowania w 0.1 us
 End Type

' Rekord opisu zlecenia funkcji  SET_CLOCK ===============================
Public Type lc0_clock
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_LCLOCK As Integer   ' czestotliowsc zegara w kHz
End Type

' Rekord opisu zlecenia funkcji  SET_VOLTAGE_RANGE =======================
Public Type lc0_volt
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_VTYPE As Byte       ' rodzaj urzadzenia
    LC0_VMODULE As Byte     ' numer modulu
    LC0_VNUM As Byte        ' numer przetwornika
    LC0_VMINV As Byte       ' dolna granica zakresu napiec w
                            '   dziesiatych czesciach volta
    LC0_VMAXV As Byte       ' gorna granica zakresu napiec w
                            '   dziesiatych czesciach volta
    LC0_VAMPL As Byte       ' kod wzmocnienia wzm. instrum.
End Type

' Rekord opisu zlecenia funkcji  SET_TIME ================================
Public Type lc0_time
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_ETIME As Integer    ' maksymalny czas obslugi
                            '   przerwania, ktore moze pojawic
                            '   sie w trakcie wykonywania
                            '   dlugiego pomiaru podawany w
                            '   mikrosekundach
End Type

' Rekord opisu zlecenia funkcji  WAIT_FOR_END ============================
Public Type lc0_swait
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_WTYPE As Byte       ' rodzaj urzadzenia
    LC0_WMODULE As Byte     ' numer modulu
    LC0_WNUM As Byte        ' numer przetwornika
    LC0_WMODE As Byte       ' tryb pracy
    LC0_WRMNUM As Long      ' rzeczywista liczba probek
    LC0_WREMAR As Integer   ' rzeczywista dlugosc marginesu
                            ' koncowego
End Type
        ' tryby pracy funkcji
Public Const LC0_W_WAIT As Byte = 0 ' oczekiwanie
Public Const LC0_W_TEST As Byte = 1 ' test konca
Public Const LC0_W_FINISHED As Byte = 2 'powiadomienie o koncu

' Rekord opisu zlecenia funkcji  BREAK ===================================
Public Type lc0_sbreak
    LC0_CODE As Byte        ' kod funkcji (8)
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_BMODE As Byte       ' tryb pracy
    LC0_BPROC As Long       ' adres procedury obslugi (selektor:offset)
End Type
                            ' bity trybu pracy funkcji
Public Const LC0_BREAK_EXEC As Byte = 0 ' przerwanie
Public Const LC0_BREAK_INST As Byte = 1 ' instalacja Ctrl_Break...
Public Const LC0_BREAK_PREV As Byte = 4 ' ...z wywolaniem poprzedniej obslugi
Public Const LC0_BREAK_UNINST As Byte = 2 ' wyinstalowanie wszystkiego

' Rekord opisu zlecenia funkcji  DIGITAL_INPUT ===========================
Public Type lc0_digital_in
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_DMODULE As Byte     ' numer modulu
    LC0_DNUM As Byte        ' numer portu
    LC0_DSTST As Byte       ' typ warunku startu
    LC0_DVAL As Byte        ' odczytana wartosc
    LC0_DSTART As lc0_start ' parametry warunku startu
End Type

' Rekord opisu zlecenia funkcji  DIGITAL_OUTPUT ==========================
Public Type lc0_digital_out
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_OMODULE As Byte     ' numer modulu
    LC0_ONUM As Byte        ' numer portu
    LC0_OSTST As Byte       ' typ warunku startu
    LC0_OVAL As Byte        ' wartosc do wyslania
    LC0_OSTART As lc0_start ' parametry warunku startu
End Type

' Rekord opisu zlecenia funkcji  CTC_WRITE ===============================
Public Type lc0_ctc_write
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_CMODULE As Byte     ' numer modulu
    LC0_CMODE As Byte       ' tryb pracy funkcji
    LC0_CFUN As Byte        ' tryb pracy kanalu
    LC0_CVAL As Integer     ' nowa wartosc licznika
 End Type
                ' tryby pracy funkcji
Public Const LC0_SET_CTC_MODE As Byte = 1 ' zaprogramuj tryb pracy kanalu
Public Const LC0_SET_COUNTER_VALUE As Byte = 2   ' zaladuj nowa wartosc licznika
Public Const LC0_CTC_ENABLE As Byte = 4           ' zezwolenie CTC

' Rekord opisu zlecenia funkcji  CTC_READ ================================
Public Type lc0_ctc_read
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_UMODULE As Byte     ' numer modulu
    LC0_UNUM As Byte        ' numer kanalu
    LC0_UVAL As Integer     ' odczytana wartosc licznika
End Type

' Rekord opisu zlecenia funkcji  DATA_TRANSMIT ===========================
Public Type lc0_transmit
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_RMODULE As Byte     ' numer moduu
    LC0_RMODE As Byte       ' tryb przesylania
    LC0_RADDR As Long       ' adres bufora DMA - pomiarowego  (selektor:offset)
    LC0_RLEN As Long        ' dlugosc bufora w DMA - pomiarowego
    LC0_RMEAS As Long       ' numer pierwszej probki
    LC0_RNUM As Long        ' liczba probek do przeslania
    LC0_RMEMA As Long       ' adres bufora w pamieci
                            ' aplikacji  (selektor:offset)
    LC0_RRNUM As Long       ' rzeczywista liczba probek
End Type
                ' tryby pracy funkcji
Public Const LC0_TO_EXT_DIR As Byte = 1   ' do pamieci aplikacji  - programowy
Public Const LC0_FROM_EXT_DIR As Byte = 0 ' z pamieci modulu / aplikacji

' Rekord opisu zlecenia funkcji ANALOG_INPUT =============================
Public Type lc0_analog_in
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_AMODULE As Byte     ' numer modulu
    LC0_ANUM As Byte        ' numer przetwornika
    LC0_AMODE As Integer    ' tryb pracy funkcji
    LC0_ASTST As Byte       ' typy warunkow startu i stopu
    LC0_APER As Long        ' okres probkowania
    LC0_APER2 As Integer    ' krotnosc okresu probkowania
    LC0_ACHAN As Byte       ' liczba kanalow podstawowych
                                            '   (b8 okresla czy praca
                                            '   wielokanalowa (0) czy
                                            '   jednokanalowa (1))
    LC0_ACHAN2 As Byte      ' liczba kanalow dodatkowych
    LC0_AADDR As Long       ' adres bufora w pam. podstawowej  (selektor:offset)
    LC0_ALEN  As Long       ' dugo bufora
    LC0_AMEMA As Long       ' adres bufora w pam. rozszerzonej (selektor:offset)
    LC0_ABMAR As Integer    ' dlugosc marginesu poczatkowego
    LC0_AEMAR As Integer    ' dlugosc marginesu koncowego
    LC0_AHAND As Integer    ' numer handler'a zbioru
    LC0_ASTART As lc0_start ' parametry warunku startu
    LC0_ASTOP As lc0_stop   ' parametry warunku stopu
    LC0_ARDIV1 As Integer   ' pierwszy podzielnik zegara
    LC0_ARDIV2 As Integer   ' drugi podzielnik zegara
    LC0_ARMNUM As Long      ' rzeczywista liczba probek
    LC0_ARBMAR As Integer   ' rzeczywista dlugosc marg. pocz.
    LC0_AREMAR As Integer   ' rzeczywista dlugosc marg. konc.
    LC0_ARLEN As Long       ' rzeczywista liczba przepisanych
                                           '  probek
    LC0_ARBUF As Integer    ' dla pracy z buforem cyklicznym:
                                            '   numer probki okreslajacej
                                            '   poczatek bufora po zakonczeniu
                                            '   pomiaru
End Type

' Rekord opisu zlecenia funkcji  ANALOG_OUTPUT ===========================
Public Type lc0_analog_out
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_NMODULE As Byte     ' numer modulu
    LC0_NNUM As Byte        ' numer przetwornika
    LC0_NMODE As Integer    ' tryb pracy funkcji
    LC0_NSTST As Byte       ' typy warunkow startu i stopu
    LC0_NCHAN As Byte       ' liczba kanalow (b8 okresla
                                             '  czy praca wielokanalowa (0)
                                             '   czy jednokanalowa (1))
    LC0_NPER As Long        ' okres probkowania
    LC0_NADDR As Long       ' adres bufora (selektor:offset)
                            ' pamieci podstawowej lub rozszerzonej
    LC0_NLEN  As Long       ' dlugosc bufora w pamieci podstawowej
    LC0_NHAND As Integer    ' numer handler'a zbioru
    LC0_NSTART As lc0_start ' parametry warunku startu
    LC0_NSTOP As lc0_stop   ' parametry warunku stopu
    LC0_NRMNUM As Long      ' rzeczywista liczba wyslanych  prbek
End Type

' Rekord opisu zlecenia funkcji  LEAVE_DRIVER ============================
Public Type lc0_sleave
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
End Type

' Rekord opisu zlecenia funkcji  INTERRUPT_SERVICE
Public Type lc0_sinterrupt
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_SMODULE As Byte     ' numer modulu
    LC0_SPROC As Long       ' adres procedury obslugi (selektor:offset)
    LC0_SSTAT As Long       ' adres slowa komunikacyjnego  (selektor:offset)
End Type

' Rekord opisu zlecenia funkcji MEMORY_USE
Public Type lc0_memory
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_MMODULE As Byte     ' nr moduu do ktrego odnosi si ta operacja
    LC0_MMODE As Byte       ' obecnie == 1
    LC0_MNUM As Long        ' dana liczba prbek w nowym buforze
    LC0_MRNUM As Long       ' rzeczywista wielko bufora w prbkach
    LC0_MRMEMA As Long      ' adres nowego bufora w pamici (selektor:offset)
End Type

' Rekord opisu zlecenia funkcji CONFIG
Public Type lc0_sconfig
    LC0_CODE As Byte        ' kod funkcji
    LC0_STATUS As Byte      ' kod odpowiedzi driver'a
    LC0_ERR_STAT As Byte    ' dodatkowe informacje o bledach
    LC0_INI_FILE As Long    ' adres (selektor:offset) do cieki do pliku 'ambex.ini'
                            ' gdy NULL to standardowe pszeszukanie
End Type

Public Const LC0_IS_START As Byte = 1 ' przerwanie wystapilo z powodu
                                      ' rozpoczecia pomiaru
Public Const LC0_IS_ONE As Byte = 2   ' przerwanie nastapilo z powodu zmierzenia
                                      '   kolejnej serii pomiarowej
Public Const LC0_IS_END_ADC As Byte = 4 ' przerwanie nastapilo z powodu
                                        ' zakonczenia przetwarzania a/c
Public Const LC0_IS_END_DAC As Byte = 8 ' przerwanie nastapilo z powodu
                                        '   zakonczenia przetwarzania c/a
Public Const LC0_IS_BROKEN  As Byte = 16 ' zakonczono przetwarzanie z powodu
                                         ' wykonania funkcji BREAK
Public Const LC0_IS_SAMPLE  As Byte = 32 ' przerwanie nastapilo z powodu zmierzenia
                                         '  kolejnej probki

' ***************** kody funkcji driver'a *********************************
Public Const MODULE_INIT  As Byte = 16
Public Const GET_TOTAL_CONFIGURATION As Byte = 17
Public Const GET_MODULE_CONFIGURATION As Byte = 18
Public Const GET_INFO As Byte = 19
Public Const SET_CLOCK As Byte = 20
Public Const SET_VOLTAGE_RANGE As Byte = 21
Public Const SET_TIME As Byte = 22
Public Const WAIT_FOR_END As Byte = 23
Public Const BREAK As Byte = 24
Public Const DIGITAL_INPUT As Byte = 25
Public Const DIGITAL_OUTPUT As Byte = 26
Public Const CTC_WRITE As Byte = 27
Public Const CTC_READ As Byte = 28
Public Const DATA_TRANSMIT As Byte = 29
Public Const ANALOG_INPUT As Byte = 30
Public Const ANALOG_OUTPUT As Byte = 31
Public Const LEAVE_DRIVER As Byte = 32
Public Const INTERRUPT_SERVICE As Byte = 33
Public Const MEMORY_USE As Byte = 34
Public Const CONFIG As Byte = 35

'*************** numery przerwan obslugiwanych przez driver ****************
Public Const LC010_16 As Byte = &H99        ' LC-010-1612
Public Const LC011_08 As Byte = &H90        ' LC-011-0812
Public Const LC011_16 As Byte = &H91        ' LC-011-1612
Public Const LC015_16 As Byte = &H92        ' LC-015-1612
Public Const LC020_08_0 As Byte = &H93      ' LC-020-0812 v.0
Public Const LC020_08_2  As Byte = &H94     ' LC-020-0812 v.1 i v.2
Public Const LC020_32 As Byte = &H95        'LC-020-3212
Public Const LC030_16 As Byte = &H96        ' LC-030-1612
Public Const LC060_06 As Byte = &H97        ' LC-060-0612

'******************** kody odpowiedzi funkcji driver'a *********************
Public Const LC0_OK As Byte = 0

' ======= ostrzezenia ========
Public Const LC0_NON_EX_MOD As Byte = 1   ' nie istniejacy(e) modul(y)
Public Const LC0_OTHER_LEN As Byte = 2    ' przepisano mniejsza liczbe
                                                '   pomiarow
Public Const LC0_PREMATURE_END As Byte = 3 ' przedwczesne zakonczenie z
                                           '   powodu przepelnienia bufora
Public Const LC0_IN_PROGRESS As Byte = 4   ' badana transmisja jeszcze trwa
Public Const LC0_IS_INIT As Byte = 5       ' zadano inicjacji ju zainicjowanego

' ========== bledy ===========
Public Const LC0_UNKN_FUNC = -1      ' nieznany kod funkcji
Public Const LC0_NO_MODULE = -2      ' brak modulu(ow)
Public Const LC0_BAD_DEV_TYP = -3    ' bledny typ urzadzenie
Public Const LC0_NONEX_DEV = -4      ' nie istnieje urzadzenie o tym numerze
Public Const LC0_BAD_FREQ = -5       ' zla czestotliwosc zegara
Public Const LC0_BAD_RANGE = -6      ' zly zakres napiec
Public Const LC0_NO_OPER = -7        ' zadna operacja nie jest wykonywana
Public Const LC0_BAD_MARGIN = -8     ' bledna dlugosc marginesu
                                             'poczatkowego
Public Const LC0_BAD_BUF_ADR = -9    ' bledny adres bufora
Public Const LC0_BAD_BUF_LEN = -10   ' bledna dlugosc bufora
Public Const LC0_DEV_BUSY = -11      ' urzadzenie jest zajete
Public Const LC0_BAD_PER = -12       ' zly okres probkowania
Public Const LC0_BAD_CHAN_N = -13    ' zla liczba kanalow
Public Const LC0_BAD_CHAN = -14      '  numer nie istniejacego kanalu
Public Const LC0_BROKEN = -15        ' przerwano funkcja BREAK
Public Const LC0_INTR_NOT_INST = -16 'procedura obslugi przerwania nie
                                             'jest zainstalowana
Public Const LC0_ILL_START_CODE = -17 ' nielegalny typ warunku startu
Public Const LC0_ILL_STOP_CODE = -18 ' nielegalny typ warunku stopu
Public Const LC0_BAD_PROC = -19      ' bledny adres procedury obslugi
                                            ' przerwania lub slowa
                                            ' komunikacyjnego
Public Const LC0_TOO_LONG_MARG = -20 ' margines dluzszy od bufora
Public Const LC0_ILL_START = -21     ' bledne parametry warunku startu
Public Const LC0_ILL_STOP = -22      ' bledne parametry warunku stopu
Public Const LC0_BAD_MNUM = -23      ' bledny numer pierwszej probki
Public Const LC0_NOT_SUPPORTED = -24 ' dla danego modulu funkcja nie
                                             ' jest realizowana
Public Const LC0_BAD_CTC_MODE = -25   ' bledny tryb pracy CTC
Public Const LC0_NO_PARAMS = -26      ' nie podano parametrow
                                             '   przetwarzania
Public Const LC0_OVERRUN = -27        ' zakonczono przetwarzanie z
                                             '   powodu bledu OVERRUN
Public Const LC0_NO_DMA = -28         ' z danym urzadzeniem nie jest
                                             ' zwiazany zaden kanal DMA
Public Const LC0_NO_IRQ = -29         ' z danym modulem nie jest
                                             '   zwiazane zadne przerwanie
Public Const LC0_NOT_FULLY_SUP = -30 ' zadany tryb wykonania funkcji
                                             ' nie jest realizowany dla
                                             ' danego typu modulu lub funkcja
                                             ' w opracowaniu
Public Const LC0_NO_EXTMEM = -31      ' brak pamieci roszerzonej
Public Const LC0_NO_SEC_FREQ = -32    ' modul nie moze wykonywac
                                             '   pomiarow z podwojna
                                             '   czestotliwoscia
Public Const LC0_INTR_INST = -33      ' procedura obslugi przerwania
                                             ' juz zainstalowana
Public Const LC0_BAD_PER2 = -34       ' bledna wielokrotnosc okresu
                                             ' probkowania (0 lub 1)
Public Const LC0_BAD_MODE = -35       ' bledny tryb pracy
Public Const LC0_BAD_EXTMEM = -36     '  zly adres bufora w pamieci
                                             '   rozszerzonej
Public Const LC0_CTC_NOT_PROGRAMMED = -37 ' zapis licznika przy niezapro-
                                                  ' gramowanym trybie pracy
Public Const LC0_REJECTED = -38       ' za wiele rownoleglych wejsc do
                                             ' driver'a
Public Const LC0_BAD_CONFIG = -39     '  bd w pliku konfiguracyjnym *.ini
Public Const LC0_NOT_INIT = -40       ' modu nie zainicjowany
Public Const LC0_NO_DMA_TRANS = -41   ' brak moliwoci przeprowadzenia
                                             ' buforowanej transmisji DMA
Public Const LC0_BAD_RAM_SEK = -42    ' bdna sekwencja pomiarowa

'************************** dodatkowe informacje o bledach *****************
Public Const LC0_E_OK As Byte = 0    ' brak dodatkowych informacji
Public Const LC0_E_NO_MODULE = -1   ' nie ma takiego modulu
Public Const LC0_E_NONEX_DEV = -2   ' nie istnieje urzadzenie o tym
                                           '   numerze
Public Const LC0_E_BAD_CHAN = -3    ' numer nieistniejacego kanalu
Public Const LC0_E_BAD_TIME = -4    ' zly odcinek czasu
Public Const LC0_E_BAD_DATE = -5    ' zla specyfikacja daty
Public Const LC0_E_BAD_THRE = -6    ' bledny prog wyzwalania
                                           'analogowego
Public Const LC0_E_BROKEN_WAIT = -7 ' funkcja przerwana w trakcie
                                            ' oczekiwania na spelnienie
                                            ' warunku startu
Public Const LC0_E_BROKEN_RUN = -8 ' funkcja przerwana w trakcie
                                           '  przetwarzania
Public Const LC0_E_BAD_LEN = -9    ' zadeklarowano za duzo probek
Public Const LC0_E_MOD_UNABLE = -10 ' modu zajty lub niezainicjowany

'************************** kody warunkow startu ***************************
Public Const LC0_SIMMED As Byte = 0  ' natychmiastowy
Public Const LC0_SHARD As Byte = 1   ' od sygnalu sprzetowego
Public Const LC0_SLEVEL As Byte = 2  ' od poziomu sygnalu cyfrowego
Public Const LC0_SSLOPE As Byte = 3  ' od zbocza sygnalu cyfrowego
Public Const LC0_SDIG_EQ As Byte = 4 ' od kombinacji bitow - rowne
Public Const LC0_SDIG_NE As Byte = 5 ' od kombinacji bitow - rozne
Public Const LC0_STIME As Byte = 6 ' po uplynieciu okreslonego czasu
Public Const LC0_SDATE As Byte = 7 ' o podanym czasie
Public Const LC0_SANALOG As Byte = 8 ' od sygnalu analogowego

'************************** kody warunkow stopu ****************************
Public Const LC0_ZSAMPLES As Byte = &H0    ' po zmierzeniu okreslonej liczby probek
Public Const LC0_ZBREAK   As Byte = &H10   ' po wykonaniu funkcji BREAK
Public Const LC0_ZLEVEL   As Byte = &H20   ' od poziomu sygnalu cyfrowego
Public Const LC0_ZSLOPE   As Byte = &H30   ' od zbocza sygnalu cyfrowego
Public Const LC0_ZDIG_EQ  As Byte = &H40   ' od kombinacji bitow - rowne
Public Const LC0_ZDIG_NE  As Byte = &H50   ' od kombinacji bitow - rozne
Public Const LC0_ZTIME    As Byte = &H60   ' po uplynieciu okreslonego czasu
Public Const LC0_ZDATE    As Byte = &H70   ' o podanym czasie
Public Const LC0_ZANALOG  As Byte = &H80   ' od sygnalu analogowego

'*************************** kody numerow modulow **************************
Public Const LC0_MODA As Byte = 1     ' modul A
Public Const LC0_MODB As Byte = 2     ' modul B
Public Const LC0_MODC As Byte = 3     ' modul C
Public Const LC0_MODD As Byte = 4     ' modul D

'************************** maski modulow w mapie **************************
Public Const LC0_MODAMAP As Byte = 1   ' modul A
Public Const LC0_MODBMAP As Byte = 2   ' modul B
Public Const LC0_MODCMAP As Byte = 4   ' modul C
Public Const LC0_MODDMAP As Byte = 8   ' modul D

'************************* kody typow urzadzen *****************************
Public Const LC0_DINPUT As Byte = 1   ' wejsciowy port cyfrowy
Public Const LC0_DOUTPUT As Byte = 2  ' wyjsciowy port cyfrowy
Public Const LC0_AINPUT As Byte = 3   ' przetwornik a/c
Public Const LC0_AOUTPUT As Byte = 4  ' przetwornik c/a
Public Const LC0_CTC As Byte = 5      ' kanal CTC

'*********** maski trybu pracy funkcji ANALOG_INPUT i ANALOG_OUTPUT ********
Public Const LC0_MOD_START As Integer = 1    ' start przetwarzania
Public Const LC0_MOD_NEW_PAR As Integer = 2      ' nowe parametry
Public Const LC0_MOD_SYNCHR  As Integer = 4      ' praca synchroniczna
Public Const LC0_MOD_ASYNCHR As Integer = 0      ' praca asynchroniczna
Public Const LC0_MOD_INTR    As Integer = 8      ' praca bez przerwan
Public Const LC0_MOD_INTR_TYPE As Integer = 16   ' bit trybu przerwan
Public Const LC0_MOD_END_INTR  As Integer = 0    ' przerwanie po koncu
                                     '   przetwarzania
Public Const LC0_MOD_ONE_INTR  As Integer = 16   ' przerwanie po kazdej probce
Public Const LC0_MOD_BLOCK     As Integer = 32   ' praca blokowa
Public Const LC0_MOD_SINGLE    As Integer = 0    ' praca pojedyncza
Public Const LC0_MOD_CYCL      As Integer = 64   ' bufor cykliczny
Public Const LC0_MOD_FILE_W    As Integer = 128 ' zapis do pliku
Public Const LC0_MOD_FILE_R    As Integer = 128 ' odczyt z pliku
Public Const LC0_MOD_MEM_W     As Integer = 256 ' przepisanie do pamieci
Public Const LC0_MOD_EXT_CLK   As Integer = 512 ' zegar zewnetrzny
Public Const LC0_MOD_EXT_MEM   As Integer = 1024 ' pamiec rozszerzona
Public Const LC0_MOD_RAM_SEK   As Integer = 2048 ' sekwencja pomiarowa
Public Const LC0_MOD_PAGE      As Integer = 4096 ' sposb przeprogramowania DMA

'************* wartosci fragmentow bajtu kontrolnego 8253/8254 *************
Public Const CTC_NB As Byte = 0       ' kod naturalny binarny
Public Const CTC_BCD As Byte = 1      ' kod BCD

Public Const CTC_MODE0 As Byte = 0    ' tryb 0
Public Const CTC_MODE1 As Byte = 2    ' tryb 1
Public Const CTC_MODE2 As Byte = 4    ' tryb 2
Public Const CTC_MODE3 As Byte = 6    ' tryb 3
Public Const CTC_MODE4 As Byte = 8    ' tryb 4
Public Const CTC_MODE5 As Byte = 10   ' tryb 5

Public Const CTC_LSB As Byte = &H10    ' tylko mlodszy bajt
Public Const CTC_MSB As Byte = &H20    ' tylko starszy bajt
Public Const CTC_BOTH As Byte = &H30   ' mlodszy - starszy

Public Const CTC_COUNT0 As Byte = &H0   ' licznik 0
Public Const CTC_COUNT1 As Byte = &H40  ' licznik 1
Public Const CTC_COUNT2 As Byte = &H80  ' licznik 2

'************************************************************************************
' funkcje publiczne biblioteki DLL obsugujce moduy serii AMBEX LC
'************************************************************************************
Public Declare Sub LC0_ModuleInit Lib "lc1108a" (ByRef param As lc0_init)
Public Declare Sub LC0_GetTotalConf Lib "lc1108a" (ByRef param As lc0_total)
Public Declare Sub LC0_GetModule Lib "lc1108a" (ByRef param As lc0_module)
Public Declare Sub LC0_GetInfo Lib "lc1108a" (ByRef param As lc0_info)
Public Declare Sub LC0_SetClock Lib "lc1108a" (ByRef param As lc0_clock)
Public Declare Sub LC0_SetVoltage Lib "lc1108a" (ByRef param As lc0_volt)
Public Declare Sub LC0_SetTime Lib "lc1108a" (ByRef param As lc0_time)
Public Declare Sub LC0_Wait Lib "lc1108a" (ByRef param As lc0_swait)
Public Declare Sub LC0_Interrupt Lib "lc1108a" (ByRef param As lc0_sinterrupt)
Public Declare Sub LC0_DigitalIn Lib "lc1108a" (ByRef param As lc0_digital_in)
Public Declare Sub LC0_DigitalOut Lib "lc1108a" (ByRef param As lc0_digital_out)
Public Declare Sub LC0_CTCWrite Lib "lc1108a" (ByRef param As lc0_ctc_write)
Public Declare Sub LC0_CTCRead Lib "lc1108a" (ByRef param As lc0_ctc_read)
Public Declare Sub LC0_Leave Lib "lc1108a" (ByRef param As lc0_sleave)
Public Declare Sub LC0_Config Lib "lc1108a" (ByRef param As lc0_sconfig)
Public Declare Sub LC0_Break Lib "lc1108a" (ByRef param As lc0_sbreak)
Public Declare Sub LC0_DataTransmit Lib "lc1108a" (ByRef param As lc0_transmit)
Public Declare Sub LC0_MemoryUse Lib "lc1108a" (ByRef param As lc0_memory)
Public Declare Sub LC0_AnalogIn Lib "lc1108a" (ByRef param As lc0_analog_in)
Public Declare Sub LC0_AnalogOut Lib "lc1108a" (ByRef param As lc0_analog_out)



