Attribute VB_Name = "Global"
' deklaracja funkcji z biblioteki dodatkowej "extdll.dll"

' uzyskanie adresu zmiennej Integer podanej jako argument wywoania
Public Declare Function PointerToLong Lib "extdll" (ByRef ptr As Integer) As Long

' publiczne deklaracje i definicje

Public Const BUFLEN = 8 * 20          ' dlugosc bufora
Public Const SAMPLES = 20             ' liczba probek
Public Const CHANNELS = 8             ' liczba kanalow

'******************** deklaracje zmiennych *********************************
                ' rekordy opisu poszczegolnych zlecen
Public s_init  As lc0_init
Public s_total As lc0_total
Public s_module As lc0_module
Public s_info As lc0_info
Public s_break As lc0_sbreak
Public s_analog_in As lc0_analog_in
Public s_analog_out As lc0_analog_out
Public s_leave As lc0_sleave

Public buf(1 To BUFLEN) As Integer     'bufor pomiarowy
Public modulenum As Integer            'numer badanego modulu
Public koniec As Integer
Public bufnum As Integer
Public tstart As Byte
Public step As Byte    ' nr kolejnego kroku testu
Public enddet As Byte

' opisy kodw bdw driver'a
Public Const ErrNumber = 42
Public Const WarNumber = 5
Public Const ExtNumber = 10
Public DriverErrors(1 To ErrNumber) As String
Public DriverWarnings(1 To WarNumber) As String
Public DriverExt(1 To ExtNumber) As String

'*************************************************************************************
' definicje procedur
'*************************************************************************************
' inicjacja zmiennych globalnych
Sub InitProgram()
    s_init.LC0_CODE = MODULE_INIT
    s_total.LC0_CODE = GET_TOTAL_CONFIGURATION
    s_module.LC0_CODE = GET_MODULE_CONFIGURATION
    s_info.LC0_CODE = GET_INFO
    s_break.LC0_CODE = BREAK
    s_analog_in.LC0_CODE = ANALOG_INPUT
    s_leave.LC0_CODE = LEAVE_DRIVER
    koniec = 0
    step = 0
    sekptr = 0
    ' opisy kodw bdw driver'a
                        ' LC0_UNKN_FUNC    -1
    DriverErrors(1) = "LC0_UNKN_FUNC: Nieznany kod funkcji"
                        ' LC0_NO_MODULE    -2
    DriverErrors(2) = "LC0_NO_MODULE: Bdny numer moduu"
                        ' LC0_BAD_DEV_TYP  -3
    DriverErrors(3) = "LC0_BAD_DEV_TYP: Brak urzdze danego typu"
                        ' LC0_NONEX_DEV    -4
    DriverErrors(4) = "LC0_NONEX_DEV: Bldny numer urzdzenia"
                        ' LC0_BAD_FREQ     -5
    DriverErrors(5) = "LC0_BAD_FREQ: Bdny okres"
                        'LC0_BAD_RANGE    -6
    DriverErrors(6) = "LC0_BAD_RANGE: Bldny zakres napic"
                        ' LC0_NO_OPER      -7
    DriverErrors(7) = "LC0_NO_OPER: Brak operacji w toku"
                        ' LC0_BAD_MARGIN   -8
    DriverErrors(8) = "LC0_BAD_MARGIN: Bldna dugo marginesu pocztkowego"
                        ' LC0_BAD_BUF_ADR  -9
    DriverErrors(9) = "LC0_BAD_BUF_ADR: Bdny adres bufora"
                        ' LC0_BAD_BUF_LEN     -10
    DriverErrors(10) = "LC0_BAD_BUF_LEN: Bdna dlugo bufora"
                        ' LC0_DEV_BUSY        -11
    DriverErrors(11) = "LC0_DEV_BUSY: Urzdzenie zajte"
                        ' LC0_BAD_PER         -12
    DriverErrors(12) = "LC0_BAD_PER: Za krtki okres prbkowania"
                        ' LC0_BAD_CHAN_N      -13
    DriverErrors(13) = "LC0_BAD_CHAN_N: Bldna liczba kanaw"
                        ' LC0_BAD_CHAN        -14
    DriverErrors(14) = "LC0_BAD_CHAN: Bldny numer kanau"
                        ' LC0_BROKEN          -15
    DriverErrors(15) = "LC0_BROKEN: Przetwarzanie przerwane funkcj BREAK"
                        ' LC0_INTR_NOT_INST   -16
    DriverErrors(16) = "LC0_INTR_INST: Procedura obsugi przerwania nie jest zainstalowana"
                        ' LC0_ILL_START_CODE  -17
    DriverErrors(17) = "LC0_ILL_START_CODE: Nielegalny sposob startu"
                        ' LC0_ILL_STOP_CODE   -18
    DriverErrors(18) = "LC0_ILL_STOP_CODE: Nielegalny sposob stopu"
                        ' LC0_BAD_PROC        -19
    DriverErrors(19) = "LC0_BAD_PROC: Bdny adres procedury obsugi przerwania"
                        ' LC0_TOO_LONG_MARG   -20
    DriverErrors(20) = "LC0_TOO_LONG_MARG: Za dugi margines pocztkowy"
                        ' LC0_ILL_START       -21
    DriverErrors(21) = "LC0_ILL_START: Bdne parametry warunku startu"
                        ' LC0_ILL_STOP        -22
    DriverErrors(22) = "LC0_ILL_STOP: Bdne parametry warunku stopu"
                        ' LC0_BAD_MNUM        -23
    DriverErrors(23) = "LC0_BAD_MNUM: Bdny numer pierwszej probki"
                        ' LC0_NOT_SUPPORTED   -24
    DriverErrors(24) = "LC0_NOT_SUPPORTED: Funkcja nie jest realizowana"
                        ' LC0_BAD_CTC_MODE    -25
    DriverErrors(25) = "LC0_BAD_CTC_MODE: Bdny tryb pracy CTC"
                        ' LC0_NO_PARAMS       -26
    DriverErrors(26) = "LC0_NO_PARAMS: Nie podano parametrw przetwarzania"
                        ' LC0_OVERRUN         -27
    DriverErrors(27) = "LC0_OVERRUN: Bd OVERRUN"
                        ' LC0_NO_DMA          -28
    DriverErrors(28) = "LC0_NO_DMA: Urzdzenie nie jest podczone do DMA"
                        ' LC0_NO_IRQ          -29
    DriverErrors(29) = "LC0_NO_IRQ: Z moduem nie jest zwizane adne przerwanie"
                        ' LC0_NOT_FULLY_SUP   -30
    DriverErrors(30) = "LC0_NOT_FULLY_SUP: Funkcja w opracowaniu"
                        ' LC0_NO_EXTMEM       -31
    DriverErrors(31) = "LC0_NO_EXTMEM: Brak pamici dodatkowej"
                        ' LC0_NO_SEC_FREQ     -32
    DriverErrors(32) = "LC0_NO_SEC_FREQ: Modu ma tylko jedn czestotliwo"
                        ' LC0_INTR_INST       -33
    DriverErrors(33) = "LC0_INTR_INST: Procedura obsugi przerwania ju zainstalowana"
                        ' LC0_BAD_PER2        -34
    DriverErrors(34) = "LC0_BAD_PER2: Bdna wielokrotno okresu prbkowania"
                        ' LC0_BAD_MODE        -35
    DriverErrors(35) = "LC0_BAD_MODE: Bdny tryb pracy"
                        ' LC0_BAD_EXTMEM      -36
    DriverErrors(36) = "LC0_BAD_EXTMEM: Bdny adres bufora w pamici rozszerzonej"
                        ' LC0_NOT_PROGRAMMED  -37
    DriverErrors(37) = "LC0_CTC_NOT_PROGRAMMED: Zapis licznika przy niezaprogramowanym trybie pracy"
                        ' LC0_REJECTED        -38
    DriverErrors(38) = "LC0_REJECTED: Za duo jednoczesnych odwoa do driver'a"
                        ' LC0_BAD_CONFIG            -39
    DriverErrors(39) = "LC0_BAD_CONFIG: Bdny plik konfiguracyjny "
                        ' LC0_NOT_INIT              -40
    DriverErrors(40) = "LC0_NOT_INIT: Modu nie by zainicjowany"
                        ' LC0_NO_DMA_TRANS              -41
    DriverErrors(41) = "LC0_NO_DMA_TRANS: Nie jest moliwy blokowy transfer DMA"
                        ' LC0_BAD_RAM_SEK           -42
    DriverErrors(42) = "LC0_BAD_RAM_SEK: Bdne parametry sekwencji pomiarowej"

    ' opisy kodw ostrzee driver'a
                        ' LC0_NON_EX_MOD 1
    DriverWarnings(1) = "LC0_NON_EX_MOD: Zazadano inicjalizacji nieistniejacych modulow"
                        ' LC0_OTHER_LEN    2
    DriverWarnings(2) = "LC0_OTHER_LEN: Przepisano mniej probek niz zazadano"
                        ' LC0_PREMATURE_END    3
    DriverWarnings(3) = "LC0_PREMATURE_END: Zakonczenie operacji z powodu przepelnienia bufora"
                        ' LC0_IN_PROGRESS      4
    DriverWarnings(4) = "LC0_IN_PROGRESS: Badana transmisja jeszcze trwa"
                        ' LC0_IS_INIT              5
    DriverWarnings(5) = "LC0_IS_INIT: Modu jest ju zainicjowany "

    ' opisy kodw informacji dodatkowych o bdach  driver'a
    
                        ' LC0_E_NO_MODULE  -1
    DriverExt(1) = "LC0_E_NO_MODULE: Nie ma takiego modulu"
                        ' LC0_E_NONEX_DEV  -2
    DriverExt(2) = "LC0_E_NONEX_DEV: Nie istnieje urzadzenie o tym numerze"
                        ' LC0_E_BAD_CHAN   -3
    DriverExt(3) = "LC0_E_BAD_CHAN: Numer nieistniejacego kanalu"
                        ' LC0_E_BAD_TIME   -4
    DriverExt(4) = "LC0_E_BAD_TIME: Zly odcinek czasu"
                        ' LC0_E_BAD_DATE   -5
    DriverExt(5) = "LC0_E_BAD_DATE: Zla specyfikacja daty"
                        ' LC0_E_BAD_THRE   -6
    DriverExt(6) = "LC0_E_BAD_THRE: Bledny prog wyzwalania analogowego"
                        ' LC0_E_BROKEN_WAIT    -7
    DriverExt(7) = "LC0_E_BROKEN_WAIT: Przerwanie w trakcie oczekiwania na warunek startu"
                        ' LC0_E_BROKEN_RUN -8
    DriverExt(8) = "LC0_E_BROKEN_RUN: Przerwanie w trakcie przetwarzania"
                        ' LC0_E_BAD_LEN        -9
    DriverExt(9) = "LC0_E_BAD_LEN: Zadeklarowano za duzo probek"
                        ' LC0_E_MOD_UNABLE     -10
    DriverExt(10) = "LC0_E_MOD_UNABLE: Modu zajty lub nie zainicjowany "
End Sub
'****************************************************************************
' Procedura Quit()

' Przeznaczenie : Wykonanie funkcji LEAVE_DRIVER

' *****************************************************************************
Sub quit()
 Call LC0_Leave(s_leave)
End Sub

'*************************************************************************
' Przeznaczenie:
'   Rozpoznanie konfiguracji badanego modulu.
' Sposob:
'   Przez wykorzystanie funkcji driver'a GET_TOTAL_CONFIGURATION,
'   GET_MODULE_CONFIGURATION, GET_INFO.
' Uwagi:
'   Funkcja nadaje wartosc zmiennej modulenum (numer badanego modulu)
'   wypelnia struktury total, module, info i inicjalizuje zainstalowane
'    moduly.
'*************************************************************************
Sub askdriver()
 ' GET_TOTAL_CONFIGURATION
 Call LC0_GetTotalConf(s_total)
 
 ' inicjalizacja zainstalowanych modulow
 s_init.LC0_IMODULE = s_total.LC0_TONF And &HF
 Call LC0_ModuleInit(s_init)
 
 ' sprawdzenie, ktory modul jest zainstalowany: A, B, C czy D
 For modulenum = 1 To 4
  If ((s_total.LC0_TONF And (2 ^ (modulenum - 1))) <> 0) Then
   GoTo lab1
  End If
 Next modulenum
 
 ' spytanie o konfiguracje modulu : GET_MODULE_CONFIGURATION
lab1: s_module.LC0_MMODULE = modulenum
 Call LC0_GetModule(s_module)
 
 'spytanie o konfiguracje toru a/c
 s_info.LC0_GMODULE = modulenum
 s_info.LC0_GTYPE = LC0_AINPUT
 s_info.LC0_GNUM = 1
 Call LC0_GetInfo(s_info)
End Sub
'*************************************************************************
' Funkcja : installbreak
' Przeznaczenie:
'   Zainstalowanie procedury obslugi przerwania generowanego przez
'   Ctrl-Break.
' Sposob:
'   Przez wywolanie funkcji BREAK.
'*************************************************************************
Sub installbreak()
 s_break.LC0_BMODE = LC0_BREAK_INST
 s_break.LC0_BPROC = 0              ' procedura wewntrzna
 Call LC0_Break(s_break)
End Sub

'***************************************************************************
' Przeznaczenie:
'   Wypisanie komunikatow o bledzie / ostrzezeniu / dodatkowej informacji
'   bledzie.
' Parametry:
'   status   - LC0_STATUS
'   err_stat - LC0_ERR_STAT
'***************************************************************************
Sub drivererror(status As Byte, err_stat As Byte)
 Dim title$
 Dim error$
 If (status > 0) And (status <= &H7F) Then
  title = "Ostrzeenie"
  error = DriverWarnings(status)
 Else
  title = "Bd"
  code% = 256 - status
  error = DriverErrors(code%)
 End If
 result = MsgBox("Kod odpowiedzi driver'a DLL : " + error, 0, title)
 If err_stat <> 0 Then
  code% = 256 - err_stat
  error = DriverExt(code%)
  result = MsgBox("Kod informacji dodatkowych  driver'a DLL : " + error, 0, "Informacje dodatkowe")
 End If
End Sub
'*************************************************************************
' Przeznaczenie:
'   Wykonanie transmisji blokowej.
' Sposob:
'   Przez wykonanie funkcji ANALOG_INPUT.
' Parametry:
'   start - typ warunku startu
' Wartosc:
' Uwagi:
'   Funkcja wywolujaca musi ustawic okres probkowania i parametry warunku
'   startu.
'*************************************************************************
Sub transmission(start As Byte)
 
 s_analog_in.LC0_AMODULE = modulenum
 s_analog_in.LC0_ANUM = 1
 s_analog_in.LC0_AMODE = LC0_MOD_START Or LC0_MOD_NEW_PAR Or LC0_MOD_SYNCHR Or LC0_MOD_BLOCK
 
 s_analog_in.LC0_ACHAN = CHANNELS
 s_analog_in.LC0_ABMAR = 0
 s_analog_in.LC0_AEMAR = 0
 
 ' stop po zmierzeniu okreslonej liczby
 ' probek
 s_analog_in.LC0_ASTST = start + LC0_ZSAMPLES
                 ' adres bufora na prbki
 s_analog_in.LC0_AADDR = PointerToLong(buf(1))
 s_analog_in.LC0_ALEN = BUFLEN ' dlugosc bufora
                 ' calkowita liczba probek
 s_analog_in.LC0_ASTOP.SAMPLES = SAMPLES * CHANNELS
 Call LC0_AnalogIn(s_analog_in)           ' ANALOG_INPUT
 If s_analog_in.LC0_STATUS <> LC0_OK Then
  enddet = 1
  Call drivererror(s_analog_in.LC0_STATUS, s_analog_in.LC0_ERR_STAT)
 Else
  enddet = 0 '  wyswietli rezultat
 End If
End Sub

'*************************************************************************
' Przeznaczenie:
'   Wykonanie poprawnej transmisji blokowej i wyswietlenie zmierzonych
'   wartosci.
' Sposob:
'   Przez wykonanie funkcji transmission.
'*************************************************************************
Sub blocktransmission()
 tstart = LC0_SIMMED
 s_analog_in.LC0_APER = s_info.LC0_GMINP(CHANNELS) + 200
 Call transmission(LC0_SIMMED)
End Sub
'*************************************************************************
' Przeznaczenie:
'   Wykonanie blednej transmisji blokowej.
' Sposob:
'   Przez wykonanie funkcji ANALOG_INPUT z okresem probkowania mniejszym
'   niz minimalny wskazany przez driver.
'*************************************************************************
Sub failblocktransmission()
 tstart = LC0_SIMMED
 s_analog_in.LC0_APER = s_info.LC0_GMINP(CHANNELS) - 1
 Call transmission(LC0_SIMMED)
End Sub

'*************************************************************************
' Przeznaczenie:
'   Wykonanie poprawnej transmisji blokowej ale przerwanej przez operatora
'   (Ctrl-Break) w trakcie czekania na spelnienie warunku startu.
' Sposob:
'   Przez wykonanie funkcji ANALOG_INPUT z warunkiem startu LC0_STIME
'   (start po okreslonym czasie) i parametrem tego warunku - 1000s.
'*************************************************************************
Sub interruptedbefore()
 tstart = LC0_STIME
 s_analog_in.LC0_APER = s_info.LC0_GMINP(CHANNELS)
 ' ustawienie wartoci 1000 s = 3E8 (Hex) zgodnie z zasad kodowania zmiennych Long
 s_analog_in.LC0_ASTART.Parametr(1) = &HE8  ' LSB
 s_analog_in.LC0_ASTART.Parametr(2) = &H3
 s_analog_in.LC0_ASTART.Parametr(3) = &H0
 s_analog_in.LC0_ASTART.Parametr(4) = &H0   ' MSB
 Call transmission(LC0_STIME)
End Sub
'*************************************************************************
' Przeznaczenie:
'   Wykonanie pomiaru bloku probek za pomoca tranmsisji programowej, przy
'   czym caly blok ma byc zmierzony po 5s od startu.
' Sposob:
'   Przez wykonanie funkcji ANALOG_INPUT.
' Parametry:
' Wartosc:
'*************************************************************************
Sub singletransmission()
 tstart = LC0_STIME
 s_analog_in.LC0_AMODULE = modulenum
 s_analog_in.LC0_ANUM = 1
 s_analog_in.LC0_AMODE = LC0_MOD_START Or LC0_MOD_NEW_PAR Or LC0_MOD_SINGLE
                ' praca wielokanalowa, CHANNELS kanalow
 s_analog_in.LC0_ACHAN = CHANNELS
                ' adres bufora na prbki
 s_analog_in.LC0_AADDR = PointerToLong(buf(1))
 s_analog_in.LC0_ALEN = BUFLEN ' dlugosc bufora
 s_analog_in.LC0_ASTST = LC0_STIME + LC0_ZSAMPLES
                ' start po 5 sekundach
 s_analog_in.LC0_ASTART.Parametr(1) = 5
 s_analog_in.LC0_ASTART.Parametr(2) = 0
 s_analog_in.LC0_ASTART.Parametr(3) = 0
 s_analog_in.LC0_ASTART.Parametr(4) = 0
                ' calkowita liczba probek
 s_analog_in.LC0_ASTOP.SAMPLES = SAMPLES * CHANNELS
 
 Call LC0_AnalogIn(s_analog_in)           ' ANALOG_INPUT
 If s_analog_in.LC0_STATUS <> LC0_OK Then
  enddet = 1
  Call drivererror(s_analog_in.LC0_STATUS, s_analog_in.LC0_ERR_STAT)
 Else
  enddet = 0 '  wyswietli rezultat
 End If
End Sub
'*************************************************************************
' Przeznaczenie:
'   Wyslanie pojedynczej wartosci na przetwornik CA.
' Sposob:
'   Przez wykonanie funkcji ANALOG_OUTPUT.
' Parametry:
' Wartosc:
' Uwagi:
'*************************************************************************
Sub singlewrite()
 Dim val As Integer ' bufor na prbk
 tstart = LC0_SIMMED
 If s_module.LC0_MIDA = 0 Then
  result = MsgBox("Karta nie posiada zainstalowanych przetwornikow CA", 0, "Sygna")
  Exit Sub
 End If
 val = 4095
 s_analog_out.LC0_NMODULE = modulenum
 s_analog_out.LC0_NNUM = 1
 s_analog_out.LC0_NMODE = LC0_MOD_START Or LC0_MOD_NEW_PAR Or LC0_MOD_SYNCHR
                    ' praca jednokanalowa
 s_analog_out.LC0_NCHAN = &H80 Or &H1
 s_analog_out.LC0_NADDR = PointerToLong(val)
                    '   daleki adres
 s_analog_out.LC0_NLEN = 1  ' dlugosc bufora tylko na jedna wartosc
 s_analog_out.LC0_NSTST = LC0_SIMMED + LC0_ZSAMPLES
                    ' ilo prbek do zmioerzenia
 s_analog_out.LC0_NSTOP.SAMPLES = 1
                    ' ANALOG_OUTPUT
 Call LC0_AnalogOut(s_analog_out)
 If s_analog_out.LC0_STATUS <> LC0_OK Then
  Call drivererror(s_analog_out.LC0_STATUS, s_analog_out.LC0_ERR_STAT)
 End If
 enddet = 1
End Sub
