/* WSMP1108.C ******************************************************************
	Program przykadowy pokazujcy sposb wykorzystania drivera moduw
	serii LC   firmy AMBEX.
	Sposb doaczenia biblioteki DLL : statycznie poprzez plik DEF			   */
/****************************************************************************
  Program korzysta ze standardowych funkcji API Windows 3.1 .
  W katalogu zawierajacym standardowe naglowki C musz sie znajdowac pliki:
  AMBEX-LC.H  - plik nagwkowy drivera ,
  RESOURCE.H  - plik nagwkowy  zasobw programu,
  WSMP1108.RC - plik zasobw	,
  WSMP1108.DEF - plik definicyjny moduu

  Pliki :
  - AMBEX.INI  - plik konfiguracyjny moduw serii LC ,
  - LC1108A.DLL - driver (biblioteka DLL) do kart LC-011-0812 ,
  powinny znajdowa si w jednym z katalogw ze standardowej cieki przeszu-
  kiwa Windows (wedug kolejnoci przeszukiwania) :
  1. katalog systemowy WINDOWS ,
  2. katalog WINDOWS\SYSTEM ,
  3. biecy katalog aplikacji ,
  4. katalog znajdujcy si na ciece przeszukiwa PATH .

  Opcje kompilatora (Visual C++)
  - struct memner data alingment  : 1 byte ,
  - memory model	  : small,medium,far,
  - entry/exit code : .protected mode aplication  lub  real mode non-callback

  UWAGA:
  Pomiary z wykorzystaniem blokowych transferw DMA s moliwe wwczas,gdy
  WINDOWS jest uruchomione w trybie Enhanced i s dostpne dla komputerw
  wyposaonych w procesory "386" i wysze , dla tej wersji biblioteki .
  Maksymaln wielko bufora DMA naley okreli poprzez ustawienie parametru
  "DMABufferSize=xx" sekcji [386Enh] w pliku "SYSTEM.INI" (domylnie 16kB),
  gdzie "xx" : rozmiar bufora w kB .                                */
/***************************************************************************/
#include <windows.h>		 /* funkcje API Windows 					   */
#include <stdio.h>		/* wyswietlanie                            		   */
#include <string.h>		/* funkcja strcat								   */
#include <stdlib.h>		/* funkcja exit                            */
#include <dos.h>			/* FP_SEG MK_FP */
#include "ambex-lc.h"		/* struktury danych , definicje stalych i funkcji */
									/* do komunikacji z driver'em */
/*****************************************************************************/
/* deklaracje procedur Windows												*/
/*****************************************************************************/
#include "resource.h"

int PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);
BOOL InitApplication(HANDLE);
BOOL InitInstance(HANDLE, int);
long FAR PASCAL __export MainWndProc(HWND, UINT, WPARAM, LPARAM);
/******************** deklaracje procedur **********************************/
void  	askdriver(void) ;								
void	blocktransmission(void);
int		displaybuf(int *buf, int c, int s,HDC,RECT);
void	displayconfiguration(HDC,RECT);
void  	PressOrClickAny(HDC,RECT);
int 	displaytext(HDC,RECT,unsigned char);
void	drivererror(char status, char err_stat);
void	failblocktransmission(void);
void	installbreak(void);
void	interruptedbefore(void);
void	breakproces(void);
void	quit(void);                                      
void	singletransmission(void);
void	transmission(unsigned char start);
void 	singlewrite(void);
void FAR  my_break(void);
void drawscreen(void);
void GoToLine(RECT * , HDC ) ;


#define MY_MESSAGE WM_USER +1

/******************** definicje stalych ************************************/
#define	TRUE		1
#define	FALSE		0
#define	BUFLEN		(8 * 20)		/* dlugosc bufora          */
#define	SAMPLES		20				/* liczba probek           */
#define	CHANNELS	8					/* liczba kanalow          */

/******************** deklaracje zmiennych *********************************/

int	LCinterrupt;					/* numer przerwania driver'a               */
				/* rekordy opisu poszczegolnych zlecen     */
struct	lc0_init			s_init        = {MODULE_INIT};
struct	lc0_total		s_total       = {GET_TOTAL_CONFIGURATION};
struct	lc0_module		s_module      = {GET_MODULE_CONFIGURATION};
struct	lc0_info			s_info        = {GET_INFO};
struct	lc0_break		s_break       = {BREAK};
struct	lc0_analog_in	s_analog_in   = {ANALOG_INPUT};
struct	lc0_analog_out	s_analog_out  = {ANALOG_OUTPUT};
struct	lc0_leave		s_leave       = {LEAVE_DRIVER};
struct	lc0_interrupt		s_interr   = {INTERRUPT_SERVICE};
int	buf[BUFLEN];	/* bufor pomiarowy */
int	modulenum;		/* numer badanego modulu                   */
int	koniec = 0;
int	bufnum = 0;
int	huge *buf1;
int	huge *buf2;
int	sstat;                  /* slowo komunikacyjne dla funkcji obslugi */
int   paintnum = 0 ;				/* nr sekcji do wywietlenia w komunikacie WM_PAIN*/
										/* oraz czci przykadowej sesji pomiarowej */
int   paintdet = 0 ;
int   enddet	= 0 ;
unsigned char tstart ;

HWND       hWnd;               /* uchwyt do gwnego okna programu */
HANDLE     hInst;              /* deskryptor biecego zadania*/
HANDLE	  hDriverInst	  ;		 /* desktyptor drivera				*/

				/* ------- teksty bldw                   */
char	*DriverErrors[] =
{
						/* LC0_UNKN_FUNC	-1 */
"LC0_UNKN_FUNC: Nieznany kod funkcji",
						/* LC0_NO_MODULE	-2 */
"LC0_NO_MODULE: Bdny numer moduu",
						/* LC0_BAD_DEV_TYP	-3 */
"LC0_BAD_DEV_TYP: Brak urzdze danego typu",
						/* LC0_NONEX_DEV	-4 */
"LC0_NONEX_DEV: Bldny numer urzdzenia",
						/* LC0_BAD_FREQ		-5 */
"LC0_BAD_FREQ: Bdny okres",
						/* LC0_BAD_RANGE	-6 */
"LC0_BAD_RANGE: Bldny zakres napic",
						/* LC0_NO_OPER		-7 */
"LC0_NO_OPER: Brak operacji w toku",
						/* LC0_BAD_MARGIN	-8 */
"LC0_BAD_MARGIN: Bldna dugo marginesu pocztkowego",
						/* LC0_BAD_BUF_ADR	-9 */
"LC0_BAD_BUF_ADR: Bdny adres bufora",
						/* LC0_BAD_BUF_LEN     -10 */
"LC0_BAD_BUF_LEN: Bdna dlugo bufora",
						/* LC0_DEV_BUSY	       -11 */
"LC0_DEV_BUSY: Urzdzenie zajte",
						/* LC0_BAD_PER	       -12 */
"LC0_BAD_PER: Za krtki okres prbkowania",
						/* LC0_BAD_CHAN_N      -13 */
"LC0_BAD_CHAN_N: Bldna liczba kanaw",
						/* LC0_BAD_CHAN	       -14 */
"LC0_BAD_CHAN: Bldny numer kanau",
						/* LC0_BROKEN 	       -15 */
"LC0_BROKEN: Przetwarzanie przerwane funkcj BREAK",
						/* LC0_INTR_NOT_INST   -16 */
"LC0_INTR_INST: Procedura obsugi przerwania nie jest zainstalowana",
						/* LC0_ILL_START_CODE  -17 */
"LC0_ILL_START_CODE: Nielegalny sposob startu",
						/* LC0_ILL_STOP_CODE   -18 */
"LC0_ILL_STOP_CODE: Nielegalny sposob stopu",
						/* LC0_BAD_PROC	       -19 */
"LC0_BAD_PROC: Bdny adres procedury obsugi przerwania",
						/* LC0_TOO_LONG_MARG   -20 */
"LC0_TOO_LONG_MARG: Za dugi margines pocztkowy",
						/* LC0_ILL_START       -21 */
"LC0_ILL_START: Bdne parametry warunku startu",
						/* LC0_ILL_STOP	       -22 */
"LC0_ILL_STOP: Bdne parametry warunku stopu",
						/* LC0_BAD_MNUM	       -23 */
"LC0_BAD_MNUM: Bdny numer pierwszej probki",
						/* LC0_NOT_SUPPORTED   -24 */
"LC0_NOT_SUPPORTED: Funkcja nie jest realizowana",
						/* LC0_BAD_CTC_MODE    -25 */
"LC0_BAD_CTC_MODE: Bdny tryb pracy CTC",
						/* LC0_NO_PARAMS       -26 */
"LC0_NO_PARAMS: Nie podano parametrw przetwarzania",
						/* LC0_OVERRUN	       -27 */
"LC0_OVERRUN: Bd OVERRUN",
						/* LC0_NO_DMA	       -28 */
"LC0_NO_DMA: Urzdzenie nie jest podczone do DMA",
						/* LC0_NO_IRQ	       -29 */
"LC0_NO_IRQ: Z moduem nie jest zwizane adne przerwanie",
						/* LC0_NOT_FULLY_SUP   -30 */
"LC0_NOT_FULLY_SUP: Funkcja w opracowaniu",
						/* LC0_NO_EXTMEM       -31 */
"LC0_NO_EXTMEM: Brak pamici dodatkowej",
						/* LC0_NO_SEC_FREQ     -32 */
"LC0_NO_SEC_FREQ: Modu ma tylko jedn czestotliwo",
						/* LC0_INTR_INST       -33 */
"LC0_INTR_INST: Procedura obsugi przerwania ju zainstalowana",
						/* LC0_BAD_PER2	       -34 */
"LC0_BAD_PER2: Bdna wielokrotno okresu prbkowania",
						/* LC0_BAD_MODE	       -35 */
"LC0_BAD_MODE: Bdny tryb pracy",
						/* LC0_BAD_EXTMEM      -36 */
"LC0_BAD_EXTMEM: Bdny adres bufora w pamici rozszerzonej",
						/* LC0_NOT_PROGRAMMED  -37 */
"LC0_CTC_NOT_PROGRAMMED: Zapis licznika przy niezaprogramowanym trybie pracy",
						/* LC0_REJECTED	       -38 */
"LC0_REJECTED: Za duo jednoczesnych odwoa do driver'a",
						/* LC0_BAD_CONFIG			 -39 */
"LC0_BAD_CONFIG: Bdny plik konfiguracyjny ",
						/* LC0_NOT_INIT 			 -40 */
"LC0_NOT_INIT: Modu nie by zainicjowany" ,          
						/* LC0_NO_DMA_TRANS 		 -41 */
"LC0_NO_DMA_TRANS : Niemozliwy transfer danych przez DMA",
};

				/* ------ teksty ostrzezen                */
char	*DriverWarnings[] =
{
						/* LC0_NON_EX_MOD	1 */
"LC0_NON_EX_MOD: Zazadano inicjalizacji nieistniejacych modulow",
						/* LC0_OTHER_LEN	2 */
"LC0_OTHER_LEN: Przepisano mniej probek niz zazadano",
						/* LC0_PREMATURE_END	3 */
"LC0_PREMATURE_END: Zakonczenie operacji z powodu przepelnienia bufora",
						/* LC0_IN_PROGRESS      4 */
"LC0_IN_PROGRESS: Badana transmisja jeszcze trwa",
						/* LC0_IS_INIT				5 */
"LC0_IS_INIT: Modu jest ju zainicjowany ",

};

				/* ------- teksty informacji dodatkowych  */
char	*DriverAdditionalErrors[] =
{
						/* LC0_E_NO_MODULE	-1 */
"LC0_E_NO_MODULE: Nie ma takiego modulu",
						/* LC0_E_NONEX_DEV	-2 */
"LC0_E_NONEX_DEV: Nie istnieje urzadzenie o tym numerze",
						/* LC0_E_BAD_CHAN	-3 */
"LC0_E_BAD_CHAN: Numer nieistniejacego kanalu",
						/* LC0_E_BAD_TIME	-4 */
"LC0_E_BAD_TIME: Zly odcinek czasu",
						/* LC0_E_BAD_DATE	-5 */
"LC0_E_BAD_DATE: Zla specyfikacja daty",
						/* LC0_E_BAD_THRE	-6 */
"LC0_E_BAD_THRE: Bledny prog wyzwalania analogowego",
						/* LC0_E_BROKEN_WAIT	-7 */
"LC0_E_BROKEN_WAIT: Przerwanie w trakcie oczekiwania na warunek startu",
						/* LC0_E_BROKEN_RUN	-8 */
"LC0_E_BROKEN_RUN: Przerwanie w trakcie przetwarzania",
						/* LC0_E_BAD_LEN        -9 */
"LC0_E_BAD_LEN: Zadeklarowano za duzo probek",
						/* LC0_E_MOD_UNABLE		-10 */
"LC0_E_MOD_UNABLE: Modu zajty lub nie zainicjowany ",
};




/****************************************************************************

	Funkcja:   WinMain(HANDLE, HANDLE, LPSTR, int)

	Przeznaczenie: Inicjacja aplikacji , okna gwnego , wczytanie drivera

	Parametry wywoania :

			 hInstance			- deskryptor zadania
			 hPrevInstance    - deskryptor poprzedniego zadania
			 lpCmdLine			- string z parametrami wywoania
			 nCmdShow			- sposb wywietlenia okna

****************************************************************************/

int PASCAL WinMain
			  (HANDLE hInstance,HANDLE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
	MSG msg;

	if (!hPrevInstance)
	 {
	  if (!InitApplication(hInstance))				/* rejestracja klasy okna */
		 return (FALSE);
	 }

	if (!InitInstance(hInstance, nCmdShow))      /* aktywacja okna */
		 return (FALSE);
  

	  MessageBox(hWnd,"Zamknij by rozpocz przykadow sesj pomiarow","Informacja",MB_OK);
	  paintnum = 1;
	  PostMessage(hWnd,MY_MESSAGE,0,0);

	/* ptla obsugi komunikatw */

	while (GetMessage(&msg, NULL, NULL, NULL))
	 {
	  TranslateMessage(&msg);
	  DispatchMessage(&msg);
	 }

	/* wykonanie funkcji LEAVE_DRIVER i zwolnienie drivera  */

	  quit();

	return (msg.wParam);
}


/****************************************************************************

	Funkcja:   InitApplication(HANDLE)

	Przeznaczenie: Inicjacja i rejestracja klasy okna gwnego programu .

	Rezultat:    Status funkcji  RegisterClass(); !=0 gdy O.K.

****************************************************************************/

BOOL InitApplication(HANDLE hInstance)
{
	WNDCLASS wc;

	wc.style = NULL;
	wc.lpfnWndProc = MainWndProc;					/*procedura okienkowa */
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = COLOR_WINDOW+1;
	wc.lpszMenuName ="MainMenu";
	wc.lpszClassName = "DemoDriverWClass";

	return (RegisterClass(&wc));
}


/****************************************************************************

	Funkcja:   InitInstance(HANDLE, int)

	Przeznaczenie: Stworzenie okna gwnego programu

	Rezultat:    Status funkcji CreateWindow() ; != gdy O.K.

****************************************************************************/

BOOL InitInstance(HANDLE hInstance,int nCmdShow)
{

	hInst = hInstance;

	/* stworzenie okna gownwgo */

	hWnd = CreateWindow(
		 "DemoDriverWClass",
		 "Przykad uycia biblioteki DLL Windows do kart AMBEX serii LC",
		 WS_OVERLAPPEDWINDOW,
		 CW_USEDEFAULT,
		 CW_USEDEFAULT,
		 CW_USEDEFAULT,
		 CW_USEDEFAULT,
		 NULL,
		 NULL,
		 hInstance,
		 NULL
		 );

	if (!hWnd)
		 return (FALSE);
	/*wywietlenie okna */

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return (TRUE);

}

/****************************************************************************

	Funkcja:   MainWndProc(HWND, UINT, WPARAM, LPARAM)

	Przeznaczenie:   Funkcja odpowiedzi okna na komunikaty .

	Komunikaty:

		 WM_COMMAND- Menu okna
		 WM_DESTROY- Zniszczenie okna i nastpnie powrt do Windows
		 WM_PAINT  - Odmalowywanie okna
		 WM_LBUTTON 
		 WM_KEYDOWN- Przejcie do kolejnego punktu programu
		 MY_MESSAGE- Wykonanie kolejnego punktu programu

****************************************************************************/

long FAR PASCAL __export MainWndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
  HDC dc ;
  RECT rect ;
  PAINTSTRUCT ps ;
  switch (message)
	{
	 case WM_COMMAND:						/* komenda menu */
	  switch (wParam)
		{
		 case CM_POMIAR :        /* powtrzenie pomiarw */
		  if(paintnum==0)
			{
			 paintnum = 1;
			 PostMessage(hWnd,MY_MESSAGE,0,0);
			}
		  break;
		 case CM_EXIT:           /* wyjcie z programu */
		  DestroyWindow(hWnd);
		  break;
		 default:
		  return (DefWindowProc(hWnd, message, wParam, lParam));
		}
	  break;
	 case WM_PAINT :                  /* wywietlenie informacji */
	  dc = BeginPaint(hWnd,&ps);
	  GetClientRect(hWnd,&rect);
	  switch(paintnum)
		{
		 case 1   : /*konfiguracja*/
		  displayconfiguration(dc,rect);
		  break ;
		 case 2   :
		 case 3   :
		 case 4   :
		 case 5   :
		 case 6   :
		  rect.top=displaytext(dc,rect,tstart);
		  rect.left = 10 ;
		  if(enddet>0)
			{
			 if(enddet == 2)
			  {
				rect.top = displaybuf(buf,
				CHANNELS, SAMPLES,dc,rect);
			  }
			 PressOrClickAny(dc,rect);
			}
		  break ;
		}
	  EndPaint(hWnd,&ps);
	  break ;
	 case WM_LBUTTONDOWN :     /* kliknicie mysz w oknie */
	 case WM_KEYDOWN		:		/* nacinicie klawisza */
	  if(paintnum!=0)
		{
		 paintnum++ ;
		 if(paintnum==7)
		  {
			paintnum = 0 ; /*koniec*/
			drawscreen();
		  }
		 else
		  PostMessage(hWnd,MY_MESSAGE,0,0);
		}
	  break ;
	 case MY_MESSAGE		:
	  enddet = 0 ;
	  switch(paintnum)
		{
		 case 0	 :
		  break ;
		 case 1	 :
		  askdriver();     /* odpytanie driver'a o konfiguracje */
		  drawscreen();	 /* wyswietlenie konfiguracji modulu i*/
								 /* toru a/c poprzez funkcj
								 displayconfiguration        		  */
		  installbreak();  /* zainstalowanie procedury obslugi   */
								 /* przerwania generowanego przez Ctrl-Break*/
		  break ;
		 case 2	 :
		  blocktransmission();	/* wykonanie transmisji blokowej +*/
										/* wyswietlenie zmierzonych wartosci*/
		  break ;
		 case 3 	 :
		  failblocktransmission();/* wykonanie blednej		*/
										  /* transmisji blokowej   */
		  break ;
		 case 4	 :
		  interruptedbefore();
								 /*wykonanie transmisji blokowej przerwanej*/
								 /* przez operatora przed startem */
		  break ;
		 case 5	 :
		  singletransmission();	/* wykonanie pomiaru w */
										/* trybie pojedynczym  */
		  break ;
		 case 6	 :
		  singlewrite();/* zapis wartosci na przetwornik CA  */
		  break ;
		}
	  break ;
	 case WM_DESTROY:                 /* koniec programu */
	  PostQuitMessage(0);
	  break;
	 default:
	  return (DefWindowProc(hWnd, message, wParam, lParam));
	}
  return (NULL);
}


/****************************************************************************
 Funkcja quit()

 Przeznaczenie : Wykonanie funkcji LEAVE_DRIVER

*****************************************************************************/
void quit()
{
  LC0_Leave((struct lc0_leave FAR * )&s_leave);
}

/***************************************************************************/
/* Funkcja : askdriver														*/
/* Przeznaczenie:                                                          */
/*   Rozpoznanie konfiguracji badanego modulu.                             */
/* Sposob:                                                                 */
/*   Przez wykorzystanie funkcji driver'a GET_TOTAL_CONFIGURATION,         */
/*   GET_MODULE_CONFIGURATION, GET_INFO.                                   */
/* Uwagi:                                                                  */
/*   Funkcja nadaje wartosc zmiennej modulenum (numer badanego modulu)     */
/*   wypelnia struktury total, module, info i inicjalizuje zainstalowane   */
/*    moduly.                                                              */
/***************************************************************************/
void askdriver(void)
{
	/* GET_TOTAL_CONFIGURATION */
	LC0_GetTotalConf((struct lc0_total FAR * )&s_total);

	/* inicjalizacja zainstalowanych modulow   */

	s_init.LC0_IMODULE = s_total.LC0_TONF & 0xF;
	/* MODULE_INIT     */
	LC0_ModuleInit((struct lc0_init FAR * )&s_init);

					/* sprawdzenie, ktory modul jest   */
					/*   zainstalowany: A, B, C czy D  */

	for(modulenum = 1; modulenum <= 4; modulenum++)
		 if(s_total.LC0_TONF & (1 << (modulenum - 1)))
		break;

					/* spytanie o konfiguracje modulu  */
	s_module.LC0_MMODULE = modulenum;
	/* GET_MODULE_CONFIGURATION*/
	LC0_GetModule((struct lc0_module FAR * )&s_module);

					/* spytanie o konfiguracje toru a/c*/
	s_info.LC0_GMODULE = modulenum;
	s_info.LC0_GTYPE   = LC0_AINPUT;
	s_info.LC0_GNUM    = 1;
	/* GET_INFO        */
	LC0_GetInfo((struct lc0_info FAR * )&s_info);

}

/***************************************************************************/
/* Funkcja : displayconfiguration(HDC,RECT)								   */
/* Przeznaczenie:                                                          */
/*   Wyswietlenie konfiguracji badanego modulu i jego toru a/c.            */
/* Sposob:                                                                 */
/*   Przez wykorzystanie informacji zawartych w strukturach module i info. */
/***************************************************************************/
void displayconfiguration(HDC dc ,RECT rect)
{
	int	i;
	char line[200],spar[10];

	rect.left +=10 ;

	DrawText(dc,"Konfiguracja moduu:",-1,&rect,DT_LEFT|DT_SINGLELINE);
	GoToLine(&rect,dc); GoToLine(&rect,dc);
	sprintf(line,"Adres moduu: %04X (hex)", s_module.LC0_MBASE1);
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
	GoToLine(&rect,dc);
	sprintf(line,"Liczba przetwornikw a/c: %d", s_module.LC0_MIAD);
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
	GoToLine(&rect,dc);
	sprintf(line,"Liczba przetwornikw c/a: %d", s_module.LC0_MIDA);
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
	GoToLine(&rect,dc);
	sprintf(line,"Liczba portw cyfrowych wejciowych: %d",
		s_module.LC0_MIDI);
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
	GoToLine(&rect,dc);
	sprintf(line,"Liczba portw cyfrowych wyjciowych: %d",
		s_module.LC0_MIDO);
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
	GoToLine(&rect,dc);
	sprintf(line,"Czestotliwo zegara moduu: %d MHz",s_module.LC0_MCLOCK / 1000);
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);

					/* konfiguracja toru a/c           */
	GoToLine(&rect,dc);GoToLine(&rect,dc);
	sprintf(line,"Konfiguracja toru a/c:");
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
	GoToLine(&rect,dc);GoToLine(&rect,dc);

	sprintf(line,"Liczba kanaw: %d", s_info.LC0_GCHAN);
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);

	GoToLine(&rect,dc);
	sprintf(line,"Rozdzielczo: %d bitow", s_info.LC0_GRES);
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);

	GoToLine(&rect,dc);
	sprintf(line,"Zakres napi: %.1f..%.1f V",
		(float)s_info.LC0_GMINV / 10,
		(float)s_info.LC0_GMAXV / 10);
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);

	GoToLine(&rect,dc);
	if(s_info.LC0_GDMA == 0xFF)												
		 sprintf(line,"Tor a/c nie jest podczony do kanaw DMA");
	else
		 sprintf(line,"Numer kanau DMA podczonego do toru a/c: %d",
								 s_info.LC0_GDMA);
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);

	GoToLine(&rect,dc);
	sprintf(line,"Minimalne okresy prbkowania [us]:");
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);

	GoToLine(&rect,dc);
	rect.left +=5;
	sprintf(line,"");
	for(i = 0; i < s_info.LC0_GCHAN; i++)
	 {
		if(i < s_info.LC0_GCHAN - 1)
		 sprintf(spar," %.1f ,",(float)s_info.LC0_GMINP[i] / 10);
		else
		 sprintf(spar," %.1f",(float)s_info.LC0_GMINP[i] / 10);
		strcat(line,spar);
		if(i == 7)
		 {
		  DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
		  sprintf(line,"");
		  GoToLine(&rect,dc);
		 }

	 }
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);

	GoToLine(&rect,dc);GoToLine(&rect,dc);
	sprintf(line,"Wcinij dowolny klawisz lub kliknij by przej dalej ... ");
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);

  ReleaseDC(dc,hWnd);
}


/***************************************************************************/
/* Funkcja : displaytext(HDC,RECT,unsigned char)						   */
/* Przeznaczenie:                                                          */
/*   Wyswietlenie komunikatw tekstowych dla transmisji A/C programu	   */
/* Korzysta ze zmiennej paintdet , ktra okrela biec faz transmisji   */
/* blokowej oraz paintnum , ktra okkela rodzaj transmisji				   */
/***************************************************************************/
int displaytext(HDC dc,RECT rect,unsigned char start)
{
 char line[200] ;
 rect.left += 10;

 switch(paintdet)
  {
	 case 1			:  /* blocktransmission */
							sprintf(line,"Poprawne przetwarzanie blokowe");
							DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
							break ;
	 case 2			:  /* failblocktransmission */
							sprintf(line,"Bdne przetwarzanie blokowe");
							DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
							break ;
	 case 3			:  /* interruptbefore */
							sprintf(line,"Przetwarzanie blokowe z oczekiwaniem 1000s .");
							DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
							GoToLine(&rect,dc);
							sprintf(line,"Oczekiwanie nalezy przerwac Ctrl-Break .");
							DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
							break ;
	 case 4			:   /* singletransmission */
							sprintf(line,"Przetwarzanie programowe - po 5 sekundach .");
							DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
							break ;
	 case 5			:   /* singlewrite */
							sprintf(line,"Wyslanie pojedynczej wartosci na przetwornik CA");
							DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
							break ;
  }
 GoToLine(&rect,dc);

 if(paintdet < 4) /* transmisje blokowe : paintdet = 1..3*/
  {
	GoToLine(&rect,dc);
	sprintf
	(line,
	"Pomiar blokowy, %d kanaw, %d prbek, okres prbkowania %.1f us:",
	CHANNELS, SAMPLES, (float)s_analog_in.LC0_APER / 10
	);
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
  }
  switch(start)
	{
	 case LC0_SIMMED:
	  sprintf(line,"Warunek startu: natychmiast");
	  break;
	 case LC0_STIME:
	  sprintf(line,"Warunek startu: upyw %lu sekund",
						s_analog_in.LC0_ASTART.time);
	  break;
				/* pozostale warunki nie sa obslugiwane bo */
	}
	GoToLine(&rect,dc);
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);

 return(rect.top);
}


/***************************************************************************/
/* Funkcja my_break     													*/
/* Przeznaczenie:                                                          */
/*   Procedura obslugi przerwania pomiaru klawiszem Ctrl-Break.            */
/***************************************************************************/
void FAR  my_break(void)
{
  /* sygnalizacja dwikowa */
  koniec = 1;
  MessageBeep(-1);
}

/***************************************************************************/
/* Funkcja : installbreak													*/
/* Przeznaczenie:                                                          */
/*   Zainstalowanie procedury obslugi przerwania generowanego przez        */
/*   Ctrl-Break.                                                           */
/* Sposob:                                                                 */
/*   Przez wywolanie funkcji BREAK.                                        */
/***************************************************************************/
void installbreak(void)
{
	s_break.LC0_BMODE = LC0_BREAK_INST;
	s_break.LC0_BPROC = (void FAR *)&(my_break);	;	/* podlozona zostanie      */
												/*   procedura uytkownika    */
	LC0_Break((struct lc0_break FAR * )&s_break);
}

/***************************************************************************/
/* Funkcja : blocktransmission												*/
/* Przeznaczenie:                                                          */
/*   Wykonanie poprawnej transmisji blokowej i wyswietlenie zmierzonych    */
/*   wartosci.                                                             */
/* Sposob:                                                                 */
/*   Przez wykonanie funkcji transmission.                                 */
/***************************************************************************/
void blocktransmission(void)
{
	tstart = LC0_SIMMED ;
	paintdet = 1 ;
	s_analog_in.LC0_APER = (long)s_info.LC0_GMINP[CHANNELS - 1]+200;
	drawscreen();
	transmission(LC0_SIMMED);
}

/***************************************************************************/
/* Funkcja : failblocktransmission()										*/
/* Przeznaczenie:                                                          */
/*   Wykonanie blednej transmisji blokowej.                                */
/* Sposob:                                                                 */
/*   Przez wykonanie funkcji ANALOG_INPUT z okresem probkowania mniejszym  */
/*   niz minimalny wskazany przez driver.                                  */
/***************************************************************************/
void failblocktransmission(void)
{
	tstart = LC0_SIMMED ;
	paintdet = 2 ;
	s_analog_in.LC0_APER = (long)s_info.LC0_GMINP[CHANNELS - 1] - 1;
	drawscreen();
	transmission(LC0_SIMMED);
}

/***************************************************************************/
/* Funkcja : interruptbefore();                                            */
/* Przeznaczenie:                                                          */
/*   Wykonanie poprawnej transmisji blokowej ale przerwanej przez operatora*/
/*   (Ctrl-Break) w trakcie czekania na spelnienie warunku startu.         */
/* Sposob:                                                                 */
/*   Przez wykonanie funkcji ANALOG_INPUT z warunkiem startu LC0_STIME     */
/*   (start po okreslonym czasie) i parametrem tego warunku - 1000s.       */
/***************************************************************************/
void interruptedbefore(void)
{
	tstart = LC0_STIME ;
	paintdet = 3 ;
	s_analog_in.LC0_APER = (long)s_info.LC0_GMINP[CHANNELS - 1];
	s_analog_in.LC0_ASTART.time = 1000;
	drawscreen();
	transmission(LC0_STIME);
}

/***************************************************************************/
/* Funkcja: 		transmission											*/
/* Przeznaczenie:                                                          */
/*   Wykonanie transmisji blokowej.                                        */
/* Sposob:                                                                 */
/*   Przez wykonanie funkcji ANALOG_INPUT.                                 */
/* Parametry:                                                              */
/*   start - typ warunku startu                                            */
/* Wartosc:                                                                */
/* Uwagi:                                                                  */
/*   Funkcja wywolujaca musi ustawic okres probkowania i parametry warunku */
/*   startu.                                                               */
/***************************************************************************/
void transmission(unsigned char start)
{
	/*int	buf[BUFLEN];*/

	s_analog_in.LC0_AMODULE = modulenum;
	s_analog_in.LC0_ANUM = 1;
	s_analog_in.LC0_AMODE = LC0_MOD_START |LC0_MOD_NEW_PAR |LC0_MOD_SYNCHR |LC0_MOD_BLOCK;
			/* stop po zmierzeniu okreslonej liczby probek     */
	s_analog_in.LC0_ASTST = start + LC0_ZSAMPLES;
				/* praca wielokanalowa, CHANNELS kanalow   */
	s_analog_in.LC0_ACHAN = CHANNELS;
	s_analog_in.LC0_AADDR = (int far *)buf;	/* konieczna konwersja na  */
						/*   daleki adres          */
	s_analog_in.LC0_ALEN = BUFLEN;	/* dlugosc bufora                  */
	s_analog_in.LC0_ABMAR = 0;
	s_analog_in.LC0_AEMAR = 0;	/* oba marginesy zerowe            */
					/* calkowita liczba probek         */
	s_analog_in.LC0_ASTOP.samples = SAMPLES * CHANNELS;
	/*ANALOG_INPUT    */                 
	s_analog_in.LC0_AMODE = LC0_MOD_START |LC0_MOD_NEW_PAR |LC0_MOD_SYNCHR |LC0_MOD_BLOCK;
	LC0_AnalogIn((struct lc0_analog_in FAR * )&s_analog_in);
	if(s_analog_in.LC0_STATUS != LC0_OK)
	 {
		 enddet = 1;
		 drivererror(s_analog_in.LC0_STATUS, s_analog_in.LC0_ERR_STAT);
	 }
	else
		 enddet = 2;
	drawscreen();
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Wykonanie pomiaru bloku probek za pomoca tranmsisji programowej, przy */
/*   czym caly blok ma byc zmierzony po 10s od startu.                     */
/* Sposob:                                                                 */
/*   Przez wykonanie funkcji ANALOG_INPUT.                                 */
/* Parametry:                                                              */
/* Wartosc:                                                                */
/* Uwagi:                                                                  */
/***************************************************************************/
void singletransmission(void)
{
	tstart = LC0_STIME ;
	paintdet = 4 ;
	s_analog_in.LC0_AMODULE = modulenum;
	s_analog_in.LC0_ANUM = 1;
	s_analog_in.LC0_AMODE =LC0_MOD_NEW_PAR | LC0_MOD_START|LC0_MOD_SYNCHR;
				/* praca wielokanalowa, CHANNELS kanalow   */
	s_analog_in.LC0_ACHAN = CHANNELS;
	s_analog_in.LC0_AADDR = (int far *)buf; /* konieczna konwersja na  */
						/*   daleki adres          */
	s_analog_in.LC0_ALEN = BUFLEN;	/* cakowita dugosc bufora   */
	s_analog_in.LC0_ASTST = LC0_STIME+LC0_ZSAMPLES;
	s_analog_in.LC0_ASTART.time = 5;	/* start po 5 sekundach    */
	/* calkowita liczba probek         */
	s_analog_in.LC0_ASTOP.samples = SAMPLES * CHANNELS;
	drawscreen();

	/* ANALOG_INPUT    */
	LC0_AnalogIn((struct lc0_analog_in FAR * )&s_analog_in);
	if(s_analog_in.LC0_STATUS != LC0_OK)
	 {
		 enddet = 1;
		 drivererror(s_analog_in.LC0_STATUS, s_analog_in.LC0_ERR_STAT);
	 }
	else
		 enddet = 2;
	drawscreen();
}


/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Wyswietlenie bufora z danymi pomiarowymi.                             */
/* Parametry:                                                              */
/*   buf - adres bufora                                                    */
/*   c   - liczba kanalow                                                  */
/*   s   - liczba probek na kanal                                          */
/*   dc	- kontekt wyswietlania												*/
/*   rect - okno do wywietlania											*/
/***************************************************************************/
int displaybuf(int *buf, int c, int s , HDC dc , RECT rect)
{
	int	i,j;
	char line[100],str[10];
	GoToLine(&rect,dc);
	for(i = 0; i < s; i++)
		 {
		 sprintf(line,"%2d:   ", i + 1);
		 for(j = 0; j < c; j++)
		  {
			sprintf(str,"%04X    ", buf[i * c + j]);
			strcat(line,str);
		  }
		  DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
		  GoToLine(&rect,dc);
		 }
	 return(rect.top);
}

/***************************************************************************/
/* Funkcja : singlewrite()													*/
/* Przeznaczenie:                                                          */
/*   Wyslanie pojedynczej wartosci na przetwornik CA                       */
/* Sposob:                                                                 */
/*   Przez wykonanie funkcji ANALOG_OUTPUT.                                */
/* Parametry:                                                              */
/* Wartosc:                                                                */
/* Uwagi:                                                                  */
/***************************************************************************/
void singlewrite(void)
{
	int	val[2];			/* wartosc do wyslania             */

	tstart = LC0_SIMMED ;
	paintdet = 5 ;
	if(!s_module.LC0_MIDA)
	{
	 MessageBox(hWnd,"Karta nie posiada zainstalowanych przetwornikow CA","Sygna",MB_OK);
	 drawscreen();
	 return;
	}
	val[0] = 4095;
	s_analog_out.LC0_NMODULE = modulenum;
	s_analog_out.LC0_NNUM = 1;
	s_analog_out.LC0_NMODE = LC0_MOD_START |LC0_MOD_NEW_PAR |LC0_MOD_SYNCHR;
					/* praca jednokanalowa             */
	s_analog_out.LC0_NCHAN = 1 + 128;
	s_analog_out.LC0_NADDR.base_memory = (int far *)val; /* konieczna konwersja na */
						/*   daleki adres          */
	s_analog_out.LC0_NLEN = 1;		/* dlugosc bufora (tylko   */
						/*   na jedna wartosc)     */
	s_analog_out.LC0_NSTST = LC0_SIMMED+ LC0_ZSAMPLES ;
	/* ilo prbek do wysania */
	s_analog_out.LC0_NSTOP.samples = 1;
	drawscreen();
	/* ANALOG_OUTPUT    */
	LC0_AnalogOut((struct lc0_analog_out FAR * )&s_analog_out);
	if(s_analog_out.LC0_STATUS != LC0_OK)
	 drivererror(s_analog_out.LC0_STATUS, s_analog_out.LC0_ERR_STAT);
	enddet = 1;
	drawscreen();
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Wypisanie komunikatow o bledzie / ostrzezeniu / dodatkowej informacji */
/*   bledzie.                                                              */
/* Parametry:                                                              */
/*   status   - LC0_STATUS                                                 */
/*   err_stat - LC0_ERR_STAT                                               */
/***************************************************************************/
void drivererror(char status, char err_stat)
{
  char sts[100];
	if(status > 0)
		 sprintf(sts,"Ostrzeenie: %s",
				(LPSTR)DriverWarnings[status - 1]);
	else
		 sprintf(sts,"Bd: %s", (LPSTR)DriverErrors[-status - 1]);
	MessageBox(hWnd,sts,"Sygna",MB_OK);
	if(err_stat < 0)
	 {
		 sprintf(sts,"Informacje dodatkowe: %s",
			(LPSTR)DriverAdditionalErrors[-err_stat - 1]);
		 MessageBox(hWnd,sts,"Sygna",MB_OK);
	 }
}




/***************************************************************************/
/* Funkcja PressOrClickAny(HDC,RECT)                                       */
/* Przeznaczenie:                                                          */
/*   Wypisuje na ekranie informacje o kocu kolejnego      kroku programu  */
/***************************************************************************/
void PressOrClickAny(HDC dc , RECT rect)
{
  char line[100];
	GoToLine(&rect,dc);GoToLine(&rect,dc);
	sprintf(line,"Wcinij dowolny klawisz lub kliknij by przej dalej ... ");
	DrawText(dc,line,-1,&rect,DT_LEFT|DT_SINGLELINE);
}


/*****************************************************************************
 GoToLine(*RECT) 0 przejcie do nastpnej linii przy wywietlaniu tekstu
******************************************************************************/
void GoToLine(RECT *rect , HDC hdc)
{
 TEXTMETRIC tm ;
 GetTextMetrics(hdc,&tm);

 rect->top +=tm.tmHeight + tm.tmExternalLeading ;
 rect->bottom +=tm.tmHeight + tm.tmExternalLeading ;
}

/****************************************************************************
 Funkcja : drawscreen
 Przeznaczenie : Wybranie odpowiedniej sekcji informacji do wywietlenia
					  na ekranie w odpowiedzi na komunikat WM_PAINT
******************************************************************************/
void drawscreen(void)
 {
	InvalidateRect(hWnd,NULL,TRUE);
	UpdateWindow(hWnd);
 }

