		SUBTTL	Struktury parametrow driver'a
		PAGE +

		COMMENT	#
Kazde zlecenie zaczyna sie od nizej opisanych pol.
#
LC0_HEADER	STRUC
LC0_CODE	DB	?		;kod funkcji
LC0_STATUS	DB	?		;kod bledu
LC0_ERR_STAT	DB	?		;dodatkowa informacja o bledach
LC0_HEADER	ENDS

		SUBTTL	Stale
		PAGE +

;============================================================================
;
;		Stale niezbedne dla driver'a
;
;============================================================================


;============================================================================
;
;               Stale niezbedne dla biblioteki uzytkowej
;
;============================================================================

;numery przerwan obslugiwanych przez driver

LC010_16	EQU	99h		;LC-010-1612
LC011_08	EQU	90h		;LC-011-0812
LC011_16	EQU	91h		;LC-011-1612
LC015_16	EQU	92h		;LC-015-1612
LC020_08_0	EQU	93h		;LC-020-0812 v.0 
LC020_08_2	EQU	94h		;LC-020-0812 v.1 i v.2
LC020_32	EQU	95h		;LC-020-3212
LC030_16	EQU	96h		;LC-030-1612
LC060_06	EQU	97h		;LC-060-0612

;----------------------------------------------------------------------------
LC0_COND_LENGTH	EQU	5	;maksymalny rozmiar struktury opisujacej
				;warunek startu / stopu
;----------------------------------------------------------------------------

;
;Kody funkcji driver'a:
;
MODULE_INIT			EQU	0
GET_TOTAL_CONFIGURATION		EQU	1
GET_MODULE_CONFIGURATION	EQU	2
GET_INFO			EQU	3
SET_CLOCK			EQU	4
SET_VOLTAGE_RANGE		EQU	5
SET_TIME			EQU	6
WAIT_FOR_END			EQU	7
BREAK				EQU	8
DIGITAL_INPUT			EQU	9
DIGITAL_OUTPUT			EQU	10
CTC_WRITE			EQU	11
CTC_READ			EQU	12
DATA_TRANSMIT			EQU	13
ANALOG_INPUT			EQU	14
ANALOG_OUTPUT			EQU	15
LEAVE_DRIVER			EQU	16
INTERRUPT_SERVICE		EQU	17

;----------------------------------------------------------------------------
;
;kody odpowiedzi driver'a karty
;
;----------------------------------------------------------------------------
;
;ostrzezenia:
;
LC0_OK			EQU	0	;OK
LC0_NON_EX_MOD		EQU	1	;nie istniejacy(e) modul(y)
LC0_OTHER_LEN		EQU	2	;przepisano mniejsza liczbe pomiarow
LC0_PREMATURE_END	EQU	3	;przedwczesne zakonczenie z powodu
					;przepelnienia bufora
LC0_IN_PROGRESS		EQU	4	;badana transmisja jeszcze trwa

;----------------------------------------------------------------------------
;
;bledy:
;
LC0_UNKN_FUNC		EQU	-1	;nieznany kod funkcji
LC0_NO_MODULE		EQU	-2	;brak modulu(ow)
LC0_BAD_DEV_TYP		EQU	-3	;bledny typ urzadzenie
LC0_NONEX_DEV		EQU	-4	;nie istnieje urzadzenie o tym numerze
LC0_BAD_FREQ		EQU	-5	;zla czestotliwosc zegara
LC0_BAD_RANGE		EQU	-6	;zly zakres napiec
LC0_NO_OPER		EQU	-7	;zadna operacja nie jest wykonywana
LC0_BAD_MARGIN		EQU	-8	;bledna dlugosc marginesu poczatkowego
LC0_BAD_BUF_ADR		EQU	-9	;bledny adres bufora
LC0_BAD_BUF_LEN		EQU	-10	;bledna dlugosc bufora
LC0_DEV_BUSY		EQU	-11	;urzadzenie jest zajete
LC0_BAD_PER		EQU	-12	;zly okres probkowania
LC0_BAD_CHAN_N		EQU	-13	;zla liczba kanalow
LC0_BAD_CHAN		EQU	-14	;numer nie istniejacego kanalu
LC0_BROKEN		EQU	-15	;przerwano funkcja BREAK
LC0_INTR_NOT_INST	EQU	-16	;procedura obslugi przerwania nie jest
					;zainstalowana
LC0_ILL_START_CODE	EQU	-17	;nielegalny typ warunku startu
LC0_ILL_STOP_CODE	EQU	-18	;nielegalny typ warunku stopu
LC0_BAD_PROC	 	EQU	-19	;bledny adres procedury obslugi
					;przerwania lub slowa komunikacyjnego
LC0_TOO_LONG_MARG 	EQU	-20	;margines dluzszy od bufora
LC0_ILL_START		EQU	-21	;bledne parametry warunku startu
LC0_ILL_STOP		EQU	-22	;bledne parametry warunku stopu
LC0_BAD_MNUM		EQU	-23	;bledny numer pierwszej probki
LC0_NOT_SUPPORTED	EQU	-24	;dla danego modulu funkcja nie jest
					;realizowana
LC0_BAD_CTC_MODE	EQU	-25	;bledny tryb pracy CTC
LC0_NO_PARAMS		EQU	-26	;nie podano parametrow przetwarzania
LC0_OVERRUN		EQU	-27	;zakonczono przetwarzanie z powodu
					;bledu OVERRUN
LC0_NO_DMA		EQU	-28	;z danym urzadzeniem nie jest zwiazany
					;zaden kanal DMA
LC0_NO_IRQ		EQU	-29	;z danym modulem nie jest zwiazane
					;zadne przerwanie
LC0_NOT_FULLY_SUP	EQU	-30	;zadany tryb wykonania funkcji nie
					;jest realizowany dla danego typu
					;modulu lub funkcja w opracowaniu
LC0_NO_EXTMEM		EQU	-31	;brak pamieci roszerzonej
LC0_NO_SECFREQ		EQU	-32	;modul nie moze wykonywac pomiarow z
					;podwojna czestotliwoscia
LC0_INTR_INST		EQU	-33	;procedura obslugi przerwania juz
					;zainstalowana
LC0_BAD_PER2		EQU	-34	;bledna wielokrotnosc okresu
					;probkowania (0 lub 1)
LC0_BAD_MODE		EQU	-35	;bledny tryb pracy
LC0_BAD_EXTMEM		EQU	-36	;zly adres bufora w pam. rozszerzonej
LC0_CTC_NOT_PROGRAMMED	EQU	-37	;zapis licznika przy
					;niezaprogramowanym trybie pracy
LC0_REJECTED		EQU	-38	;za wiele rownoleglych wejsc do
					;driver'a
;----------------------------------------------------------------------------
;
;informacje dodatkowe:
;
LC0_E_OK		EQU	0	;brak informacji dodatkowych
LC0_E_NO_MODULE		EQU	-1	;nie ma takiego modulu
LC0_E_NONEX_DEV		EQU	-2	;nie istnieje urzadzenie o tym numerze
LC0_E_BAD_CHAN		EQU	-3	;numer nieistniejacego kanalu
LC0_E_BAD_TIME		EQU	-4	;zly odcinek czasu
LC0_E_BAD_DATE		EQU	-5	;zla specyfikacja daty
LC0_E_BAD_THRE		EQU	-6	;bledny prog wyzwalania analogowego
LC0_E_BROKEN_WAIT	EQU	-7	;funkcja przerwana w trakcie
					;oczekiwania na spelnienie war. startu
LC0_E_BROKEN_RUN	EQU	-8	;funkcja przerwana w trakcie
					;przetwarzania
LC0_E_BAD_LEN		EQU	-9	;za dlugi pomiar

;----------------------------------------------------------------------------
;
;struktury rekordow opisu zlecen i pozostale stale
;
;============================================================================
; MODULE_INIT
;
LC0_INIT	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_IMODULE	DB	?		;mapa modulow
LC0_INIT	ENDS
;
; Mapa modulow
;		D C B A
;		x x x x
; x = 1 zeruj modul, = 0 nie zeruj modulu
;

;============================================================================
; GET_TOTAL_CONFIGURATION
;
LC0_TOTAL	STRUC
		DB	TYPE LC0_HEADER DUP ()
		;PARAMETRY WYJSCIOWE
LC0_TONF	DB	?	;konfiguracja modulow
LC0_TIAD	DB	?	;liczba dostepnych przetwornikow AC
LC0_TIDA	DB	?	;liczba dostepnych przetwornikow CA
LC0_TCTC	DB	?	;liczba dostepnych kanalow CTC
LC0_TIDI	DB	?	;liczba dostepnych portow wejsc cyfrowych
LC0_TIDO	DB	?	;liczba dostepnych portow wyjsc cyfrowych
LC0_TMEMA	DD	?	;adres bufora w pamieci rozszerzonej
                                ;(absolutny)
LC0_TMEML	DD	?	;dlugosc bufora w pamieci rozszerzonej
				;(w probkach; 0 - brak pamieci rozszerzonej)
LC0_TOTAL	ENDS
;
; Format bajtu konfiguracji modulow
;	D B C A D C B A
;	y y y y x x x x
; x = 1 modul zaistalowany, = 0 modulu nie ma
; y = 1 modul master, = 0 modul slave
;
;Operacja zawsze konczy sie pomyslnie

;============================================================================
; GET_MODULE_CONFIGURATION
;
LC0_MODULE	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_MMODULE	DB	?		;numer modulu
		;PARAMETRY WYJSCIOWE
LC0_MBASE1	DW	?	;adres bazowy rejestrow modulu (pakiet 1)
LC0_MBASE2	DW	?	;adres bazowy rejestrow modulu (pakiet 2)
LC0_MIAD	DB	?	;liczba dostepnych przetwornikow AC
LC0_MIDA	DB	?	;liczba dostepnych przetwornikow CA
LC0_MCTC	DB	?	;liczba dostepnych kanalow CTC
LC0_MIDI	DB	?	;liczba dostepnych portow wejsc cyfrowych
LC0_MIDO	DB	?	;liczba dostepnych portow wyjsc cyfrowych
LC0_MCLOCK	DW	?	;czestotliwosc zegara w kHz
LC0_MINT	DB	?	;numer przerwania (programowy)
LC0_MODULE	ENDS

;============================================================================
; GET_INFO
;
LC0_INFO	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_GTYPE	DB	?		;rodzaj urzadzenia
LC0_GMODULE	DB	?		;numer modulu
LC0_GNUM	DB	?		;numer przetwornika/bajtu/ukladu CTC
		;PARAMETRY WYJSCIOWE
LC0_GCHAN	DB	?		;liczba kanalow 1)
LC0_GRES	DB	?		;liczba bitow przetwornika 2)
LC0_GTIME	DW	?		;czas konwersji przetwornika w ns 2)
LC0_GMINV	DB	?		;dolna granica zakresu napiec w 
					;dziesiatych czesciach volta 2)
LC0_GMAXV	DB	?		;gorna granica zakresu napiec w
					;dziesiatych czesciach volta 2)
LC0_GDMA	DB	?		;numer kanalu DMA 2)
LC0_GMINP	DW	32 DUP (0)	;minimalne okresy probkowania 3)
LC0_INFO	ENDS
;
; okreslonosc poszczegolnych pol dla roznych typow urzadzen:
; 1) wszystkie bez CTC
; 2) tylko a/c i c/a
; 3) tylko a/c
;

;============================================================================
; SET_CLOCK
;
LC0_CLOCK	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_LCLOCK	DW	?		;czestotliwosc zegara w kHz
LC0_CLOCK	ENDS

;============================================================================
; SET_VOLTAGE_RANGE
;
LC0_VOLT	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_VTYPE	DB	?  	;rodzaj urzadzenia
LC0_VMODULE	DB	?  	;numer modulu
LC0_VNUM	DB	?  	;numer przetwornika
LC0_VMINV	DB	?  	;dolna granica zakresu napiec w dziesiatych 
			   	;czesciach volta
LC0_VMAXV	DB	?  	;gorna granica zakresu napiec w dziesiatych 
			   	;czesciach volta
LC0_VOLT	ENDS

;============================================================================
; SET_TIME
;
LC0_TIME	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_ETIME	DW	? 	;maksymalny czas obslugi przerwania, ktore
			  	;moze pojawic sie w trakcie wykonywania 
			  	;dlugiego pomiaru podawany w mikrosekundach
LC0_TIME	ENDS
;

;============================================================================
; WAIT_FOR_END
;
LC0_WAIT	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_WTYPE	DB	?	;rodzaj urzadzenia
LC0_WMODULE	DB	?	;numer modulu
LC0_WNUM	DB	?	;numer przetwornika
LC0_WMODE	DB	?	;tryb pracy: LC0_W_WAIT, LC0_W_TEST,
				;            LC0_W_FINISHED
LC0_WRMNUM	DD	?	;rzeczywista liczba probek
LC0_WREMAR	DW	?	;rzeczywista dlugosc marginesu koncowego
LC0_WAIT	ENDS
;
; kody trybu pracy:
;
LC0_W_WAIT	EQU	0	;oczekiwanie
LC0_W_TEST	EQU	1	;test konca transmisji
LC0_W_FINISHED	EQU	2	;zasygnalizowanie konca

;============================================================================
; BREAK
;
LC0_BREAK	STRUC
		DB	TYPE LC0_HEADER DUP (?)
LC0_BMODE	DB	?		;tryb pracy
LC0_BPROC	DD	?		;adres procedury obslugi przerwania
LC0_BREAK	ENDS

;
; tryby wykonania funkcji:
;
LC0_BREAK_EXEC		EQU	0	;przerwanie
LC0_BREAK_INST		EQU	1b	;instalacja Ctrl_Break ...
LC0_BREAK_PREV		EQU	100b	;... z wykonaniem poprzedniej procedury
LC0_BREAK_UNINST	EQU	10b	;wyinstalowanie wszystkiego

;============================================================================
; DIGITAL_INPUT
;
LC0_DIGITAL_IN	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_DMODULE	DB	?		;numer modulu
LC0_DNUM	DB	?		;numer bajtu
LC0_DSTST	DB	?		;typ warunku startu
LC0_DVAL	DB	?		;wartosc
LC0_DSTART	DB	LC0_COND_LENGTH DUP (?)	;parametry warunku startu
LC0_DIGITAL_IN	ENDS

;============================================================================
; DIGITAL_OUTPUT
;
LC0_DIGITAL_OUT	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_OMODULE	DB	?		;numer modulu
LC0_ONUM	DB	?		;numer bajtu
LC0_OSTST	DB	?		;typ warunku startu
LC0_OVAL	DB	?		;wartosc
LC0_OSTART	DB	LC0_COND_LENGTH DUP (?)	;parametry warunku startu
LC0_DIGITAL_OUT	ENDS

;============================================================================
; CTC_WRITE
;
LC0_CTC_WRITE	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_CMODULE	DB	?		;numer modulu
LC0_CMODE	DB	?		;tryb pracy funkcji
LC0_CFUN	DB	?		;tryb pracy kanalu
LC0_CVAL	DW	?		;wartosc licznika
LC0_CTC_WRITE	ENDS
;
; tryb pracy funkcji
;
; bit 1 - zaprogramuj tryb pracy kanalu
; bit 2 - zaladuj nowa wartosc licznika
; bit 3 - zezwolenie / zakaz CTC
;
LC0_SET_CTC_MODE	EQU	1
LC0_SET_COUNTER_VALUE	EQU	2
LC0_CTC_ENABLE		EQU	4
;
; Format bajtu trybu zegara
;     C C R R M M M B
; C: 0/1/2 - numer kanalu
; R: 1 - MSB, 2 - LSB, 3 - LSB/MSB
; M - tryb 8253/8254: 0..5
; B = 0 licznik binarny (16b), = 1 licznik BCD (4 dekady)

;============================================================================
; CTC_READ
;
LC0_CTC_READ	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_UMODULE	DB	?		;numer modulu
LC0_UNUM	DB	?		;numer kanalu
		;PARAMETRY WYJSCIOWE
LC0_UVAL	DW	?		;wartosc licznika
LC0_CTC_READ	ENDS

;============================================================================
; DATA_TRANSMIT
;
LC0_TRANSMIT	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_RMODE	DB	?	;tryb przesylania
LC0_RADDR	DD	?	;adres bufora w pamieci podstawowej
LC0_RLEN	DD	?	;dlugosc bufora w pamieci podstawowej
LC0_RMEAS	DD	?	;numer pierwszej probki do przeslania
LC0_RNUM	DD	?	;liczba probek do przeslania
LC0_RMEMA	DD	?	;adres bufora w pamieci rozszerzonej
			 	;(absolutny)
		;PARAMETRY WYJSCIOWE
LC0_RRNUM	DD	?   	;rzeczywista liczba probek
LC0_TRANSMIT	ENDS
;
; tryb przesylania:
;
LC0_TO_EXT_DIR		EQU	1	;podstawowa -> rozszerzona
LC0_FROM_EXT_DIR	EQU	0	;rozszerzona / modul -> podstawowa

;============================================================================
; ANALOG_INPUT
;
LC0_ANALOG_IN	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_AMODULE	DB	?	;numer modulu
LC0_ANUM	DB	?	;numer przetwornika
LC0_AMODE	DW	?	;tryb pracy
LC0_ASTST	DB	?	;typy warunku startu i stopu
LC0_APER	DD	?	;okres probkowania
LC0_APER2	DW	?	;krotnosc okresu podstawowego
LC0_ACHAN	DB	?	;liczba kanalow podstawowych (b8 okresla czy
				;praca wielokanalowa (0) czy 
				;jednokanalowa (1))
LC0_ACHAN2	DB	?	;liczba kanalow dodatkowych
LC0_AADDR	DD	?	;adres bufora w pamieci podstawowej
LC0_ALEN	DD	?	;dlugosc bufora
LC0_AMEMA	DD	?	;adres bufora w pamieci rozszerzonej
				;(absolutny)
LC0_ABMAR	DW	?	;dlugosc marginesu poczatkowego
LC0_AEMAR	DW	?	;dlugosc marginesu koncowego
LC0_AHAND	DW	?	;numer handler'a zbioru
LC0_ASTART	DB	LC0_COND_LENGTH DUP (?)	;parametry warunku startu
LC0_ASTOP	DB	LC0_COND_LENGTH DUP (?)	;parametry warunku stopu
		;PARAMETRY WYJSCIOWE
LC0_ARDIV1	DW	?	;rzeczywista wartosc 1. licznika dzielacego
LC0_ARDIV2	DW	?	;rzeczywista wartosc 2. licznika dzielacego
LC0_ARMNUM	DD	?	;rzeczywista liczba probek
LC0_ARBMAR	DW	?	;rzeczywista dlugosc marginesu poczatkowego
LC0_AREMAR	DW	?	;rzeczywista dlugosc marginesu koncowego
LC0_ARLEN	DD	?	;rzeczywista liczba przepisanych probek
LC0_ARBUF	DW	?	;dla pracy z buforem cyklicznym: numer probki
				;okreslajacej poczatek bufora po zakonczeniu
				;pomiaru
LC0_ANALOG_IN	ENDS

;============================================================================
; ANALOG_OUTPUT
;
LC0_ANALOG_OUT	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_NMODULE	DB	?	;numer modulu
LC0_NNUM	DB	?	;numer przetwornika
LC0_NMODE	DW	?	;tryb
LC0_NSTST	DB	?	;typy warunku startu i stopu
LC0_NCHAN	DB	?	;liczba kanalow podstawowych (b8 okresla
			 	;czy praca wielokanalowa (0) czy
			 	;jednokanalowa (1))
LC0_NPER	DD	?	;okres probkowania
LC0_NADDR	DD	?	;adres bufora (segment:offset dla
			 	;pamieci podstawowej, absolutny dla
			 	;pamieci rozszerzonej)
LC0_NLEN	DD	?	;dlugosc bufora
LC0_NHAND	DW	?	;numer handler'a zbioru
LC0_NSTART	DB	LC0_COND_LENGTH DUP (?)	;parametry warunku startu
LC0_NSTOP	DB	LC0_COND_LENGTH DUP (?)	;parametry warunku stopu
		;PARAMETRY WYJSCIOWE
LC0_NRMNUM	DD	?	;rzeczywista liczba wyslanych probek
LC0_ANALOG_OUT	ENDS

;============================================================================
; LEAVE_DRIVER
;
LC0_LEAVE	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_LEAVE	ENDS

;============================================================================
; INTERRUPT_SERVICE
;
LC0_INTERRUPT	STRUC
		DB	TYPE LC0_HEADER DUP ()
LC0_SMODULE	DB	?	;numer modulu
LC0_SPROC	DD	?	;adres procedury obslugi lub 0:0
LC0_SSTAT	DD	?	;adres slowa komunikacyjnego
LC0_INTERRUPT	ENDS
;
; kody przyczyny przerwania
;
LC0_IS_START	EQU	1	;przerwanie wystapilo z powodu rozpoczecia
				;pomiaru
LC0_IS_ONE	EQU	2	;przerwanie nastapilo z powodu zmierzenia
				;kolejnej serii pomiarowej
LC0_IS_END_ADC	EQU	4	;przerwanie nastapilo z powodu zakonczenia
				;przetwarzania a/c
LC0_IS_END_DAC	EQU	8	;przerwanie nastapilo z powodu zakonczenia
				;przetwarzania c/a
LC0_IS_BROKEN	EQU	16	;zakonczono przetwarzanie z powodu wykonania
				;funkcji BREAK
LC0_IS_SAMPLE	EQU	32	;przerwanie nastapilo z powodu zmierzenia
				;kolejnej probki

;============================================================================

;============================================================================
;
; bity w mapie modulow
;
LC0_MODAMAP	EQU	1	;modul A
LC0_MODBMAP	EQU	2	;modul B
LC0_MODCMAP	EQU	4	;modul C
LC0_MODDMAP	EQU	8	;modul D
LC0_MODAMASTER	EQU	16	;modul A - master
LC0_MODBMASTER	EQU	32	;modul B - master
LC0_MODCMASTER	EQU	64	;modul C - master
LC0_MODDMASTER	EQU	128	;modul D - master
;
; numery modulow
;
LC0_MODA	EQU	1	;modul A
LC0_MODB	EQU	2	;modul B
LC0_MODC	EQU	3	;modul C
LC0_MODD	EQU	4	;modul D
;
; kody urzadzen
;
LC0_DINPUT	EQU	1	;wejscie cyfrowe
LC0_DOUTPUT	EQU	2	;wyjscie cyfrowe
LC0_AINPUT	EQU	3	;wejscie analogowe
LC0_AOUTPUT	EQU	4	;wyjscie analogowe
LC0_CTC		EQU	5	;kanal CTC

;----------------------------------------------------------------------------
;
; bity trybu pracy funkcji ANALOG_INPUT i ANALOG_OUTPUT
;
LC0_MOD_START		EQU	  1	;start pomiarow
LC0_MOD_NEW_PAR		EQU	  2	;ustawienie nowych parametrow
LC0_MOD_SYNCHR		EQU	  4	;praca synchroniczna
LC0_MOD_ASYNCHR		EQU	  0	;praca asynchroniczna
LC0_MOD_INTR		EQU	  8	;praca z przerwaniami
LC0_MOD_INTR_TYPE	EQU	 10h	;bit trybu przerwan
LC0_MOD_ONE_INTR	EQU	 10h	;przerwanie co probka
LC0_MOD_END_INTR	EQU	  0	;przerwanie na koniec
LC0_MOD_BLOCK		EQU	 20h	;praca blokowa
LC0_MOD_SINGLE		EQU	  0	;praca pojedyncza
LC0_MOD_CYCL		EQU	 40h	;bufor cykliczny
LC0_MOD_FILE_W		EQU	 80h	;zapis do pliku
LC0_MOD_FILE_R		EQU	 80h	;odczyt z pliku
LC0_MOD_MEM_W		EQU	100h	;przepisanie do pamieci podstawowej
LC0_MOD_EXT_CLK		EQU	200h	;zegar zewnetrzny
LC0_MOD_EXT_MEM		EQU	400h	;bufor w pamieci rozszerzonej

;----------------------------------------------------------------------------
;
; warunki startu / stopu
;
;
; typy warunku startu:
;
LC0_SIMMED	EQU	0	;natychmiastowy
LC0_SHARD	EQU	1	;od sygnalu sprzetowego
LC0_SLEVEL	EQU	2	;od poziomu sygnalu cyfrowego
LC0_SSLOPE	EQU	3	;od zbocza sygnalu cyfrowego
LC0_SDIG_EQ	EQU	4	;od kombinacji bitow - rowne
LC0_SDIG_NE	EQU	5	;od kombinacji bitow - rozne
LC0_STIME	EQU	6	;po uplynieciu okreslonego czasu
LC0_SDATE	EQU	7	;o podanym czasie
LC0_SANALOG	EQU	8	;od sygnalu analogowego
;
; typy warunku stopu:
;
LC0_ZSAMPLES	EQU	00h	;po zmierzeniu okreslonej liczby probek
LC0_ZBREAK	EQU	10h	;po wykonaniu funkcji BREAK
LC0_ZLEVEL	EQU	20h	;od poziomu sygnalu cyfrowego
LC0_ZSLOPE	EQU	30h	;od zbocza sygnalu cyfrowego
LC0_ZDIG_EQ	EQU	40h	;od kombinacji bitow - rowne
LC0_ZDIG_NE	EQU	50h	;od kombinacji bitow - rozne
LC0_ZTIME	EQU	60h	;po uplynieciu okreslonego czasu
LC0_ZDATE	EQU	70h	;o podanym czasie
LC0_ZANALOG	EQU	80h	;od sygnalu analogowego

;
; opis warunku "poziom sygnalu cyfrowego"
;
LC0_COND_LEVEL	STRUC
LC0_CL_MOD	DB	?	;numer modulu
LC0_CL_PORT	DB	?	;numer portu
LC0_CL_INP	DB	?	;numer wejscia
LC0_CL_VALUE	DB	?	;oczekiwana wartosc
LC0_COND_LEVEL	ENDS

;
; opis warunku "zbocze sygnalu cyfrowego"
;
LC0_COND_SLOPE	STRUC
LC0_CS_MOD	DB	?	;numer modulu
LC0_CS_PORT	DB	?	;numer portu
LC0_CS_INP	DB	?	;numer wejscia
LC0_CS_VALUE	DB	?	;rodzaj zbocza
LC0_COND_SLOPE	ENDS
;
; kody rodzajow zbocza:
;
LC0_SLOPE_COND_UP	EQU	1	;narastajace
LC0_SLOPE_COND_DOWN	EQU	0	;opadajace

;
; opis warunku "kombinacja sygnalow cyfrowych (rowne/rozne)"
;
LC0_COND_DIG	STRUC
LC0_CD_MOD	DB	?	;numer modulu
LC0_CD_PORT	DB	?	;numer portu
LC0_CD_MASK	DB	?	;maska aktywnych wejsc
LC0_CD_PATTERN	DB	?	;testowany wzorzec
LC0_COND_DIG	ENDS

;
; opis warunku "data"
;
LC0_COND_DATE	STRUC
LC0_CD_SECOND	DB	?	;sekunda
LC0_CD_MINUTE	DB	?	;minuta
LC0_CD_HOUR	DB	?	;godzina
LC0_CD_DAY	DB	?	;dzien miesiaca; jezeli mniejszy niz biezacy
				;to nastepnego miesiaca
LC0_COND_DATE	ENDS

;
; opis warunku "sygnal analogowy"
;
LC0_COND_ANALOG		STRUC
LC0_CA_MOD		DB	?	;numer modulu
LC0_CA_CONVERTER	DB	?	;numer przetwornika
LC0_CA_CHANNEL		DB	?	;b1..b7 - numer kanalu
					;b8 - kod kierunku przekroczenia
					; 1 - w gore, 0 - w dol
LC0_CA_LEVEL		DW	?	;prog wyzwalania
LC0_COND_ANALOG		ENDS
;
; kody kierunku przekroczenia progu:
;
LC0_ANALOG_COND_UP	EQU	80h	;w kierunku wiekszych wartosci
LC0_ANALOG_COND_DOWN	EQU	0	;w kierunku mniejszych wartosci
LC0_ANALOG_COND_MASK	EQU	80h	;maska kodu kierunku
