/* TEST.C ******************************************************************/
/* Program przykladowy pokazujacy sposob wykorzystania drivera modulu      */
/* serii LC-011-0812 firmy AMBEX.                                          */
/***************************************************************************/
/* Program zostal przygotowany do kompilacji w kazdym modelu pamieci       */
/* (wymuszenie dalekich adresow przesylanych do driver'a).                 */
/* W katalogu zawierajacym standardowe naglowki C musi sie znajdowac plik  */
/* AMBEX-LC.H.                                                             */
/* UWAGA: Przed rozpoczeciem kompilacji nalezy sprawdzic ustawienie opcji  */
/*        kompilatora:                                                     */
/*              - alingment = byte,                                        */
/*              - default char type = signed.                              */
/***************************************************************************/

#include <ambex-lc.h>		/* struktury danych i definicje stalych do */
				/* komunikacji z driver'em                 */
#include <conio.h>		/* funkcja getch                           */
#include <dos.h>		/* funkcja int86                           */
#include <io.h>			/* dla funkcji driverinstalled             */
#include <stdio.h>		/* wyswietlanie                            */
#include <stdlib.h>		/* funkcja exit                            */

/******************** deklaracje procedur **********************************/
void	askdriver(void);
void	blocktransmission(void);
void	checkdrivers(void);
void	displaybuf(int *buf, int c, int s);
void	displayconfiguration(void);
void	drivererror(char status, char err_stat);
int	driverinstalled(char *name);
void	failblocktransmission(void);
void	installbreak(void);
void	interruptedbefore(void);
void	pressanykey(void);
void	quit(void);
void	singletransmission(void);
void	transmission(unsigned char start);

/******************** definicje stalych ************************************/
#define	TRUE		1
#define	FALSE		0
#define	BUFLEN		(8 * 20)		/* dlugosc bufora          */
#define	SAMPLES		20			/* liczba probek           */
#define	CHANNELS	8			/* liczba kanalow          */

/******************** deklaracje zmiennych *********************************/
int	LCinterrupt;		/* numer przerwania driver'a               */
				/* rekordy opisu poszczegolnych zlecen     */
struct	lc0_init		s_init        = {MODULE_INIT};
struct	lc0_total		s_total       = {GET_TOTAL_CONFIGURATION};
struct	lc0_module		s_module      = {GET_MODULE_CONFIGURATION};
struct	lc0_info		s_info        = {GET_INFO};
struct	lc0_break		s_break       = {BREAK};
struct	lc0_analog_in		s_analog_in   = {ANALOG_INPUT};
struct	lc0_leave		s_leave       = {LEAVE_DRIVER};
union	REGS	r;		/* parametr dla funkcji int86              */
int	modulenum;		/* numer badanego modulu                   */
				/* ------- teksty bledow                   */
char	*DriverErrors[] =
{
						/* LC0_UNKN_FUNC	-1 */
"LC0_UNKN_FUNC: Nieznany kod funkcji",
						/* LC0_NO_MODULE	-2 */
"LC0_NO_MODULE: Bledny numer modulu",
						/* LC0_BAD_DEV_TYP	-3 */
"LC0_BAD_DEV_TYP: Brak urzadzen danego typu",
						/* LC0_NONEX_DEV	-4 */
"LC0_NONEX_DEV: Bledny numer urzadzenia",
						/* LC0_BAD_FREQ		-5 */
"LC0_BAD_FREQ: Bledny okres",
						/* LC0_BAD_RANGE	-6 */
"LC0_BAD_RANGE: Bledny zakres napiec",
						/* LC0_NO_OPER		-7 */
"LC0_NO_OPER: Brak operacji w toku",
						/* LC0_BAD_MARGIN	-8 */
"LC0_BAD_MARGIN: Bledna dlugosc marginesu poczatkowego",
						/* LC0_BAD_BUF_ADR	-9 */
"LC0_BAD_BUF_ADR: Bledny adres bufora",
						/* LC0_BAD_BUF_LEN     -10 */
"LC0_BAD_BUF_LEN: Bledna dlugosc bufora",
						/* LC0_DEV_BUSY	       -11 */
"LC0_DEV_BUSY: Urzadzenie zajete",
						/* LC0_BAD_PER	       -12 */
"LC0_BAD_PER: Za krotki okres probkowania",
						/* LC0_BAD_CHAN_N      -13 */
"LC0_BAD_CHAN_N: Bledna liczba kanalow",
						/* LC0_BAD_CHAN	       -14 */
"LC0_BAD_CHAN: Bledny numer kanalu",
						/* LC0_BROKEN 	       -15 */
"LC0_BROKEN: Przetwarzanie przerwane funkcja BREAK",
						/* LC0_INTR_NOT_INST   -16 */
"LC0_INTR_INST: Procedura obslugi przerwania nie jest zainstalowana",
						/* LC0_ILL_START_CODE  -17 */
"LC0_ILL_START_CODE: Nielegalny sposob startu",
						/* LC0_ILL_STOP_CODE   -18 */
"LC0_ILL_STOP_CODE: Nielegalny sposob stopu",
						/* LC0_BAD_PROC	       -19 */
"LC0_BAD_PROC: Bledny adres procedury obslugi przerwania",
						/* LC0_TOO_LONG_MARG   -20 */
"LC0_TOO_LONG_MARG: Za dlugi margines poczatkowy",
						/* LC0_ILL_START       -21 */
"LC0_ILL_START: Bledne parametry warunku startu",
						/* LC0_ILL_STOP	       -22 */
"LC0_ILL_STOP: Bledne parametry warunku stopu",
						/* LC0_BAD_MNUM	       -23 */
"LC0_BAD_MNUM: Bledny numer pierwszej probki",
						/* LC0_NOT_SUPPORTED   -24 */
"LC0_NOT_SUPPORTED: Funkcja nie jest realizowana",
						/* LC0_BAD_CTC_MODE    -25 */
"LC0_BAD_CTC_MODE: Bledny tryb pracy CTC",
						/* LC0_NO_PARAMS       -26 */
"LC0_NO_PARAMS: Nie podano parametrow przetwarzania",
						/* LC0_OVERRUN	       -27 */
"LC0_OVERRUN: Blad OVERRUN",
						/* LC0_NO_DMA	       -28 */
"LC0_NO_DMA: Urzadzenie nie jest podlaczone do DMA",
						/* LC0_NO_IRQ	       -29 */
"LC0_NO_IRQ: Z modulem nie jest zwiazane zadne przerwanie",
						/* LC0_NOT_FULLY_SUP   -30 */
"LC0_NOT_FULLY_SUP: Funkcja w opracowaniu",
						/* LC0_NO_EXTMEM       -31 */
"LC0_NO_EXTMEM: Brak pamieci dodatkowej",
						/* LC0_NO_SEC_FREQ     -32 */
"LC0_NO_SEC_FREQ: Modul ma tylko jedna czestotliwosc",
						/* LC0_INTR_INST       -33 */
"LC0_INTR_INST: Procedura obslugi przerwania juz zainstalowana",
						/* LC0_BAD_PER2	       -34 */
"LC0_BAD_PER2: Bledna wielokrotnosc okresu probkowania",
						/* LC0_BAD_MODE	       -35 */
"LC0_BAD_MODE: Bledny tryb pracy",
						/* LC0_BAD_EXTMEM      -36 */
"LC0_BAD_EXTMEM: Bledny adres bufora w pamieci rozszerzonej",
						/* LC0_NOT_PROGRAMMED  -37 */
"LC0_CTC_NOT_PROGRAMMED: Zapis licznika przy niezaprogramowanym trybie pracy",
						/* LC0_REJECTED	       -38 */
"LC0_REJECTED: Za duzo jednoczesnych odwolan do driver'a",
};

				/* ------ teksty ostrzezen                */
char	*DriverWarnings[] =
{
						/* LC0_NON_EX_MOD	1 */
"LC0_NON_EX_MOD: Zazadano inicjalizacji nieistniejacych modulow",
						/* LC0_OTHER_LEN	2 */
"LC0_OTHER_LEN: Przepisano mniej probek niz zazadano",
						/* LC0_PREMATURE_END	3 */
"LC0_PREMATURE_END: Zakonczenie operacji z powodu przepelnienia bufora",
						/* LC0_IN_PROGRESS      4 */
"LC0_IN_PROGRESS: Badana transmisja jeszcze trwa",
};

				/* ------- teksty informacji dodatkowych  */
char	*DriverAdditionalErrors[] =
{
						/* LC0_E_NO_MODULE	-1 */
"LC0_E_NO_MODULE: Nie ma takiego modulu",
						/* LC0_E_NONEX_DEV	-2 */
"LC0_E_NONEX_DEV: Nie istnieje urzadzenie o tym numerze",
						/* LC0_E_BAD_CHAN	-3 */
"LC0_E_BAD_CHAN: Numer nieistniejacego kanalu",
						/* LC0_E_BAD_TIME	-4 */
"LC0_E_BAD_TIME: Zly odcinek czasu",
						/* LC0_E_BAD_DATE	-5 */
"LC0_E_BAD_DATE: Zla specyfikacja daty",
						/* LC0_E_BAD_THRE	-6 */
"LC0_E_BAD_THRE: Bledny prog wyzwalania analogowego",
						/* LC0_E_BROKEN_WAIT	-7 */
"LC0_E_BROKEN_WAIT: Przerwanie w trakcie oczekiwania na warunek startu",
						/* LC0_E_BROKEN_RUN	-8 */
"LC0_E_BROKEN_RUN: Przerwanie w trakcie przetwarzania",
						/* LC0_E_BAD_LEN        -9 */
"LC0_E_BAD_LEN: Zadeklarowano za duzo probek",
};

/***************************************************************************/
/***************************************************************************/
void main(void)
{
	checkdrivers();		/* rozpoznanie zainstalowanego driver'a    */
	askdriver();		/* odpytanie driver'a o konfiguracje       */
	displayconfiguration();	/* wyswietlenie konfiguracji modulu i      */
				/* toru a/c                                */
	installbreak();		/* zainstalowanie procedury obslugi        */
				/* przerwania generowanego przez Ctrl-Break*/
	pressanykey();		/* oczekiwanie na operatora                */
	blocktransmission();	/* wykonanie transmisji blokowej +         */
				/* wyswietlenie zmierzonych wartosci       */
	failblocktransmission();/* wykonanie blednej transmisji blokowej   */
	interruptedbefore();	/* wykonanie transmisji blokowej przerwanej*/
				/* przez operatora przed startem           */
	singletransmission();	/* wykonanie pomiaru w trybie pojedynczym  */
	quit();			/* zakonczenie programu                    */
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Rozpoznanie, czy driver jest zainstalowany.                           */
/* Uwagi:                                                                  */
/*   Funkcja dodatkowo wyswietla komunikat o testowanym module.            */
/*   Jezeli driver nie jest zainstalowany to po wyswietleniu wlasciwego    */
/*   komunikatu program konczy prace.                                      */
/***************************************************************************/
void checkdrivers(void)
{
	clrscr();
	gotoxy(1, 1);
	if(driverinstalled("LC1108^^"))
	    {
	    printf("Test modulu LC-011-0812\n");
	    LCinterrupt = LC011_08;
	    }
	else
	    {
	    printf("Driver nie jest zainstalowany!\n");
	    exit(1);
	    }
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Sprawdzenie obecnosci drivera.                                        */
/* Sposob:                                                                 */
/*   Przez probe otwarcia urzadzenia o nazwie okreslonej przez driver.     */
/* Parametry:                                                              */
/*   name - nazwa urzadzenia                                               */
/* Wartosc:                                                                */
/*   TRUE  - driver jest zainstalowany                                     */
/*   FALSE - driver nie jest zainstalowany                                 */
/***************************************************************************/
int driverinstalled(char *name)
{
	int	hd;

	hd = open(name, 0);
	if(hd == -1)
	    return(FALSE);
	else
	    {
	    close(hd);
	    return(TRUE);
	    }
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Rozpoznanie konfiguracji badanego modulu.                             */
/* Sposob:                                                                 */
/*   Przez wykorzystanie funkcji driver'a GET_TOTAL_CONFIGURATION,         */
/*   GET_MODULE_CONFIGURATION, GET_INFO.                                   */
/* Uwagi:                                                                  */
/*   Funkcja nadaje wartosc zmiennej modulenum (numer badanego modulu)     */
/*   wypelnia struktury total, module, info i inicjalizuje zainstalowane   */
/*    moduly.                                                              */
/***************************************************************************/
void askdriver(void)
{
	r.x.dx = FP_SEG(&s_total);
	r.x.di = FP_OFF(&s_total);
	int86(LCinterrupt, &r, &r);		/* GET_TOTAL_CONFIGURATION */

				/* inicjalizacja zainstalowanych modulow   */
	s_init.LC0_IMODULE = s_total.LC0_TONF & 0xF;
	r.x.dx = FP_SEG(&s_init);
	r.x.di = FP_OFF(&s_init);
	int86(LCinterrupt, &r, &r);			/* MODULE_INIT     */

					/* sprawdzenie, ktory modul jest   */
					/*   zainstalowany: A, B, C czy D  */
	for(modulenum = 1; modulenum <= 4; modulenum++)
	    if(s_total.LC0_TONF & (1 << (modulenum - 1)))
	    	break;

					/* spytanie o konfiguracje modulu  */
	s_module.LC0_MMODULE = modulenum;
	r.x.dx = FP_SEG(&s_module);
	r.x.di = FP_OFF(&s_module);
	int86(LCinterrupt, &r, &r);		/* GET_MODULE_CONFIGURATION*/

					/* spytanie o konfiguracje toru a/c*/
	s_info.LC0_GMODULE = modulenum;
	s_info.LC0_GTYPE   = LC0_AINPUT;
	s_info.LC0_GNUM    = 1;
	r.x.dx = FP_SEG(&s_info);
	r.x.di = FP_OFF(&s_info);
	int86(LCinterrupt, &r, &r);			/* GET_INFO        */
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Wyswietlenie konfiguracji badanego modulu i jego toru a/c.            */
/* Sposob:                                                                 */
/*   Przez wykorzystanie informacji zawartych w strukturach module i info. */
/***************************************************************************/
void displayconfiguration(void)
{
	int	i;
					/* konfiguracja modulu             */
	printf("\n---------- Konfiguracja modulu:\n\n");
	printf("Adres modulu: %04X (hex)\n", s_module.LC0_MBASE1);
	printf("Liczba przetwornikow a/c: %d\n", s_module.LC0_MIAD);
	printf("Liczba przetwornikow c/a: %d\n", s_module.LC0_MIDA);
	printf("Liczba portow cyfrowych wejsciowych: %d\n",
		s_module.LC0_MIDI);
	printf("Liczba portow cyfrowych wyjsciowych: %d\n",
		s_module.LC0_MIDO);
	printf("Czestotliwosc zegara modulu: %d MHz\n",
						s_module.LC0_MCLOCK / 1000);

					/* konfiguracja toru a/c           */
	printf("\n---------- Konfiguracja toru a/c:\n\n");
	printf("Liczba kanalow: %d\n", s_info.LC0_GCHAN);
	printf("Rozdzielczosc: %d bitow\n", s_info.LC0_GRES);
	printf("Zakres napiec: %.1f..%.1f V\n",
		(float)s_info.LC0_GMINV / 10,
		(float)s_info.LC0_GMAXV / 10);
	if(s_info.LC0_GDMA == 0xFF)
	    printf("Tor a/c nie jest podlaczony do kanalow DMA\n");
	else
	    printf("Numer kanalu DMA podlaczonego do toru a/c: %d\n",
							    s_info.LC0_GDMA);
	printf("Minimalne okresy probkowania [s]:\n");
	printf("     ");
	for(i = 0; i < s_info.LC0_GCHAN; i++)
	    {
	    printf("%.1f", (float)s_info.LC0_GMINP[i] / 10);
	    if(i < s_info.LC0_GCHAN - 1)
		{
	    	printf(", ");
		if((i + 1) % 8 == 0)
		    {
		    printf("\n");	/* zlamanie linii co 8 wielkosci   */
		    printf("     ");
		    }
		}
	    }
	printf("\n");
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Zainstalowanie procedury obslugi przerwania generowanego przez        */
/*   Ctrl-Break.                                                           */
/* Sposob:                                                                 */
/*   Przez wywolanie funkcji BREAK.                                        */
/***************************************************************************/
void installbreak(void)
{
	s_break.LC0_BMODE = LC0_BREAK_INST;
	s_break.LC0_BPROC = NULL;		/* podlozona zostanie      */
						/*   procedura driver'a    */
	r.x.dx = FP_SEG(&s_break);
	r.x.di = FP_OFF(&s_break);
	int86(LCinterrupt, &r, &r);			/* BREAK           */
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Przerwa miedzy kolejnymi czesciami programu - oczekiwanie na reakcje  */
/*   operatora.                                                            */
/***************************************************************************/
void pressanykey(void)
{
	printf("\nNacisnij dowolny klawisz . . .");
	getch();
	clrscr();
	gotoxy(1, 1);
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Wykonanie poprawnej transmisji blokowej i wyswietlenie zmierzonych    */
/*   wartosci.                                                             */
/* Sposob:                                                                 */
/*   Przez wykonanie funkcji transmission.                                 */
/***************************************************************************/
void blocktransmission(void)
{
	printf("---------- Poprawne przetwarzanie blokowe\n\n");
	s_analog_in.LC0_APER = (long)s_info.LC0_GMINP[CHANNELS - 1];
	transmission(LC0_SIMMED);
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Wykonanie blednej transmisji blokowej.                                */
/* Sposob:                                                                 */
/*   Przez wykonanie funkcji ANALOG_INPUT z okresem probkowania mniejszym  */
/*   niz minimalny wskazany przez driver.                                  */
/***************************************************************************/
void failblocktransmission(void)
{
	printf("---------- Bledne przetwarzanie blokowe\n\n");
	s_analog_in.LC0_APER = (long)s_info.LC0_GMINP[CHANNELS - 1] - 1;
	transmission(LC0_SIMMED);
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Wykonanie poprawnej transmisji blokowej ale przerwanej przez operatora*/
/*   (Ctrl-Break) w trakcie czekania na spelnienie warunku startu.         */
/* Sposob:                                                                 */
/*   Przez wykonanie funkcji ANALOG_INPUT z warunkiem startu LC0_STIME     */
/*   (start po okreslonym czasie) i parametrem tego warunku - 1000s.       */
/***************************************************************************/
void interruptedbefore(void)
{
	printf("---------- Przetwarzanie blokowe z oczekiwaniem 1000s\n");
	printf("---------- Oczekiwanie nalezy przerwac Ctrl-Break\n\n");
	s_analog_in.LC0_APER = (long)s_info.LC0_GMINP[CHANNELS - 1];
	s_analog_in.LC0_ASTART.time = 1000;
	transmission(LC0_STIME);
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Wykonanie pomiaru bloku probek za pomoca tranmsisji pojedynczej, przy */
/*   czym caly blok ma byc zmierzony po 10s od startu.                     */
/* Sposob:                                                                 */
/*   Przez wykonanie funkcji ANALOG_INPUT.                                 */
/* Parametry:                                                              */
/* Wartosc:                                                                */
/* Uwagi:                                                                  */
/***************************************************************************/
void singletransmission(void)
{
	int	buf[BUFLEN];		/* bufor na probki                 */
	int	i,
		j;

	printf("---------- Przetwarzanie pojedyncze - po 5 sekundach\n\n");
	s_analog_in.LC0_AMODULE = modulenum;
	s_analog_in.LC0_ANUM = 1;
	s_analog_in.LC0_AMODE = LC0_MOD_START |
			      LC0_MOD_NEW_PAR |
			      LC0_MOD_SINGLE;
				/* praca wielokanalowa, CHANNELS kanalow   */
	s_analog_in.LC0_ACHAN = CHANNELS;
	s_analog_in.LC0_AADDR = (int far *)buf; /* konieczna konwersja na  */
						/*   daleki adres          */
	s_analog_in.LC0_ALEN = CHANNELS;	/* dlugosc bufora (tylko   */
						/*   na jeden pomiar)      */
	s_analog_in.LC0_ASTST = LC0_STIME;
	s_analog_in.LC0_ASTART.time = 5;	/* start po 5 sekundach    */
	r.x.dx = FP_SEG(&s_analog_in);
	r.x.di = FP_OFF(&s_analog_in);
	int86(LCinterrupt, &r, &r);			/* ANALOG_INPUT    */
	s_analog_in.LC0_ASTST = LC0_SIMMED;
	i = 1;
	s_analog_in.LC0_AADDR = (int far *)&buf[i++ * CHANNELS];
	r.x.dx = FP_SEG(&s_analog_in);
	r.x.di = FP_OFF(&s_analog_in);
	int86(LCinterrupt, &r, &r);			/* ANALOG_INPUT    */
	s_analog_in.LC0_AMODE &= ~LC0_MOD_NEW_PAR;	/* zgaszenie bitu  */
							/* LC0_MOD_NEW_PAR */
	for(j = 0; j < 18; j++)
	    {
	    s_analog_in.LC0_AADDR = (int far *)&buf[i++ * CHANNELS];
	    r.x.dx = FP_SEG(&s_analog_in);
	    r.x.di = FP_OFF(&s_analog_in);
	    int86(LCinterrupt, &r, &r);			/* ANALOG_INPUT    */
	    }
	displaybuf(buf, CHANNELS, SAMPLES);
	pressanykey();
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Wykonanie transmisji blokowej.                                        */
/* Sposob:                                                                 */
/*   Przez wykonanie funkcji ANALOG_INPUT.                                 */
/* Parametry:                                                              */
/*   start - typ warunku startu                                            */
/* Wartosc:                                                                */
/* Uwagi:                                                                  */
/*   Funkcja wywolujaca musi ustawic okres probkowania i parametry warunku */
/*   startu.                                                               */
/***************************************************************************/
void transmission(unsigned char start)
{
	int	buf[BUFLEN];		/* bufor na probki                 */

	printf
	(
	"Pomiar blokowy, %d kanalow, %d probek, okres probkowania %.1f s:\n",
	CHANNELS, SAMPLES, (float)s_analog_in.LC0_APER / 10
	);
	switch(start)
	    {
	    case LC0_SIMMED:
	    	printf("Warunek startu: natychmiast\n");
		break;
	    case LC0_STIME:
	    	printf("Warunek startu: uplyw %lu sekund\n",
						s_analog_in.LC0_ASTART.time);
		break;
	    			/* pozostale warunki nie sa obslugiwane bo */
				/*   w programie nie sa wykorzystywane     */
	    }
	s_analog_in.LC0_AMODULE = modulenum;
	s_analog_in.LC0_ANUM = 1;
	s_analog_in.LC0_AMODE = LC0_MOD_START |
			      LC0_MOD_NEW_PAR |
			      LC0_MOD_SYNCHR |
			      LC0_MOD_BLOCK;
			/* stop po zmierzeniu okreslonej liczby probek     */
	s_analog_in.LC0_ASTST = start + LC0_ZSAMPLES;
				/* praca wielokanalowa, CHANNELS kanalow   */
	s_analog_in.LC0_ACHAN = CHANNELS;
	s_analog_in.LC0_AADDR = (int far *)buf;	/* konieczna konwersja na  */
						/*   daleki adres          */
	s_analog_in.LC0_ALEN = BUFLEN;	/* dlugosc bufora                  */
	s_analog_in.LC0_ABMAR = 0;
	s_analog_in.LC0_AEMAR = 0;	/* oba marginesy zerowe            */
					/* calkowita liczba probek         */
	s_analog_in.LC0_ASTOP.samples = SAMPLES * CHANNELS;
	r.x.dx = FP_SEG(&s_analog_in);
	r.x.di = FP_OFF(&s_analog_in);
	int86(LCinterrupt, &r, &r);			/* ANALOG_INPUT    */
	if(s_analog_in.LC0_STATUS != LC0_OK)
	    drivererror(s_analog_in.LC0_STATUS, s_analog_in.LC0_ERR_STAT);
	else
	    displaybuf(buf, CHANNELS, SAMPLES);
	pressanykey();
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Wyswietlenie bufora z danymi pomiarowymi.                             */
/* Parametry:                                                              */
/*   buf - adres bufora                                                    */
/*   c   - liczba kanalow                                                  */
/*   s   - liczba probek na kanal                                          */
/***************************************************************************/
void displaybuf(int *buf, int c, int s)
{
	int	i,
		j;

	for(i = 0; i < s; i++)
	    {
	    printf("%2d: ", i + 1);
	    for(j = 0; j < c; j++)
		printf("%04X  ", buf[i * c + j]);
	    printf("\n");
	    }
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Wypisanie komunikatow o bledzie / ostrzezeniu / dodatkowej informacji */
/*   bledzie.                                                              */
/* Parametry:                                                              */
/*   status   - LC0_STATUS                                                 */
/*   err_stat - LC0_ERR_STAT                                               */
/***************************************************************************/
void drivererror(char status, char err_stat)
{
	if(status > 0)
	    printf("--------- Ostrzezenie:\n%s\n",
	    	   DriverWarnings[status - 1]);
	else
	    printf("--------- Blad:\n%s\n", DriverErrors[-status - 1]);
	if(err_stat < 0)
	    printf("--------- Informacje dodatkowe:\n%s\n",
	    	   DriverAdditionalErrors[-err_stat - 1]);
}

/***************************************************************************/
/* Przeznaczenie:                                                          */
/*   Zakonczenie pracy programu.                                           */
/* Sposob:                                                                 */
/*   Przez wykonanie funkcji exit. Wczesniej - rozstanie sie z driver'em za*/
/*   pomoca funkcji LEAVE_DRIVER.                                          */
/***************************************************************************/
void quit(void)
{
	r.x.dx = FP_SEG(&s_leave);
	r.x.di = FP_OFF(&s_leave);
	int86(LCinterrupt, &r, &r);			/* LEAVE_DRIVER    */

	printf("Dziekuje, to wszystko!\n");
	exit(0);
}
